/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.Blockreader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.EndBiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.ImprovedNoiseGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.SimplexNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.settings.NoiseSettings;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.world.StructureSpawnManager;

public class AtumChunkGenerator
extends ChunkGenerator {
    public static final Codec<AtumChunkGenerator> CODEC = RecordCodecBuilder.create(c -> c.group((App)BiomeProvider.field_235202_a_.fieldOf("biome_source").forGetter(chunkGenerator -> chunkGenerator.field_222542_c), (App)DimensionSettings.field_236098_b_.fieldOf("settings").forGetter(chunkGenerator -> chunkGenerator.dimensionSettings)).apply((Applicative)c, c.stable(AtumChunkGenerator::new)));
    private static final float[] field_222561_h = (float[])Util.func_200696_a((Object)new float[13824], p_236094_0_ -> {
        for (int i = 0; i < 24; ++i) {
            for (int j = 0; j < 24; ++j) {
                for (int k = 0; k < 24; ++k) {
                    p_236094_0_[i * 24 * 24 + j * 24 + k] = (float)AtumChunkGenerator.func_222554_b(j - 12, k - 12, i - 12);
                }
            }
        }
    });
    private static final float[] field_236081_j_ = (float[])Util.func_200696_a((Object)new float[25], p_236092_0_ -> {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                p_236092_0_[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
    });
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private final int verticalNoiseGranularity;
    private final int horizontalNoiseGranularity;
    private final int noiseSizeX;
    private final int noiseSizeY;
    private final int noiseSizeZ;
    protected final SharedSeedRandom randomSeed;
    private final OctavesNoiseGenerator field_222568_o;
    private final OctavesNoiseGenerator field_222569_p;
    private final OctavesNoiseGenerator field_222570_q;
    private final INoiseGenerator surfaceDepthNoise;
    private final OctavesNoiseGenerator field_236082_u_;
    @Nullable
    private final SimplexNoiseGenerator field_236083_v_;
    protected final BlockState defaultBlock;
    protected final BlockState defaultFluid;
    private final long seed;
    protected final Supplier<DimensionSettings> dimensionSettings;
    private final int worldHeight;

    public AtumChunkGenerator(BiomeProvider biomeProvider, Supplier<DimensionSettings> dimensionSettings) {
        this(biomeProvider, biomeProvider, new Random().nextLong(), dimensionSettings);
    }

    private AtumChunkGenerator(BiomeProvider biomeProvider1, BiomeProvider biomeProvider2, long seed, Supplier<DimensionSettings> dimensionSettings) {
        super(biomeProvider1, biomeProvider2, dimensionSettings.get().func_236108_a_(), seed);
        this.seed = seed;
        DimensionSettings dimensionsettings = dimensionSettings.get();
        this.dimensionSettings = dimensionSettings;
        NoiseSettings noisesettings = dimensionsettings.func_236113_b_();
        this.worldHeight = noisesettings.func_236169_a_();
        this.verticalNoiseGranularity = noisesettings.func_236175_f_() * 4;
        this.horizontalNoiseGranularity = noisesettings.func_236174_e_() * 4;
        this.defaultBlock = dimensionsettings.func_236115_c_();
        this.defaultFluid = dimensionsettings.func_236116_d_();
        this.noiseSizeX = 16 / this.horizontalNoiseGranularity;
        this.noiseSizeY = noisesettings.func_236169_a_() / this.verticalNoiseGranularity;
        this.noiseSizeZ = 16 / this.horizontalNoiseGranularity;
        this.randomSeed = new SharedSeedRandom(seed);
        this.field_222568_o = new OctavesNoiseGenerator(this.randomSeed, IntStream.rangeClosed(-15, 0));
        this.field_222569_p = new OctavesNoiseGenerator(this.randomSeed, IntStream.rangeClosed(-15, 0));
        this.field_222570_q = new OctavesNoiseGenerator(this.randomSeed, IntStream.rangeClosed(-7, 0));
        this.surfaceDepthNoise = noisesettings.func_236178_i_() ? new PerlinNoiseGenerator(this.randomSeed, IntStream.rangeClosed(-3, 0)) : new OctavesNoiseGenerator(this.randomSeed, IntStream.rangeClosed(-3, 0));
        this.randomSeed.func_202423_a(2620);
        this.field_236082_u_ = new OctavesNoiseGenerator(this.randomSeed, IntStream.rangeClosed(-15, 0));
        if (noisesettings.func_236180_k_()) {
            SharedSeedRandom sharedseedrandom = new SharedSeedRandom(seed);
            sharedseedrandom.func_202423_a(17292);
            this.field_236083_v_ = new SimplexNoiseGenerator((Random)sharedseedrandom);
        } else {
            this.field_236083_v_ = null;
        }
    }

    @Nonnull
    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nonnull
    public ChunkGenerator func_230349_a_(long seed) {
        return new AtumChunkGenerator(this.field_222542_c.func_230320_a_(seed), this.dimensionSettings);
    }

    public boolean func_236088_a_(long p_236088_1_, RegistryKey<DimensionSettings> dimensionSettings) {
        return this.seed == p_236088_1_ && this.dimensionSettings.get().func_242744_a(dimensionSettings);
    }

    private double func_222552_a(int p_222552_1_, int p_222552_2_, int p_222552_3_, double p_222552_4_, double p_222552_6_, double p_222552_8_, double p_222552_10_) {
        double d0 = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        boolean flag = true;
        double d3 = 1.0;
        for (int i = 0; i < 16; ++i) {
            ImprovedNoiseGenerator improvednoisegenerator2;
            ImprovedNoiseGenerator improvednoisegenerator1;
            double d4 = OctavesNoiseGenerator.func_215461_a((double)((double)p_222552_1_ * p_222552_4_ * d3));
            double d5 = OctavesNoiseGenerator.func_215461_a((double)((double)p_222552_2_ * p_222552_6_ * d3));
            double d6 = OctavesNoiseGenerator.func_215461_a((double)((double)p_222552_3_ * p_222552_4_ * d3));
            double d7 = p_222552_6_ * d3;
            ImprovedNoiseGenerator improvednoisegenerator = this.field_222568_o.func_215463_a(i);
            if (improvednoisegenerator != null) {
                d0 += improvednoisegenerator.func_215456_a(d4, d5, d6, d7, (double)p_222552_2_ * d7) / d3;
            }
            if ((improvednoisegenerator1 = this.field_222569_p.func_215463_a(i)) != null) {
                d1 += improvednoisegenerator1.func_215456_a(d4, d5, d6, d7, (double)p_222552_2_ * d7) / d3;
            }
            if (i < 8 && (improvednoisegenerator2 = this.field_222570_q.func_215463_a(i)) != null) {
                d2 += improvednoisegenerator2.func_215456_a(OctavesNoiseGenerator.func_215461_a((double)((double)p_222552_1_ * p_222552_8_ * d3)), OctavesNoiseGenerator.func_215461_a((double)((double)p_222552_2_ * p_222552_10_ * d3)), OctavesNoiseGenerator.func_215461_a((double)((double)p_222552_3_ * p_222552_8_ * d3)), p_222552_10_ * d3, (double)p_222552_2_ * p_222552_10_ * d3) / d3;
            }
            d3 /= 2.0;
        }
        return MathHelper.func_151238_b((double)(d0 / 512.0), (double)(d1 / 512.0), (double)((d2 / 10.0 + 1.0) / 2.0));
    }

    private double[] func_222547_b(int noiseX, int noiseZ) {
        double[] noiseColumn = new double[this.noiseSizeY + 1];
        this.fillNoiseColumn(noiseColumn, noiseX, noiseZ);
        return noiseColumn;
    }

    private void fillNoiseColumn(double[] noiseColumn, int noiseX, int noiseZ) {
        double d1;
        double d0;
        NoiseSettings noisesettings = this.dimensionSettings.get().func_236113_b_();
        if (this.field_236083_v_ != null) {
            d0 = EndBiomeProvider.func_235317_a_((SimplexNoiseGenerator)this.field_236083_v_, (int)noiseX, (int)noiseZ) - 8.0f;
            d1 = d0 > 0.0 ? 0.25 : 1.0;
        } else {
            float f = 0.0f;
            float f1 = 0.0f;
            float f2 = 0.0f;
            int j = 63;
            float f3 = this.field_222542_c.func_225526_b_(noiseX, j, noiseZ).func_185355_j();
            for (int k = -2; k <= 2; ++k) {
                for (int l = -2; l <= 2; ++l) {
                    float f7;
                    float f6;
                    Biome biome = this.field_222542_c.func_225526_b_(noiseX + k, j, noiseZ + l);
                    float f4 = biome.func_185355_j();
                    float f5 = biome.func_185360_m();
                    if (noisesettings.func_236181_l_() && f4 > 0.0f) {
                        f6 = 1.0f + f4 * 2.0f;
                        f7 = 1.0f + f5 * 4.0f;
                    } else {
                        f6 = f4;
                        f7 = f5;
                    }
                    float f8 = f4 > f3 ? 0.5f : 1.0f;
                    float f9 = f8 * field_236081_j_[k + 2 + (l + 2) * 5] / (f6 + 2.0f);
                    f += f7 * f9;
                    f1 += f6 * f9;
                    f2 += f9;
                }
            }
            float f10 = f1 / f2;
            float f11 = f / f2;
            double d16 = f10 * 0.5f - 0.125f;
            double d18 = f11 * 0.9f + 0.1f;
            d0 = d16 * 0.265625;
            d1 = 96.0 / d18;
        }
        double d12 = 684.412 * noisesettings.func_236171_b_().func_236151_a_();
        double d13 = 684.412 * noisesettings.func_236171_b_().func_236153_b_();
        double d14 = d12 / noisesettings.func_236171_b_().func_236154_c_();
        double d15 = d13 / noisesettings.func_236171_b_().func_236155_d_();
        double d17 = noisesettings.func_236172_c_().func_236186_a_();
        double d19 = noisesettings.func_236172_c_().func_236188_b_();
        double d20 = noisesettings.func_236172_c_().func_236189_c_();
        double d21 = noisesettings.func_236173_d_().func_236186_a_();
        double d2 = noisesettings.func_236173_d_().func_236188_b_();
        double d3 = noisesettings.func_236173_d_().func_236189_c_();
        double d4 = noisesettings.func_236179_j_() ? this.func_236095_c_(noiseX, noiseZ) : 0.0;
        double d5 = noisesettings.func_236176_g_();
        double d6 = noisesettings.func_236177_h_();
        for (int i1 = 0; i1 <= this.noiseSizeY; ++i1) {
            double d7 = this.func_222552_a(noiseX, i1, noiseZ, d12, d13, d14, d15);
            double d8 = 1.0 - (double)i1 * 2.0 / (double)this.noiseSizeY + d4;
            double d9 = d8 * d5 + d6;
            double d10 = (d9 + d0) * d1;
            d7 = d10 > 0.0 ? (d7 += d10 * 4.0) : (d7 += d10);
            if (d19 > 0.0) {
                double d11 = ((double)(this.noiseSizeY - i1) - d20) / d19;
                d7 = MathHelper.func_151238_b((double)d17, (double)d7, (double)d11);
            }
            if (d2 > 0.0) {
                double d22 = ((double)i1 - d3) / d2;
                d7 = MathHelper.func_151238_b((double)d21, (double)d7, (double)d22);
            }
            noiseColumn[i1] = d7;
        }
    }

    private double func_236095_c_(int p_236095_1_, int p_236095_2_) {
        double d0 = this.field_236082_u_.func_215462_a((double)(p_236095_1_ * 200), 10.0, (double)(p_236095_2_ * 200), 1.0, 0.0, true);
        double d1 = d0 < 0.0 ? -d0 * 0.3 : d0;
        double d2 = d1 * 24.575625 - 2.0;
        return d2 < 0.0 ? d2 * 0.009486607142857142 : Math.min(d2, 1.0) * 0.006640625;
    }

    public int func_222529_a(int x, int z, Heightmap.Type heightmapType) {
        return this.func_236087_a_(x, z, null, heightmapType.func_222684_d());
    }

    @Nonnull
    public IBlockReader func_230348_a_(int p_230348_1_, int p_230348_2_) {
        BlockState[] states = new BlockState[this.noiseSizeY * this.verticalNoiseGranularity];
        this.func_236087_a_(p_230348_1_, p_230348_2_, states, null);
        return new Blockreader(states);
    }

    private int func_236087_a_(int noiseX, int noiseZ, @Nullable BlockState[] states, @Nullable Predicate<BlockState> predicate) {
        int i = Math.floorDiv(noiseX, this.horizontalNoiseGranularity);
        int j = Math.floorDiv(noiseZ, this.horizontalNoiseGranularity);
        int k = Math.floorMod(noiseX, this.horizontalNoiseGranularity);
        int l = Math.floorMod(noiseZ, this.horizontalNoiseGranularity);
        double d0 = (double)k / (double)this.horizontalNoiseGranularity;
        double d1 = (double)l / (double)this.horizontalNoiseGranularity;
        double[][] adouble = new double[][]{this.func_222547_b(i, j), this.func_222547_b(i, j + 1), this.func_222547_b(i + 1, j), this.func_222547_b(i + 1, j + 1)};
        for (int i1 = this.noiseSizeY - 1; i1 >= 0; --i1) {
            double d2 = adouble[0][i1];
            double d3 = adouble[1][i1];
            double d4 = adouble[2][i1];
            double d5 = adouble[3][i1];
            double d6 = adouble[0][i1 + 1];
            double d7 = adouble[1][i1 + 1];
            double d8 = adouble[2][i1 + 1];
            double d9 = adouble[3][i1 + 1];
            for (int j1 = this.verticalNoiseGranularity - 1; j1 >= 0; --j1) {
                double d10 = (double)j1 / (double)this.verticalNoiseGranularity;
                double d11 = MathHelper.func_219807_a((double)d10, (double)d0, (double)d1, (double)d2, (double)d6, (double)d4, (double)d8, (double)d3, (double)d7, (double)d5, (double)d9);
                int k1 = i1 * this.verticalNoiseGranularity + j1;
                BlockState state = this.getDefaultBlockAndFluid(d11, k1);
                if (states != null) {
                    states[k1] = state;
                }
                if (predicate == null || !predicate.test(state)) continue;
                return k1 + 1;
            }
        }
        return 0;
    }

    protected BlockState getDefaultBlockAndFluid(double horizontalNoise, int verticalNoise) {
        BlockState state = horizontalNoise > 0.0 ? this.defaultBlock : (verticalNoise < this.func_230356_f_() ? this.defaultFluid : AIR);
        return state;
    }

    public void func_225551_a_(@Nonnull WorldGenRegion genRegion, IChunk chunk) {
        ChunkPos chunkPos = chunk.func_76632_l();
        int x = chunkPos.field_77276_a;
        int j = chunkPos.field_77275_b;
        SharedSeedRandom seedRandom = new SharedSeedRandom();
        seedRandom.func_202422_a(x, j);
        ChunkPos chunkStartPos = chunk.func_76632_l();
        int xStart = chunkStartPos.func_180334_c();
        int zStart = chunkStartPos.func_180333_d();
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (int i1 = 0; i1 < 16; ++i1) {
            for (int j1 = 0; j1 < 16; ++j1) {
                int k1 = xStart + i1;
                int l1 = zStart + j1;
                int i2 = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, i1, j1) + 1;
                double d1 = this.surfaceDepthNoise.func_215460_a((double)k1 * 0.0625, (double)l1 * 0.0625, 0.0625, (double)i1 * 0.0625) * 15.0;
                BlockPos.Mutable biomePos = mutablePos.func_181079_c(xStart + i1, i2, zStart + j1);
                genRegion.func_226691_t_((BlockPos)biomePos).func_206854_a((Random)seedRandom, chunk, k1, l1, i2, d1, this.defaultBlock, this.defaultFluid, this.func_230356_f_(), genRegion.func_72905_C());
            }
        }
        this.makeBedrock(chunk, (Random)seedRandom);
    }

    private void makeBedrock(IChunk chunk, Random rand) {
        boolean flag1;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        int x = chunk.func_76632_l().func_180334_c();
        int j = chunk.func_76632_l().func_180333_d();
        DimensionSettings dimensionsettings = this.dimensionSettings.get();
        int k = dimensionsettings.func_236118_f_();
        int l = this.worldHeight - 1 - dimensionsettings.func_236117_e_();
        int i1 = 5;
        boolean flag = l + 4 >= 0 && l < this.worldHeight;
        boolean bl = flag1 = k + 4 >= 0 && k < this.worldHeight;
        if (flag || flag1) {
            for (BlockPos blockpos : BlockPos.func_191531_b((int)x, (int)0, (int)j, (int)(x + 15), (int)0, (int)(j + 15))) {
                if (flag) {
                    for (int j1 = 0; j1 < 5; ++j1) {
                        if (j1 > rand.nextInt(5)) continue;
                        chunk.func_177436_a((BlockPos)blockpos$mutable.func_181079_c(blockpos.func_177958_n(), l - j1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
                    }
                }
                if (!flag1) continue;
                for (int k1 = 4; k1 >= 0; --k1) {
                    if (k1 > rand.nextInt(5)) continue;
                    chunk.func_177436_a((BlockPos)blockpos$mutable.func_181079_c(blockpos.func_177958_n(), k + k1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
                }
            }
        }
    }

    public void func_230352_b_(@Nonnull IWorld world, @Nonnull StructureManager manager, IChunk chunk) {
        ObjectArrayList objectlist = new ObjectArrayList(10);
        ObjectArrayList objectlist1 = new ObjectArrayList(32);
        ChunkPos chunkpos = chunk.func_76632_l();
        int x = chunkpos.field_77276_a;
        int j = chunkpos.field_77275_b;
        int k = x << 4;
        int l = j << 4;
        for (Structure structure : Structure.field_236384_t_) {
            manager.func_235011_a_(SectionPos.func_218156_a((ChunkPos)chunkpos, (int)0), structure).forEach(arg_0 -> AtumChunkGenerator.lambda$func_230352_b_$5(chunkpos, (ObjectList)objectlist, k, l, (ObjectList)objectlist1, arg_0));
        }
        double[][][] adouble = new double[2][this.noiseSizeZ + 1][this.noiseSizeY + 1];
        for (int i5 = 0; i5 < this.noiseSizeZ + 1; ++i5) {
            adouble[0][i5] = new double[this.noiseSizeY + 1];
            this.fillNoiseColumn(adouble[0][i5], x * this.noiseSizeX, j * this.noiseSizeZ + i5);
            adouble[1][i5] = new double[this.noiseSizeY + 1];
        }
        ChunkPrimer chunkprimer = (ChunkPrimer)chunk;
        Heightmap heightmap = chunkprimer.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = chunkprimer.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        ObjectListIterator objectlistiterator = objectlist.iterator();
        ObjectListIterator objectlistiterator1 = objectlist1.iterator();
        for (int i1 = 0; i1 < this.noiseSizeX; ++i1) {
            for (int j1 = 0; j1 < this.noiseSizeZ + 1; ++j1) {
                this.fillNoiseColumn(adouble[1][j1], x * this.noiseSizeX + i1 + 1, j * this.noiseSizeZ + j1);
            }
            for (int j5 = 0; j5 < this.noiseSizeZ; ++j5) {
                ChunkSection chunksection = chunkprimer.func_217332_a(15);
                chunksection.func_222635_a();
                for (int k1 = this.noiseSizeY - 1; k1 >= 0; --k1) {
                    double d0 = adouble[0][j5][k1];
                    double d1 = adouble[0][j5 + 1][k1];
                    double d2 = adouble[1][j5][k1];
                    double d3 = adouble[1][j5 + 1][k1];
                    double d4 = adouble[0][j5][k1 + 1];
                    double d5 = adouble[0][j5 + 1][k1 + 1];
                    double d6 = adouble[1][j5][k1 + 1];
                    double d7 = adouble[1][j5 + 1][k1 + 1];
                    for (int l1 = this.verticalNoiseGranularity - 1; l1 >= 0; --l1) {
                        int i2 = k1 * this.verticalNoiseGranularity + l1;
                        int j2 = i2 & 0xF;
                        int k2 = i2 >> 4;
                        if (chunksection.func_222632_g() >> 4 != k2) {
                            chunksection.func_222637_b();
                            chunksection = chunkprimer.func_217332_a(k2);
                            chunksection.func_222635_a();
                        }
                        double d8 = (double)l1 / (double)this.verticalNoiseGranularity;
                        double d9 = MathHelper.func_219803_d((double)d8, (double)d0, (double)d4);
                        double d10 = MathHelper.func_219803_d((double)d8, (double)d2, (double)d6);
                        double d11 = MathHelper.func_219803_d((double)d8, (double)d1, (double)d5);
                        double d12 = MathHelper.func_219803_d((double)d8, (double)d3, (double)d7);
                        for (int l2 = 0; l2 < this.horizontalNoiseGranularity; ++l2) {
                            int i3 = k + i1 * this.horizontalNoiseGranularity + l2;
                            int j3 = i3 & 0xF;
                            double d13 = (double)l2 / (double)this.horizontalNoiseGranularity;
                            double d14 = MathHelper.func_219803_d((double)d13, (double)d9, (double)d10);
                            double d15 = MathHelper.func_219803_d((double)d13, (double)d11, (double)d12);
                            for (int k3 = 0; k3 < this.horizontalNoiseGranularity; ++k3) {
                                int k4;
                                int j4;
                                int l3 = l + j5 * this.horizontalNoiseGranularity + k3;
                                int i4 = l3 & 0xF;
                                double d16 = (double)k3 / (double)this.horizontalNoiseGranularity;
                                double d17 = MathHelper.func_219803_d((double)d16, (double)d14, (double)d15);
                                double d18 = MathHelper.func_151237_a((double)(d17 / 200.0), (double)-1.0, (double)1.0);
                                d18 = d18 / 2.0 - d18 * d18 * d18 / 24.0;
                                while (objectlistiterator.hasNext()) {
                                    StructurePiece structurepiece = (StructurePiece)objectlistiterator.next();
                                    MutableBoundingBox mutableboundingbox = structurepiece.func_74874_b();
                                    j4 = Math.max(0, Math.max(mutableboundingbox.field_78897_a - i3, i3 - mutableboundingbox.field_78893_d));
                                    k4 = i2 - (mutableboundingbox.field_78895_b + (structurepiece instanceof AbstractVillagePiece ? ((AbstractVillagePiece)structurepiece).func_214830_d() : 0));
                                    int l4 = Math.max(0, Math.max(mutableboundingbox.field_78896_c - l3, l3 - mutableboundingbox.field_78892_f));
                                    d18 += AtumChunkGenerator.func_222556_a(j4, k4, l4) * 0.8;
                                }
                                objectlistiterator.back(objectlist.size());
                                while (objectlistiterator1.hasNext()) {
                                    JigsawJunction jigsawjunction = (JigsawJunction)objectlistiterator1.next();
                                    int k5 = i3 - jigsawjunction.func_214895_a();
                                    j4 = i2 - jigsawjunction.func_214896_b();
                                    k4 = l3 - jigsawjunction.func_214893_c();
                                    d18 += AtumChunkGenerator.func_222556_a(k5, j4, k4) * 0.4;
                                }
                                objectlistiterator1.back(objectlist1.size());
                                BlockState blockstate = this.getDefaultBlockAndFluid(d18, i2);
                                if (blockstate == AIR) continue;
                                mutablePos.func_181079_c(i3, i2, l3);
                                if (blockstate.getLightValue((IBlockReader)chunkprimer, (BlockPos)mutablePos) != 0) {
                                    chunkprimer.func_201637_h((BlockPos)mutablePos);
                                }
                                chunksection.func_177484_a(j3, j2, i4, blockstate, false);
                                heightmap.func_202270_a(j3, i2, i4, blockstate);
                                heightmap1.func_202270_a(j3, i2, i4, blockstate);
                            }
                        }
                    }
                }
                chunksection.func_222637_b();
            }
            double[][] adouble1 = adouble[0];
            adouble[0] = adouble[1];
            adouble[1] = adouble1;
        }
    }

    private static double func_222556_a(int p_222556_0_, int p_222556_1_, int p_222556_2_) {
        int i = p_222556_0_ + 12;
        int j = p_222556_1_ + 12;
        int k = p_222556_2_ + 12;
        if (i >= 0 && i < 24) {
            if (j >= 0 && j < 24) {
                return k >= 0 && k < 24 ? (double)field_222561_h[k * 24 * 24 + i * 24 + j] : 0.0;
            }
            return 0.0;
        }
        return 0.0;
    }

    private static double func_222554_b(int p_222554_0_, int p_222554_1_, int p_222554_2_) {
        double d0 = p_222554_0_ * p_222554_0_ + p_222554_2_ * p_222554_2_;
        double d1 = (double)p_222554_1_ + 0.5;
        double d2 = d1 * d1;
        double d3 = Math.pow(Math.E, -(d2 / 16.0 + d0 / 16.0));
        double d4 = -d1 * MathHelper.func_181161_i((double)(d2 / 2.0 + d0 / 2.0)) / 2.0;
        return d4 * d3;
    }

    public int func_230355_e_() {
        return this.worldHeight;
    }

    public int func_230356_f_() {
        return this.dimensionSettings.get().func_236119_g_();
    }

    @Nonnull
    public List<MobSpawnInfo.Spawners> func_230353_a_(@Nonnull Biome biome, @Nonnull StructureManager manager, @Nonnull EntityClassification entityClassification, @Nonnull BlockPos pos) {
        List spawns = StructureSpawnManager.getStructureSpawns((StructureManager)manager, (EntityClassification)entityClassification, (BlockPos)pos);
        if (spawns != null) {
            return spawns;
        }
        return super.func_230353_a_(biome, manager, entityClassification, pos);
    }

    public void func_230354_a_(WorldGenRegion genRegion) {
        int x = genRegion.func_201679_a();
        int z = genRegion.func_201680_b();
        Biome biome = genRegion.func_226691_t_(new ChunkPos(x, z).func_206849_h());
        SharedSeedRandom randomSeed = new SharedSeedRandom();
        randomSeed.func_202424_a(genRegion.func_72905_C(), x << 4, z << 4);
        WorldEntitySpawner.func_77191_a((IServerWorld)genRegion, (Biome)biome, (int)x, (int)z, (Random)randomSeed);
    }

    private static /* synthetic */ void lambda$func_230352_b_$5(ChunkPos chunkpos, ObjectList objectlist, int k, int l, ObjectList objectlist1, StructureStart p_236089_5_) {
        for (StructurePiece structurepiece1 : p_236089_5_.func_186161_c()) {
            if (!structurepiece1.func_214810_a(chunkpos, 12)) continue;
            if (structurepiece1 instanceof AbstractVillagePiece) {
                AbstractVillagePiece abstractvillagepiece = (AbstractVillagePiece)structurepiece1;
                JigsawPattern.PlacementBehaviour jigsawpattern$placementbehaviour = abstractvillagepiece.func_214826_b().func_214854_c();
                if (jigsawpattern$placementbehaviour == JigsawPattern.PlacementBehaviour.RIGID) {
                    objectlist.add((Object)abstractvillagepiece);
                }
                for (JigsawJunction jigsawjunction1 : abstractvillagepiece.func_214829_e()) {
                    int l5 = jigsawjunction1.func_214895_a();
                    int i6 = jigsawjunction1.func_214893_c();
                    if (l5 <= k - 12 || i6 <= l - 12 || l5 >= k + 15 + 12 || i6 >= l + 15 + 12) continue;
                    objectlist1.add((Object)jigsawjunction1);
                }
                continue;
            }
            objectlist.add((Object)structurepiece1);
        }
    }
}

