/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen;

import com.teammetallurgy.atum.api.AtumAPI;
import com.teammetallurgy.atum.blocks.stone.limestone.LimestoneBlock;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumFeatures;
import com.teammetallurgy.atum.init.AtumStructures;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.world.gen.carver.AtumCarvers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.DepthAverageConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;

public class AtumDefaultFeatures {
    public static final RuleTest NATURAL_STONE = new TagMatchRuleTest(AtumAPI.Tags.BASE_STONE_ATUM);
    public static final RuleTest LIMESTONE_CRACKED = new BlockMatchRuleTest(AtumBlocks.LIMESTONE_CRACKED);

    public static void addCarvers(BiomeGenerationSettings.Builder builder) {
        builder.func_242512_a(GenerationStage.Carving.AIR, AtumCarvers.CAVE_CONFIGURED);
        builder.func_242512_a(GenerationStage.Carving.AIR, AtumCarvers.CANYON_CONFIGURED);
    }

    public static void addSandLayer(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, AtumFeatures.SAND_LAYER.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
    }

    public static void addSurfaceLavaLake(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.LAKES, AtumFeatures.SURFACE_LAVA_LAKE.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(Blocks.field_150353_l.func_176223_P())).func_227228_a_(Placement.field_215005_D.func_227446_a_((IPlacementConfig)new ChanceConfig(80))));
    }

    public static void addSprings(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202295_ao.func_225566_b_((IFeatureConfig)AtumFeatures.WATER_SPRING_CONFIG).func_227228_a_((ConfiguredPlacement)((ConfiguredPlacement)Placement.field_242908_m.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(8, 8, 50)).func_242728_a()).func_242731_b(14)));
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202295_ao.func_225566_b_((IFeatureConfig)AtumFeatures.LAVA_SPRING_CONFIG).func_227228_a_((ConfiguredPlacement)((ConfiguredPlacement)Placement.field_242909_n.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(8, 16, 256)).func_242728_a()).func_242731_b(8)));
    }

    public static void addMaterialPockets(BiomeGenerationSettings.Builder builder) {
        if ((Integer)AtumConfig.WORLD_GEN.sandCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.SAND.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.sandVeinSize.get()).intValue())).func_242733_d(((Integer)AtumConfig.WORLD_GEN.sandMaxHeight.get()).intValue())).func_242728_a()).func_242731_b(((Integer)AtumConfig.WORLD_GEN.sandCount.get()).intValue()));
        }
        if ((Integer)AtumConfig.WORLD_GEN.limestoneGravelCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.LIMESTONE_GRAVEL.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.limestoneGravelVeinSize.get()).intValue())).func_242733_d(((Integer)AtumConfig.WORLD_GEN.limestoneGravelMaxHeight.get()).intValue())).func_242728_a()).func_242731_b(((Integer)AtumConfig.WORLD_GEN.limestoneGravelCount.get()).intValue()));
        }
        if ((Integer)AtumConfig.WORLD_GEN.marlCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.MARL.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.marlVeinSize.get()).intValue())).func_242733_d(((Integer)AtumConfig.WORLD_GEN.marlMaxHeight.get()).intValue())).func_242728_a()).func_242731_b(((Integer)AtumConfig.WORLD_GEN.marlCount.get()).intValue()));
        }
    }

    public static void addStoneVariants(BiomeGenerationSettings.Builder builder) {
        if ((Integer)AtumConfig.WORLD_GEN.alabasterCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.ALABASTER.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.alabasterVeinSize.get()).intValue())).func_242733_d(((Integer)AtumConfig.WORLD_GEN.alabasterMaxHeight.get()).intValue())).func_242728_a()).func_242731_b(((Integer)AtumConfig.WORLD_GEN.alabasterCount.get()).intValue()));
        }
        if ((Integer)AtumConfig.WORLD_GEN.porphyryCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.PORPHYRY.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.porphyryVeinSize.get()).intValue())).func_242733_d(((Integer)AtumConfig.WORLD_GEN.porphyryMaxHeight.get()).intValue())).func_242728_a()).func_242731_b(((Integer)AtumConfig.WORLD_GEN.porphyryCount.get()).intValue()));
        }
    }

    public static void addOres(BiomeGenerationSettings.Builder builder) {
        if ((Integer)AtumConfig.WORLD_GEN.coalCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.COAL_ORE.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.coalVeinSize.get()).intValue())).func_242733_d(((Integer)AtumConfig.WORLD_GEN.coalMaxHeight.get()).intValue())).func_242728_a()).func_242731_b(((Integer)AtumConfig.WORLD_GEN.coalCount.get()).intValue()));
        }
        if ((Integer)AtumConfig.WORLD_GEN.ironCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.IRON_ORE.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.ironVeinSize.get()).intValue())).func_242733_d(((Integer)AtumConfig.WORLD_GEN.ironMaxHeight.get()).intValue())).func_242728_a()).func_242731_b(((Integer)AtumConfig.WORLD_GEN.ironCount.get()).intValue()));
        }
        if ((Integer)AtumConfig.WORLD_GEN.goldCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.GOLD_ORE.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.goldVeinSize.get()).intValue())).func_242733_d(((Integer)AtumConfig.WORLD_GEN.goldMaxHeight.get()).intValue())).func_242728_a()).func_242731_b(((Integer)AtumConfig.WORLD_GEN.goldCount.get()).intValue()));
        }
        if ((Integer)AtumConfig.WORLD_GEN.redstoneCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.REDSTONE_ORE.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.redstoneVeinSize.get()).intValue())).func_242733_d(((Integer)AtumConfig.WORLD_GEN.redstoneMaxHeight.get()).intValue())).func_242728_a()).func_242731_b(((Integer)AtumConfig.WORLD_GEN.redstoneCount.get()).intValue()));
        }
        if ((Integer)AtumConfig.WORLD_GEN.diamondCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.DIAMOND_ORE.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.diamondVeinSize.get()).intValue())).func_242733_d(((Integer)AtumConfig.WORLD_GEN.diamondMaxHeight.get()).intValue())).func_242728_a()).func_242731_b(((Integer)AtumConfig.WORLD_GEN.diamondCount.get()).intValue()));
        }
        if ((Integer)AtumConfig.WORLD_GEN.lapisBaseline.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.LAPIS_ORE.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.lapisVeinSize.get()).intValue())).func_227228_a_(Placement.field_242910_o.func_227446_a_((IPlacementConfig)new DepthAverageConfig(((Integer)AtumConfig.WORLD_GEN.lapisBaseline.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.lapisSpread.get()).intValue()))));
        }
        if ((Integer)AtumConfig.WORLD_GEN.khnumiteCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.KHNUMITE_RAW.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.khnumiteVeinSize.get()).intValue())).func_242733_d(((Integer)AtumConfig.WORLD_GEN.khnumiteMaxHeight.get()).intValue())).func_242728_a()).func_242731_b(((Integer)AtumConfig.WORLD_GEN.khnumiteCount.get()).intValue()));
        }
        if ((Integer)AtumConfig.WORLD_GEN.boneOreCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.BONE_ORE.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.boneOreVeinSize.get()).intValue())).func_242733_d(((Integer)AtumConfig.WORLD_GEN.boneOreMaxHeight.get()).intValue())).func_242728_a()).func_242731_b(((Integer)AtumConfig.WORLD_GEN.boneOreCount.get()).intValue()));
        }
        if ((Integer)AtumConfig.WORLD_GEN.relicOreCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.RELIC_ORE.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.relicOreVeinSize.get()).intValue())).func_242733_d(((Integer)AtumConfig.WORLD_GEN.relicOreMaxHeight.get()).intValue())).func_242728_a()).func_242731_b(((Integer)AtumConfig.WORLD_GEN.relicOreCount.get()).intValue()));
        }
        if ((Integer)AtumConfig.WORLD_GEN.nebuCount.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.NEBU_ORE.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.nebuVeinSize.get()).intValue())).func_242733_d(((Integer)AtumConfig.WORLD_GEN.nebuMaxHeight.get()).intValue())).func_242728_a()).func_242731_b(((Integer)AtumConfig.WORLD_GEN.nebuCount.get()).intValue()));
        }
    }

    public static void addEmeraldOre(BiomeGenerationSettings.Builder builder) {
        if (((Boolean)AtumConfig.WORLD_GEN.emeraldEnabled.get()).booleanValue()) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202294_an.func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(AtumBlocks.LIMESTONE.func_176223_P(), AtumBlocks.EMERALD_ORE.func_176223_P())).func_227228_a_(Placement.field_215004_C.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        }
    }

    public static void addInfestedLimestone(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, (BlockState)AtumBlocks.LIMESTONE.func_176223_P().func_206870_a((Property)LimestoneBlock.HAS_SCARAB, (Comparable)Boolean.valueOf(true)), 10)).func_227228_a_((ConfiguredPlacement)((ConfiguredPlacement)Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(0, 11, 80)).func_242728_a()).func_242731_b(8)));
    }

    public static void addShrubs(BiomeGenerationSettings.Builder builder) {
        if ((Integer)AtumConfig.WORLD_GEN.shrubFrequency.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)AtumFeatures.SHRUB_CONFIG).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(((Integer)AtumConfig.WORLD_GEN.shrubFrequency.get()).intValue()));
            builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)AtumFeatures.WEED_CONFIG).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(((Integer)AtumConfig.WORLD_GEN.shrubFrequency.get()).intValue()));
        }
    }

    public static void addFossils(BiomeGenerationSettings.Builder builder) {
        if ((Integer)AtumConfig.WORLD_GEN.fossilsChance.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, (ConfiguredFeature)AtumFeatures.DIRTY_BONE_FOSSILS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242729_a(((Integer)AtumConfig.WORLD_GEN.fossilsChance.get()).intValue()));
        }
    }

    public static void addDungeon(BiomeGenerationSettings.Builder builder) {
        if ((Integer)AtumConfig.WORLD_GEN.dungeonChance.get() > 0) {
            builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)AtumFeatures.LIMESTONE_DUNGEONS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_242733_d(256)).func_242728_a()).func_242731_b(((Integer)AtumConfig.WORLD_GEN.dungeonChance.get()).intValue()));
        }
    }

    public static void addDeadwoodTrees(BiomeGenerationSettings.Builder builder, int count, float extraChance, int extraCount) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, AtumFeatures.DEADWOOD_FEATURE.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(count, extraChance, extraCount))));
    }

    public static void addTomb(BiomeGenerationSettings.Builder builder) {
        builder.func_242516_a(AtumStructures.TOMB_FEATURE);
    }

    public static void addPyramid(BiomeGenerationSettings.Builder builder) {
        builder.func_242516_a(AtumStructures.PYRAMID_FEATURE);
    }

    public static void addRuins(BiomeGenerationSettings.Builder builder) {
        builder.func_242516_a(AtumStructures.RUIN_FEATURE);
    }

    public static void addGatehouse(BiomeGenerationSettings.Builder builder) {
        builder.func_242516_a(AtumStructures.GATEHOUSE_FEATURE);
    }

    public static void addGenericVillage(BiomeGenerationSettings.Builder builder) {
        builder.func_242516_a(AtumStructures.GENERIC_VILLAGE);
    }

    public static void addMineshaft(BiomeGenerationSettings.Builder builder, boolean isSurface) {
        if ((Double)AtumConfig.WORLD_GEN.mineshaftProbability.get() > 0.0) {
            if (isSurface) {
                builder.func_242516_a(AtumStructures.MINESHAFT_DEADWOOD_SURFACE_FEATURE);
                builder.func_242516_a(AtumStructures.MINESHAFT_LIMESTONE_SURFACE_FEATURE);
            } else {
                builder.func_242516_a(AtumStructures.MINESHAFT_DEADWOOD_FEATURE);
                builder.func_242516_a(AtumStructures.MINESHAFT_LIMESTONE_FEATURE);
            }
        }
    }
}

