/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.feature;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.teammetallurgy.atum.blocks.wood.DeadwoodBranchBlock;
import com.teammetallurgy.atum.blocks.wood.DeadwoodLogBlock;
import com.teammetallurgy.atum.init.AtumBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DeadwoodFeature
extends Feature<NoFeatureConfig> {
    private static final BlockState LOG = (BlockState)AtumBlocks.DEADWOOD_LOG.func_176223_P().func_206870_a((Property)DeadwoodLogBlock.HAS_SCARAB, (Comparable)Boolean.valueOf(true));
    private static final BlockState BRANCH = AtumBlocks.DEADWOOD_BRANCH.func_176223_P();

    public DeadwoodFeature(Codec<NoFeatureConfig> config) {
        super(config);
    }

    public boolean generate(@Nonnull ISeedReader genReader, @Nonnull ChunkGenerator generator, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull NoFeatureConfig config) {
        if (genReader instanceof WorldGenRegion) {
            WorldGenRegion world = (WorldGenRegion)genReader;
            HashSet logs = Sets.newHashSet();
            int baseHeight = rand.nextInt(5) + 3;
            boolean generate = true;
            if (pos.func_177956_o() >= 0 && pos.func_177956_o() + baseHeight + 1 <= world.func_217301_I()) {
                boolean isSoil;
                for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + 1 + baseHeight; ++y) {
                    int k = 1;
                    if (y == pos.func_177956_o()) {
                        k = 0;
                    }
                    if (y >= pos.func_177956_o() + 1 + baseHeight - 2) {
                        k = 2;
                    }
                    BlockPos.Mutable mutable = new BlockPos.Mutable();
                    for (int x = pos.func_177958_n() - k; x <= pos.func_177958_n() + k && generate; ++x) {
                        for (int z = pos.func_177952_p() - k; z <= pos.func_177952_p() + k && generate; ++z) {
                            if (y >= 0 && y < world.func_217301_I()) {
                                BlockPos.Mutable checkPos = mutable.func_181079_c(x, y, z);
                                if (TreeFeature.func_236412_d_((IWorldGenerationBaseReader)world, (BlockPos)checkPos)) continue;
                                generate = false;
                                continue;
                            }
                            generate = false;
                        }
                    }
                }
                if (!generate) {
                    return false;
                }
                BlockPos down = pos.func_177977_b();
                BlockState state = world.func_180495_p(down);
                boolean bl = isSoil = state.func_177230_c() == AtumBlocks.SAND;
                if (genReader.isAreaLoaded(pos, 16)) {
                    if (isSoil && pos.func_177956_o() < world.func_217301_I() - baseHeight - 1) {
                        for (int height = 0; height < baseHeight; ++height) {
                            BlockPos upN = pos.func_177981_b(height);
                            if (!TreeFeature.func_236412_d_((IWorldGenerationBaseReader)genReader, (BlockPos)upN)) continue;
                            genReader.func_180501_a(pos.func_177981_b(height), LOG, 19);
                            if (height <= 1) continue;
                            logs.add(pos.func_177981_b(height));
                        }
                        this.buildBranches((IWorldReader)world, (IWorldGenerationReader)genReader, logs, rand);
                        return true;
                    }
                    return false;
                }
                return false;
            }
        }
        return false;
    }

    public void buildBranches(IWorldReader world, IWorldGenerationReader genReader, Set<BlockPos> logs, Random random) {
        LinkedList<ImmutablePair> queue = new LinkedList<ImmutablePair>();
        ArrayList<BlockPos> placedBranches = new ArrayList<BlockPos>();
        for (BlockPos pos : logs) {
            queue.add(new ImmutablePair((Object)pos, (Object)0));
        }
        BlockPos baseLog = (BlockPos)((Pair)queue.peek()).getLeft();
        int count = 0;
        HashSet<Direction> choosenFacings = new HashSet<Direction>();
        HashMap<Direction, Integer> balancingCount = new HashMap<Direction, Integer>();
        for (Direction facing : Direction.values()) {
            balancingCount.put(facing, 0);
        }
        while (!queue.isEmpty()) {
            Pair pair = (Pair)queue.poll();
            if (pair.getLeft() == null || pair.getRight() == null) continue;
            BlockPos pos = (BlockPos)pair.getLeft();
            int branchLength = (Integer)pair.getRight();
            choosenFacings.clear();
            for (Direction facing : Direction.values()) {
                BlockPos nextPos;
                BlockState prev;
                BlockState curr;
                if (choosenFacings.contains(facing.func_176734_d()) || (curr = world.func_180495_p(pos)).func_177230_c() == BRANCH.func_177230_c() && curr.func_177229_b(DeadwoodBranchBlock.FACING) == facing.func_176734_d() && (prev = world.func_180495_p(pos.func_177971_a(facing.func_176734_d().func_176730_m()))).func_177230_c() == BRANCH.func_177230_c() && prev.func_177229_b(DeadwoodBranchBlock.FACING) == facing.func_176734_d()) continue;
                double dist = baseLog.func_177951_i(new Vector3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                float probability = 0.8f;
                if (facing == Direction.UP) {
                    probability = (float)((double)probability * 1.5);
                    if (world.func_180495_p(pos).func_177230_c() == LOG.func_177230_c()) {
                        probability = 0.0f;
                    }
                } else if (facing == Direction.DOWN) {
                    probability = 0.0f;
                }
                probability = (float)((double)probability - 0.05 * dist);
                probability = (float)((double)probability - 0.002 * (double)count);
                probability = (float)((double)probability - 0.1 * (double)branchLength);
                probability = (float)((double)probability + 0.25 * (double)((Integer)balancingCount.get(facing)).intValue());
                if (!(random.nextFloat() < probability) || !world.func_175623_d(nextPos = pos.func_177971_a(facing.func_176730_m())) || !world.isAreaLoaded(nextPos, 8)) continue;
                DeadwoodBranchBlock branch = (DeadwoodBranchBlock)BRANCH.func_177230_c();
                this.func_230367_a_((IWorldWriter)genReader, nextPos, branch.makeConnections(world, nextPos, facing));
                placedBranches.add(nextPos);
                queue.add(new ImmutablePair((Object)nextPos, (Object)(branchLength + 1)));
                ++count;
                choosenFacings.add(facing);
                if (facing == Direction.UP || facing == Direction.DOWN) continue;
                if ((Integer)balancingCount.get(facing) > 0) {
                    balancingCount.put(facing, (Integer)balancingCount.get(facing) - 1);
                    continue;
                }
                balancingCount.put(facing.func_176734_d(), (Integer)balancingCount.get(facing.func_176734_d()) + 1);
            }
            for (BlockPos placedLocation : placedBranches) {
                if (genReader.func_217375_a(placedLocation, AbstractBlock.AbstractBlockState::func_196958_f)) continue;
                DeadwoodBranchBlock branch = (DeadwoodBranchBlock)BRANCH.func_177230_c();
                this.func_230367_a_((IWorldWriter)genReader, placedLocation, branch.makeConnections(world, placedLocation));
            }
            if (queue.size() <= 100) continue;
            break;
        }
    }
}

