/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.feature.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammetallurgy.atum.blocks.vegetation.DateBlock;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.world.gen.feature.tree.TreePlacerTypes;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;

public class PalmFoliagePlacer
extends FoliagePlacer {
    public static final Codec<PalmFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("date_chance").orElse((Object)Float.valueOf(0.0f)).forGetter(fp -> Float.valueOf(fp.dateChance))).apply((Applicative)instance, PalmFoliagePlacer::new));
    private final float dateChance;

    public PalmFoliagePlacer(float dateChance) {
        super(FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242252_a((int)0));
        this.dateChance = dateChance;
    }

    @Nonnull
    protected FoliagePlacerType<?> func_230371_a_() {
        return TreePlacerTypes.PALM_FOLIAGE;
    }

    protected void func_230372_a_(@Nonnull IWorldGenerationReader genReader, @Nonnull Random rand, @Nonnull BaseTreeFeatureConfig config, int i, @Nonnull FoliagePlacer.Foliage foliage, int i1, int i2, @Nonnull Set<BlockPos> positions, int i4, @Nonnull MutableBoundingBox box) {
        BlockPos leafPos = foliage.func_236763_a_();
        this.generateLeaf(genReader, leafPos.func_177984_a(), rand, config);
        for (BlockPos baseLeafPos : BlockPos.Mutable.func_218278_a((BlockPos)leafPos.func_177982_a(-1, 0, -1), (BlockPos)leafPos.func_177982_a(1, 0, 1))) {
            this.generateLeaf(genReader, baseLeafPos, rand, config);
        }
        this.generateLeaf(genReader, leafPos.func_177982_a(2, 0, 0), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(-2, 0, 0), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(0, 0, 2), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(0, 0, -2), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(0, -1, -2), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(0, -1, 2), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(2, -1, 0), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(-2, -1, 0), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(0, -1, -3), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(0, -1, 3), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(3, -1, 0), rand, config);
        this.generateLeaf(genReader, leafPos.func_177982_a(-3, -1, 0), rand, config);
        if (this.dateChance > 0.0f) {
            BlockPos datePos = leafPos.func_177977_b().func_177972_a(Direction.Plane.HORIZONTAL.func_179518_a(rand));
            if (rand.nextDouble() <= (double)this.dateChance) {
                genReader.func_180501_a(datePos, (BlockState)AtumBlocks.DATE_BLOCK.func_176223_P().func_206870_a((Property)DateBlock.AGE, (Comparable)Integer.valueOf(MathHelper.func_76136_a((Random)rand, (int)0, (int)7))), 2);
                if (rand.nextDouble() <= 0.25) {
                    datePos = leafPos.func_177977_b().func_177972_a(Direction.Plane.HORIZONTAL.func_179518_a(rand));
                    genReader.func_180501_a(datePos, (BlockState)AtumBlocks.DATE_BLOCK.func_176223_P().func_206870_a((Property)DateBlock.AGE, (Comparable)Integer.valueOf(MathHelper.func_76136_a((Random)rand, (int)0, (int)7))), 2);
                }
            }
        }
    }

    public int func_230374_a_(@Nonnull Random rand, int i, @Nonnull BaseTreeFeatureConfig config) {
        return 0;
    }

    protected boolean func_230373_a_(@Nonnull Random rand, int i1, int i2, int i3, int i4, boolean b) {
        return true;
    }

    private void generateLeaf(IWorldGenerationReader seedReader, BlockPos pos, Random rand, BaseTreeFeatureConfig config) {
        if (TreeFeature.func_236412_d_((IWorldGenerationBaseReader)seedReader, (BlockPos)pos)) {
            seedReader.func_180501_a(pos, config.field_227369_n_.func_225574_a_(rand, pos), 19);
        }
    }
}

