/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.structure.girafitomb;

import com.mojang.serialization.Codec;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.world.gen.structure.StructureHelper;
import com.teammetallurgy.atum.world.gen.structure.girafitomb.GirafiTombPieces;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class GirafiTombStructure
extends Structure<NoFeatureConfig> {
    public GirafiTombStructure(Codec<NoFeatureConfig> config) {
        super(config);
    }

    protected boolean func_230363_a_(@Nonnull ChunkGenerator generator, @Nonnull BiomeProvider provider, long seed, @Nonnull SharedSeedRandom seedRandom, int chunkX, int chunkZ, @Nonnull Biome biome, @Nonnull ChunkPos chunkPos, @Nonnull NoFeatureConfig config) {
        Iterator iterator = provider.func_225530_a_(chunkX * 16 + 9, 63, chunkZ * 16 + 9, 20).iterator();
        if (iterator.hasNext()) {
            Biome b = (Biome)iterator.next();
            if (!b.func_242440_e().func_242493_a((Structure)this)) {
                return false;
            }
            return StructureHelper.getYPosForStructure(chunkX, chunkZ, generator, null) >= 60;
        }
        return false;
    }

    @Nonnull
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structure, int chunkPosX, int chunkPosZ, MutableBoundingBox box, int references, long seed) {
            super(structure, chunkPosX, chunkPosZ, box, references, seed);
        }

        public void func_230364_a_(@Nonnull DynamicRegistries registries, @Nonnull ChunkGenerator generator, @Nonnull TemplateManager manager, int chunkX, int chunkZ, @Nonnull Biome biome, @Nonnull NoFeatureConfig config) {
            Rotation rotation = Rotation.func_222466_a((Random)this.field_214631_d);
            int y = StructureHelper.getYPosForStructure(chunkX, chunkZ, generator, rotation);
            if (y >= 60) {
                BlockPos pos = new BlockPos(chunkX * 16 + 8, y, chunkZ * 16 + 8);
                GirafiTombPieces.GirafiTombTemplate girafiTomb = new GirafiTombPieces.GirafiTombTemplate(manager, pos, rotation);
                this.field_75075_a.add(girafiTomb);
                this.func_202500_a();
            }
        }

        public void func_230366_a_(@Nonnull ISeedReader seedReader, @Nonnull StructureManager manager, @Nonnull ChunkGenerator generator, @Nonnull Random rand, @Nonnull MutableBoundingBox box, @Nonnull ChunkPos chunkPos) {
            super.func_230366_a_(seedReader, manager, generator, rand, box, chunkPos);
            int y = this.field_75074_b.field_78895_b;
            for (int x = box.field_78897_a; x <= box.field_78893_d; ++x) {
                for (int z = box.field_78896_c; z <= box.field_78892_f; ++z) {
                    BlockPos tombPos;
                    BlockPos pos = new BlockPos(x, y, z);
                    if (seedReader.func_175623_d(pos) || !this.field_75074_b.func_175898_b((Vector3i)pos)) continue;
                    boolean isVecInside = false;
                    for (StructurePiece piece : this.field_75075_a) {
                        if (!piece.func_74874_b().func_175898_b((Vector3i)pos)) continue;
                        isVecInside = true;
                        break;
                    }
                    if (!isVecInside) continue;
                    for (int pyramidY = y - 1; pyramidY > 1 && (seedReader.func_175623_d(tombPos = new BlockPos(x, pyramidY, z)) || seedReader.func_180495_p(tombPos).func_185904_a().func_76224_d()); --pyramidY) {
                        seedReader.func_180501_a(tombPos, AtumBlocks.LIMESTONE_BRICK_LARGE.func_176223_P(), 2);
                    }
                }
            }
        }
    }
}

