/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.structure.mineshaft;

import com.google.common.collect.Lists;
import com.teammetallurgy.atum.blocks.lighting.AtumWallTorchUnlitBlock;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumLootTables;
import com.teammetallurgy.atum.init.AtumStructurePieces;
import com.teammetallurgy.atum.world.gen.structure.mineshaft.AtumMineshaftStructure;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RailBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class AtumMineshaftPieces {
    private static Piece createRandomShaftPiece(List<StructurePiece> list, Random rand, int x, int y, int z, @Nullable Direction direction, int componentType, AtumMineshaftStructure.Type type) {
        int i = rand.nextInt(100);
        if (i >= 80) {
            MutableBoundingBox box = Cross.findCrossing(list, rand, x, y, z, direction);
            if (box != null) {
                return new Cross(componentType, box, direction, type);
            }
        } else if (i >= 70) {
            MutableBoundingBox box = Stairs.findStairs(list, rand, x, y, z, direction);
            if (box != null) {
                return new Stairs(componentType, box, direction, type);
            }
        } else {
            MutableBoundingBox box = Corridor.findCorridorSize(list, rand, x, y, z, direction);
            if (box != null) {
                return new Corridor(componentType, rand, box, direction, type);
            }
        }
        return null;
    }

    private static Piece generateAndAddPiece(StructurePiece structurePiece, List<StructurePiece> list, Random p_189938_2_, int x, int y, int z, Direction direction, int componentType) {
        if (componentType > 8) {
            return null;
        }
        if (Math.abs(x - structurePiece.func_74874_b().field_78897_a) <= 80 && Math.abs(z - structurePiece.func_74874_b().field_78896_c) <= 80) {
            AtumMineshaftStructure.Type type = ((Piece)structurePiece).mineShaftType;
            Piece piece = AtumMineshaftPieces.createRandomShaftPiece(list, p_189938_2_, x, y, z, direction, componentType + 1, type);
            if (piece != null) {
                list.add(piece);
                piece.func_74861_a(structurePiece, list, p_189938_2_);
            }
            return piece;
        }
        return null;
    }

    public static class Stairs
    extends Piece {
        public Stairs(int componentType, MutableBoundingBox box, Direction direction, AtumMineshaftStructure.Type type) {
            super(AtumStructurePieces.MINESHAFT_STAIRS, componentType, type);
            this.func_186164_a(direction);
            this.field_74887_e = box;
        }

        public Stairs(TemplateManager manager, CompoundNBT nbt) {
            super(AtumStructurePieces.MINESHAFT_STAIRS, nbt);
        }

        public static MutableBoundingBox findStairs(List<StructurePiece> list, Random rand, int x, int y, int z, Direction facing) {
            MutableBoundingBox box = new MutableBoundingBox(x, y - 5, z, x, y + 3 - 1, z);
            switch (facing) {
                default: {
                    box.field_78893_d = x + 3 - 1;
                    box.field_78896_c = z - 8;
                    break;
                }
                case SOUTH: {
                    box.field_78893_d = x + 3 - 1;
                    box.field_78892_f = z + 8;
                    break;
                }
                case WEST: {
                    box.field_78897_a = x - 8;
                    box.field_78892_f = z + 3 - 1;
                    break;
                }
                case EAST: {
                    box.field_78893_d = x + 8;
                    box.field_78892_f = z + 3 - 1;
                }
            }
            return StructurePiece.func_74883_a(list, (MutableBoundingBox)box) != null ? null : box;
        }

        public void func_74861_a(@Nonnull StructurePiece component, @Nonnull List<StructurePiece> list, @Nonnull Random rand) {
            int i = this.func_74877_c();
            Direction direction = this.func_186165_e();
            if (direction != null) {
                switch (direction) {
                    default: {
                        AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                        break;
                    }
                    case SOUTH: {
                        AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                        break;
                    }
                    case WEST: {
                        AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, Direction.WEST, i);
                        break;
                    }
                    case EAST: {
                        AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, Direction.EAST, i);
                    }
                }
            }
        }

        public boolean func_230383_a_(@Nonnull ISeedReader world, @Nonnull StructureManager manager, @Nonnull ChunkGenerator generator, @Nonnull Random rand, @Nonnull MutableBoundingBox box, @Nonnull ChunkPos chunkPos, BlockPos pos) {
            if (this.func_74860_a((IBlockReader)world, box)) {
                return false;
            }
            this.func_175804_a(world, box, 0, 5, 0, 2, 7, 1, field_202556_l, field_202556_l, false);
            this.func_175804_a(world, box, 0, 0, 7, 2, 2, 8, field_202556_l, field_202556_l, false);
            for (int i = 0; i < 5; ++i) {
                this.func_175804_a(world, box, 0, 5 - i - (i < 4 ? 1 : 0), 2 + i, 2, 7 - i, 2 + i, field_202556_l, field_202556_l, false);
            }
            return true;
        }
    }

    public static class Room
    extends Piece {
        private final List<MutableBoundingBox> connectedRooms = Lists.newLinkedList();

        public Room(int componentType, Random rand, int x, int z, AtumMineshaftStructure.Type type) {
            super(AtumStructurePieces.MINESHAFT_ROOM, componentType, type);
            this.mineShaftType = type;
            this.field_74887_e = new MutableBoundingBox(x, 50, z, x + 7 + rand.nextInt(6), 54 + rand.nextInt(6), z + 7 + rand.nextInt(6));
        }

        public Room(TemplateManager manager, CompoundNBT nbt) {
            super(AtumStructurePieces.MINESHAFT_ROOM, nbt);
            ListNBT listnbt = nbt.func_150295_c("Entrances", 11);
            for (int i = 0; i < listnbt.size(); ++i) {
                this.connectedRooms.add(new MutableBoundingBox(listnbt.func_150306_c(i)));
            }
        }

        public void func_74861_a(@Nonnull StructurePiece component, @Nonnull List<StructurePiece> list, @Nonnull Random rand) {
            MutableBoundingBox box;
            Piece piece;
            int k;
            int i = this.func_74877_c();
            int j = this.field_74887_e.func_78882_c() - 3 - 1;
            if (j <= 0) {
                j = 1;
            }
            for (k = 0; k < this.field_74887_e.func_78883_b() && (k += rand.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b(); k += 4) {
                piece = AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a + k, this.field_74887_e.field_78895_b + rand.nextInt(j) + 1, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                if (piece == null) continue;
                box = piece.func_74874_b();
                this.connectedRooms.add(new MutableBoundingBox(box.field_78897_a, box.field_78895_b, this.field_74887_e.field_78896_c, box.field_78893_d, box.field_78894_e, this.field_74887_e.field_78896_c + 1));
            }
            for (k = 0; k < this.field_74887_e.func_78883_b() && (k += rand.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b(); k += 4) {
                piece = AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a + k, this.field_74887_e.field_78895_b + rand.nextInt(j) + 1, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                if (piece == null) continue;
                box = piece.func_74874_b();
                this.connectedRooms.add(new MutableBoundingBox(box.field_78897_a, box.field_78895_b, this.field_74887_e.field_78892_f - 1, box.field_78893_d, box.field_78894_e, this.field_74887_e.field_78892_f));
            }
            for (k = 0; k < this.field_74887_e.func_78880_d() && (k += rand.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d(); k += 4) {
                piece = AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + rand.nextInt(j) + 1, this.field_74887_e.field_78896_c + k, Direction.WEST, i);
                if (piece == null) continue;
                box = piece.func_74874_b();
                this.connectedRooms.add(new MutableBoundingBox(this.field_74887_e.field_78897_a, box.field_78895_b, box.field_78896_c, this.field_74887_e.field_78897_a + 1, box.field_78894_e, box.field_78892_f));
            }
            for (k = 0; k < this.field_74887_e.func_78880_d() && (k += rand.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d(); k += 4) {
                piece = AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + rand.nextInt(j) + 1, this.field_74887_e.field_78896_c + k, Direction.EAST, i);
                if (piece == null) continue;
                box = piece.func_74874_b();
                this.connectedRooms.add(new MutableBoundingBox(this.field_74887_e.field_78893_d - 1, box.field_78895_b, box.field_78896_c, this.field_74887_e.field_78893_d, box.field_78894_e, box.field_78892_f));
            }
        }

        public boolean func_230383_a_(@Nonnull ISeedReader world, @Nonnull StructureManager manager, @Nonnull ChunkGenerator generator, @Nonnull Random rand, @Nonnull MutableBoundingBox box, @Nonnull ChunkPos chunkPos, BlockPos pos) {
            if (this.func_74860_a((IBlockReader)world, box)) {
                return false;
            }
            this.func_175804_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, AtumBlocks.SAND.func_176223_P(), field_202556_l, true);
            this.func_175804_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, Math.min(this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78894_e), this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
            for (MutableBoundingBox connectedRooms : this.connectedRooms) {
                this.func_175804_a(world, box, connectedRooms.field_78897_a, connectedRooms.field_78894_e - 2, connectedRooms.field_78896_c, connectedRooms.field_78893_d, connectedRooms.field_78894_e, connectedRooms.field_78892_f, field_202556_l, field_202556_l, false);
            }
            this.func_180777_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, field_202556_l, false);
            return true;
        }

        public void func_181138_a(int x, int y, int z) {
            super.func_181138_a(x, y, z);
            for (MutableBoundingBox connectedRooms : this.connectedRooms) {
                connectedRooms.func_78886_a(x, y, z);
            }
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            ListNBT listnbt = new ListNBT();
            for (MutableBoundingBox connectedRooms : this.connectedRooms) {
                listnbt.add((Object)connectedRooms.func_151535_h());
            }
            tagCompound.func_218657_a("Entrances", (INBT)listnbt);
        }
    }

    static abstract class Piece
    extends StructurePiece {
        protected AtumMineshaftStructure.Type mineShaftType;

        public Piece(IStructurePieceType structurePieceType, int componentType, AtumMineshaftStructure.Type type) {
            super(structurePieceType, componentType);
            this.mineShaftType = type;
        }

        public Piece(IStructurePieceType type, CompoundNBT nbt) {
            super(type, nbt);
            this.mineShaftType = AtumMineshaftStructure.Type.byId(nbt.func_74762_e("MST"));
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            tagCompound.func_74768_a("MST", this.mineShaftType.ordinal());
        }

        protected BlockState getPlanksBlock() {
            switch (this.mineShaftType) {
                default: {
                    return AtumBlocks.DEADWOOD_PLANKS.func_176223_P();
                }
                case LIMESTONE: 
                case LIMESTONE_SURFACE: 
            }
            return AtumBlocks.LIMESTONE_BRICK_LARGE.func_176223_P();
        }

        protected BlockState getFenceBlock() {
            switch (this.mineShaftType) {
                default: {
                    return AtumBlocks.DEADWOOD_FENCE.func_176223_P();
                }
                case LIMESTONE: 
                case LIMESTONE_SURFACE: 
            }
            return AtumBlocks.LARGE_WALL.func_176223_P();
        }

        protected BlockState getTorchBlock() {
            switch (this.mineShaftType) {
                default: {
                    return AtumWallTorchUnlitBlock.UNLIT.get(AtumBlocks.DEADWOOD_TORCH).func_176223_P();
                }
                case LIMESTONE: 
                case LIMESTONE_SURFACE: 
            }
            return AtumWallTorchUnlitBlock.UNLIT.get(AtumBlocks.LIMESTONE_TORCH).func_176223_P();
        }

        protected boolean isSupportingBox(IBlockReader blockReader, MutableBoundingBox box, int xStart, int xEnd, int x, int z) {
            for (int i = xStart; i <= xEnd; ++i) {
                if (!this.func_175807_a(blockReader, i, x + 1, z, box).func_196958_f()) continue;
                return false;
            }
            return true;
        }
    }

    public static class Cross
    extends Piece {
        private final Direction corridorDirection;
        private final boolean isMultipleFloors;

        public Cross(TemplateManager manager, CompoundNBT nbt) {
            super(AtumStructurePieces.MINESHAFT_CROSSING, nbt);
            this.isMultipleFloors = nbt.func_74767_n("tf");
            this.corridorDirection = Direction.func_176731_b((int)nbt.func_74762_e("D"));
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("tf", this.isMultipleFloors);
            tagCompound.func_74768_a("D", this.corridorDirection.func_176736_b());
        }

        public Cross(int componentType, MutableBoundingBox box, @Nullable Direction direction, AtumMineshaftStructure.Type type) {
            super(AtumStructurePieces.MINESHAFT_CROSSING, componentType, type);
            this.corridorDirection = direction;
            this.field_74887_e = box;
            this.isMultipleFloors = box.func_78882_c() > 3;
        }

        public static MutableBoundingBox findCrossing(List<StructurePiece> list, Random rand, int x, int y, int z, Direction facing) {
            MutableBoundingBox box = new MutableBoundingBox(x, y, z, x, y + 3 - 1, z);
            if (rand.nextInt(4) == 0) {
                box.field_78894_e += 4;
            }
            switch (facing) {
                default: {
                    box.field_78897_a = x - 1;
                    box.field_78893_d = x + 3;
                    box.field_78896_c = z - 4;
                    break;
                }
                case SOUTH: {
                    box.field_78897_a = x - 1;
                    box.field_78893_d = x + 3;
                    box.field_78892_f = z + 3 + 1;
                    break;
                }
                case WEST: {
                    box.field_78897_a = x - 4;
                    box.field_78896_c = z - 1;
                    box.field_78892_f = z + 3;
                    break;
                }
                case EAST: {
                    box.field_78893_d = x + 3 + 1;
                    box.field_78896_c = z - 1;
                    box.field_78892_f = z + 3;
                }
            }
            return StructurePiece.func_74883_a(list, (MutableBoundingBox)box) != null ? null : box;
        }

        public void func_74861_a(@Nonnull StructurePiece component, @Nonnull List<StructurePiece> list, @Nonnull Random rand) {
            int i = this.func_74877_c();
            switch (this.corridorDirection) {
                default: {
                    AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                    AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.WEST, i);
                    AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.EAST, i);
                    break;
                }
                case SOUTH: {
                    AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                    AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.WEST, i);
                    AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.EAST, i);
                    break;
                }
                case WEST: {
                    AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                    AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                    AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.WEST, i);
                    break;
                }
                case EAST: {
                    AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                    AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                    AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.EAST, i);
                }
            }
            if (this.isMultipleFloors) {
                if (rand.nextBoolean()) {
                    AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                }
                if (rand.nextBoolean()) {
                    AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, Direction.WEST, i);
                }
                if (rand.nextBoolean()) {
                    AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, Direction.EAST, i);
                }
                if (rand.nextBoolean()) {
                    AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                }
            }
        }

        public boolean func_230383_a_(@Nonnull ISeedReader world, StructureManager manager, @Nonnull ChunkGenerator generator, @Nonnull Random rand, @Nonnull MutableBoundingBox box, @Nonnull ChunkPos chunkPos, BlockPos pos) {
            if (this.func_74860_a((IBlockReader)world, box)) {
                return false;
            }
            BlockState plankState = this.getPlanksBlock();
            if (this.isMultipleFloors) {
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
            } else {
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
            }
            this.placeSupportPillar(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78894_e);
            this.placeSupportPillar(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78894_e);
            this.placeSupportPillar(world, box, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78894_e);
            this.placeSupportPillar(world, box, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78894_e);
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                for (int j = this.field_74887_e.field_78896_c; j <= this.field_74887_e.field_78892_f; ++j) {
                    if (!this.func_175807_a((IBlockReader)world, i, this.field_74887_e.field_78895_b - 1, j, box).func_196958_f() || !this.func_189916_b((IWorldReader)world, i, this.field_74887_e.field_78895_b - 1, j, box)) continue;
                    this.func_175811_a(world, plankState, i, this.field_74887_e.field_78895_b - 1, j, box);
                }
            }
            return true;
        }

        private void placeSupportPillar(ISeedReader world, MutableBoundingBox box, int x, int y, int z, int yMax) {
            if (!this.func_175807_a((IBlockReader)world, x, yMax + 1, z, box).func_196958_f()) {
                this.func_175804_a(world, box, x, y, z, x, yMax, z, this.getPlanksBlock(), field_202556_l, false);
            }
        }
    }

    public static class Corridor
    extends Piece {
        private final boolean hasRails;
        private final boolean hasTarantula;
        private boolean spawnerPlaced;
        private final int sectionCount;

        public Corridor(TemplateManager manager, CompoundNBT nbt) {
            super(AtumStructurePieces.MINESHAFT_CORRIDOR, nbt);
            this.hasRails = nbt.func_74767_n("hr");
            this.hasTarantula = nbt.func_74767_n("sc");
            this.spawnerPlaced = nbt.func_74767_n("hps");
            this.sectionCount = nbt.func_74762_e("Num");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("hr", this.hasRails);
            tagCompound.func_74757_a("sc", this.hasTarantula);
            tagCompound.func_74757_a("hps", this.spawnerPlaced);
            tagCompound.func_74768_a("Num", this.sectionCount);
        }

        public Corridor(int componentType, Random rand, MutableBoundingBox box, Direction direction, AtumMineshaftStructure.Type type) {
            super(AtumStructurePieces.MINESHAFT_CORRIDOR, componentType, type);
            this.func_186164_a(direction);
            this.field_74887_e = box;
            this.hasRails = rand.nextInt(3) == 0;
            this.hasTarantula = !this.hasRails && rand.nextInt(23) == 0;
            this.sectionCount = this.func_186165_e().func_176740_k() == Direction.Axis.Z ? box.func_78880_d() / 5 : box.func_78883_b() / 5;
        }

        public static MutableBoundingBox findCorridorSize(List<StructurePiece> list, Random rand, int x, int y, int z, Direction facing) {
            int i;
            MutableBoundingBox box = new MutableBoundingBox(x, y, z, x, y + 3 - 1, z);
            for (i = rand.nextInt(3) + 2; i > 0; --i) {
                int j = i * 5;
                switch (facing) {
                    default: {
                        box.field_78893_d = x + 3 - 1;
                        box.field_78896_c = z - (j - 1);
                        break;
                    }
                    case SOUTH: {
                        box.field_78893_d = x + 3 - 1;
                        box.field_78892_f = z + j - 1;
                        break;
                    }
                    case WEST: {
                        box.field_78897_a = x - (j - 1);
                        box.field_78892_f = z + 3 - 1;
                        break;
                    }
                    case EAST: {
                        box.field_78893_d = x + j - 1;
                        box.field_78892_f = z + 3 - 1;
                    }
                }
                if (StructurePiece.func_74883_a(list, (MutableBoundingBox)box) == null) break;
            }
            return i > 0 ? box : null;
        }

        public void func_74861_a(@Nonnull StructurePiece component, @Nonnull List<StructurePiece> list, Random rand) {
            block24: {
                int i = this.func_74877_c();
                int j = rand.nextInt(4);
                Direction direction = this.func_186165_e();
                if (direction != null) {
                    switch (direction) {
                        default: {
                            if (j <= 1) {
                                AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, direction, i);
                                break;
                            }
                            if (j == 2) {
                                AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, Direction.WEST, i);
                                break;
                            }
                            AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, Direction.EAST, i);
                            break;
                        }
                        case SOUTH: {
                            if (j <= 1) {
                                AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, direction, i);
                                break;
                            }
                            if (j == 2) {
                                AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f - 3, Direction.WEST, i);
                                break;
                            }
                            AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f - 3, Direction.EAST, i);
                            break;
                        }
                        case WEST: {
                            if (j <= 1) {
                                AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, direction, i);
                                break;
                            }
                            if (j == 2) {
                                AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                                break;
                            }
                            AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                            break;
                        }
                        case EAST: {
                            if (j <= 1) {
                                AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, direction, i);
                                break;
                            }
                            if (j == 2) {
                                AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                                break;
                            }
                            AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                        }
                    }
                }
                if (i >= 8) break block24;
                if (direction != Direction.NORTH && direction != Direction.SOUTH) {
                    int i1 = this.field_74887_e.field_78897_a + 3;
                    while (i1 + 3 <= this.field_74887_e.field_78893_d) {
                        int j1 = rand.nextInt(5);
                        if (j1 == 0) {
                            AtumMineshaftPieces.generateAndAddPiece(component, list, rand, i1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i + 1);
                        } else if (j1 == 1) {
                            AtumMineshaftPieces.generateAndAddPiece(component, list, rand, i1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i + 1);
                        }
                        i1 += 5;
                    }
                } else {
                    int k = this.field_74887_e.field_78896_c + 3;
                    while (k + 3 <= this.field_74887_e.field_78892_f) {
                        int l = rand.nextInt(5);
                        if (l == 0) {
                            AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, k, Direction.WEST, i + 1);
                        } else if (l == 1) {
                            AtumMineshaftPieces.generateAndAddPiece(component, list, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, k, Direction.EAST, i + 1);
                        }
                        k += 5;
                    }
                }
            }
        }

        protected boolean func_186167_a(@Nonnull ISeedReader world, MutableBoundingBox box, @Nonnull Random rand, int x, int y, int z, @Nonnull ResourceLocation loot) {
            BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            if (box.func_175898_b((Vector3i)blockpos) && world.func_180495_p(blockpos).isAir((IBlockReader)world, blockpos) && !world.func_180495_p(blockpos.func_177977_b()).isAir((IBlockReader)world, blockpos.func_177977_b())) {
                BlockState plankState = (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)(rand.nextBoolean() ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST));
                this.func_175811_a(world, plankState, x, y, z, box);
                ChestMinecartEntity chestMinecraftEntity = new ChestMinecartEntity((World)world.func_201672_e(), (double)((float)blockpos.func_177958_n() + 0.5f), (double)((float)blockpos.func_177956_o() + 0.5f), (double)((float)blockpos.func_177952_p() + 0.5f));
                chestMinecraftEntity.func_184289_a(loot, rand.nextLong());
                world.func_217376_c((Entity)chestMinecraftEntity);
                return true;
            }
            return false;
        }

        public boolean func_230383_a_(@Nonnull ISeedReader world, @Nonnull StructureManager manager, @Nonnull ChunkGenerator generator, @Nonnull Random rand, @Nonnull MutableBoundingBox box, @Nonnull ChunkPos chunkPos, BlockPos pos) {
            if (this.func_74860_a((IBlockReader)world, box)) {
                return false;
            }
            int i1 = this.sectionCount * 5 - 1;
            BlockState plankState = this.getPlanksBlock();
            this.func_175804_a(world, box, 0, 0, 0, 2, 1, i1, field_202556_l, field_202556_l, false);
            this.func_189914_a(world, box, rand, 0.8f, 0, 2, 0, 2, 2, i1, field_202556_l, field_202556_l, false, false);
            if (this.hasTarantula) {
                this.func_189914_a(world, box, rand, 0.6f, 0, 0, 0, 2, 1, i1, Blocks.field_196553_aF.func_176223_P(), field_202556_l, false, true);
            }
            for (int j1 = 0; j1 < this.sectionCount; ++j1) {
                int k2;
                int k1 = 2 + j1 * 5;
                this.placeSupport(world, box, 0, 0, k1, 2, 2, rand);
                this.placeCobWeb(world, box, rand, 0.1f, 0, 2, k1 - 1);
                this.placeCobWeb(world, box, rand, 0.1f, 2, 2, k1 - 1);
                this.placeCobWeb(world, box, rand, 0.1f, 0, 2, k1 + 1);
                this.placeCobWeb(world, box, rand, 0.1f, 2, 2, k1 + 1);
                this.placeCobWeb(world, box, rand, 0.05f, 0, 2, k1 - 2);
                this.placeCobWeb(world, box, rand, 0.05f, 2, 2, k1 - 2);
                this.placeCobWeb(world, box, rand, 0.05f, 0, 2, k1 + 2);
                this.placeCobWeb(world, box, rand, 0.05f, 2, 2, k1 + 2);
                if (rand.nextInt(100) == 0) {
                    this.func_186167_a(world, box, rand, 2, 0, k1 - 1, AtumLootTables.CRATE);
                }
                if (rand.nextInt(100) == 0) {
                    this.func_186167_a(world, box, rand, 0, 0, k1 + 1, AtumLootTables.CRATE);
                }
                if (!this.hasTarantula || this.spawnerPlaced) continue;
                int l1 = this.func_74862_a(0);
                int i2 = k1 - 1 + rand.nextInt(3);
                int j2 = this.func_74865_a(1, i2);
                BlockPos blockpos = new BlockPos(j2, l1, k2 = this.func_74873_b(1, i2));
                if (!box.func_175898_b((Vector3i)blockpos) || !this.func_189916_b((IWorldReader)world, 1, 0, i2, box)) continue;
                this.spawnerPlaced = true;
                world.func_180501_a(blockpos, Blocks.field_150474_ac.func_176223_P(), 2);
                TileEntity tileEntity = world.func_175625_s(blockpos);
                if (!(tileEntity instanceof MobSpawnerTileEntity)) continue;
                AtumMineshaftStructure.Type type = this.mineShaftType;
                int chance = rand.nextInt(100);
                if (chance < 40) {
                    if (type == AtumMineshaftStructure.Type.DEADWOOD || type == AtumMineshaftStructure.Type.DEADWOOD_SURFACE) {
                        ((MobSpawnerTileEntity)tileEntity).func_145881_a().func_200876_a(AtumEntities.FORSAKEN);
                        continue;
                    }
                    if (type != AtumMineshaftStructure.Type.LIMESTONE && type != AtumMineshaftStructure.Type.LIMESTONE_SURFACE) continue;
                    ((MobSpawnerTileEntity)tileEntity).func_145881_a().func_200876_a(AtumEntities.STONEGUARD);
                    continue;
                }
                ((MobSpawnerTileEntity)tileEntity).func_145881_a().func_200876_a(AtumEntities.TARANTULA);
            }
            for (int l2 = 0; l2 <= 2; ++l2) {
                for (int i3 = 0; i3 <= i1; ++i3) {
                    BlockState blockstate3 = this.func_175807_a((IBlockReader)world, l2, -1, i3, box);
                    if (!blockstate3.func_196958_f() || !this.func_189916_b((IWorldReader)world, l2, -1, i3, box)) continue;
                    this.func_175811_a(world, plankState, l2, -1, i3, box);
                }
            }
            if (this.hasRails) {
                BlockState railState = (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)RailShape.NORTH_SOUTH);
                for (int j3 = 0; j3 <= i1; ++j3) {
                    BlockState blockstate2 = this.func_175807_a((IBlockReader)world, 1, -1, j3, box);
                    if (blockstate2.func_196958_f() || !blockstate2.func_200015_d((IBlockReader)world, new BlockPos(this.func_74865_a(1, j3), this.func_74862_a(-1), this.func_74873_b(1, j3)))) continue;
                    float f = this.func_189916_b((IWorldReader)world, 1, 0, j3, box) ? 0.7f : 0.9f;
                    this.func_175809_a(world, box, rand, f, 1, 0, j3, railState);
                }
            }
            return true;
        }

        private void placeSupport(ISeedReader world, MutableBoundingBox box, int x, int yMin, int zMin, int yMax, int zMax, Random rand) {
            if (this.isSupportingBox((IBlockReader)world, box, x, zMax, yMax, zMin)) {
                BlockState plankState = this.getPlanksBlock();
                BlockState fenceState = this.getFenceBlock();
                BlockState torchState = this.getTorchBlock();
                this.func_175804_a(world, box, x, yMin, zMin, x, yMax - 1, zMin, fenceState, field_202556_l, false);
                this.func_175804_a(world, box, zMax, yMin, zMin, zMax, yMax - 1, zMin, fenceState, field_202556_l, false);
                if (rand.nextInt(4) == 0) {
                    this.func_175804_a(world, box, x, yMax, zMin, x, yMax, zMin, plankState, field_202556_l, false);
                    this.func_175804_a(world, box, zMax, yMax, zMin, zMax, yMax, zMin, plankState, field_202556_l, false);
                } else {
                    this.func_175804_a(world, box, x, yMax, zMin, zMax, yMax, zMin, plankState, field_202556_l, false);
                    this.func_175809_a(world, box, rand, 0.05f, x + 1, yMax, zMin - 1, (BlockState)torchState.func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.NORTH));
                    this.func_175809_a(world, box, rand, 0.05f, x + 1, yMax, zMin + 1, (BlockState)torchState.func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.SOUTH));
                }
            }
        }

        private void placeCobWeb(ISeedReader world, MutableBoundingBox box, Random rand, float chance, int x, int y, int z) {
            if (this.func_189916_b((IWorldReader)world, x, y, z, box)) {
                this.func_175809_a(world, box, rand, chance, x, y, z, Blocks.field_196553_aF.func_176223_P());
            }
        }
    }
}

