/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.structure.mineshaft;

import com.mojang.serialization.Codec;
import com.teammetallurgy.atum.world.gen.structure.mineshaft.AtumMineshaftConfig;
import com.teammetallurgy.atum.world.gen.structure.mineshaft.AtumMineshaftPieces;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class AtumMineshaftStructure
extends Structure<AtumMineshaftConfig> {
    public AtumMineshaftStructure(Codec<AtumMineshaftConfig> config) {
        super(config);
    }

    protected boolean func_230363_a_(@Nonnull ChunkGenerator generator, @Nonnull BiomeProvider provider, long seed, SharedSeedRandom seedRandom, int chunkX, int chunkZ, @Nonnull Biome biome, @Nonnull ChunkPos chunkPos, AtumMineshaftConfig config) {
        seedRandom.func_202425_c(seed, chunkX, chunkZ);
        double probability = config.probability;
        return seedRandom.nextDouble() < probability;
    }

    @Nonnull
    public Structure.IStartFactory<AtumMineshaftConfig> func_214557_a() {
        return Start::new;
    }

    public static enum Type implements IStringSerializable
    {
        DEADWOOD("deadwood", false),
        LIMESTONE("limestone", false),
        DEADWOOD_SURFACE("deadwood_surface", true),
        LIMESTONE_SURFACE("limestone_surface", true);

        public static final Codec<Type> CODEC;
        private static final Map<String, Type> BY_NAME;
        private final String name;
        private final boolean isSurface;

        private Type(String name, boolean isSurface) {
            this.name = name;
            this.isSurface = isSurface;
        }

        public String getName() {
            return this.name;
        }

        public boolean isSurface() {
            return this.isSurface;
        }

        public static Type byName(String name) {
            return BY_NAME.get(name);
        }

        public static Type byId(int id) {
            return id >= 0 && id < Type.values().length ? Type.values()[id] : DEADWOOD;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        static {
            CODEC = IStringSerializable.func_233023_a_(Type::values, Type::byName);
            BY_NAME = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getName, p_214716_0_ -> p_214716_0_));
        }
    }

    public static class Start
    extends StructureStart<AtumMineshaftConfig> {
        public Start(Structure<AtumMineshaftConfig> structure, int chunkPosX, int chunkPosZ, MutableBoundingBox box, int references, long seed) {
            super(structure, chunkPosX, chunkPosZ, box, references, seed);
        }

        public void func_230364_a_(@Nonnull DynamicRegistries registries, @Nonnull ChunkGenerator generator, @Nonnull TemplateManager manager, int chunkX, int chunkZ, @Nonnull Biome biome, @Nonnull AtumMineshaftConfig config) {
            AtumMineshaftPieces.Room room = new AtumMineshaftPieces.Room(0, (Random)this.field_214631_d, (chunkX << 4) + 2, (chunkZ << 4) + 2, config.type);
            this.field_75075_a.add(room);
            room.func_74861_a(room, this.field_75075_a, (Random)this.field_214631_d);
            this.func_202500_a();
            if (config.type.isSurface()) {
                int y = generator.func_205470_d() - this.field_75074_b.field_78894_e + this.field_75074_b.func_78882_c() / 2 - -5;
                this.field_75074_b.func_78886_a(0, y, 0);
                for (StructurePiece structurepiece : this.field_75075_a) {
                    structurepiece.func_181138_a(0, y, 0);
                }
            } else {
                this.func_214628_a(generator.func_205470_d(), (Random)this.field_214631_d, 10);
            }
        }
    }
}

