/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.structure.pyramid;

import com.mojang.serialization.Codec;
import com.teammetallurgy.atum.api.event.PharaohBeatenEvent;
import com.teammetallurgy.atum.blocks.base.IUnbreakable;
import com.teammetallurgy.atum.blocks.stone.limestone.LimestoneBrickBlock;
import com.teammetallurgy.atum.blocks.trap.TrapBlock;
import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumStructures;
import com.teammetallurgy.atum.network.NetworkHandler;
import com.teammetallurgy.atum.network.packet.SyncHandStackSizePacket;
import com.teammetallurgy.atum.world.DimensionHelper;
import com.teammetallurgy.atum.world.gen.structure.StructureHelper;
import com.teammetallurgy.atum.world.gen.structure.pyramid.PyramidPieces;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SpawnerBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PyramidStructure
extends Structure<NoFeatureConfig> {
    public PyramidStructure(Codec<NoFeatureConfig> config) {
        super(config);
    }

    protected boolean func_230365_b_() {
        return false;
    }

    protected boolean func_230363_a_(@Nonnull ChunkGenerator generator, @Nonnull BiomeProvider provider, long seed, @Nonnull SharedSeedRandom seedRandom, int chunkX, int chunkZ, @Nonnull Biome biome, @Nonnull ChunkPos chunkPos, @Nonnull NoFeatureConfig config) {
        Iterator iterator = provider.func_225530_a_(chunkX * 16 + 9, 63, chunkZ * 16 + 9, 32).iterator();
        if (iterator.hasNext()) {
            Biome b = (Biome)iterator.next();
            if (!b.func_242440_e().func_242493_a((Structure)this)) {
                return false;
            }
            return StructureHelper.getYPosForStructure(chunkX, chunkZ, generator, null) > 55;
        }
        return false;
    }

    @Nonnull
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        Start start;
        ServerWorld serverWorld;
        StructureStart structureStart;
        World world;
        if (event.getEntity() instanceof ServerPlayerEntity && (world = event.getEntity().field_70170_p) instanceof ServerWorld && (structureStart = (serverWorld = (ServerWorld)world).func_241112_a_().func_235010_a_(event.getPos(), true, AtumStructures.PYRAMID_STRUCTURE)) instanceof Start && structureStart.func_75069_d() && !DimensionHelper.isBeatenPyramid(serverWorld, (start = (Start)structureStart).func_75071_a())) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            Block placedBlock = event.getPlacedBlock().func_177230_c();
            if (!player.func_184812_l_() && !(placedBlock instanceof TorchBlock)) {
                event.setCanceled(true);
                ItemStack placedStack = new ItemStack((IItemProvider)placedBlock);
                Hand hand = player.func_184614_ca().func_77973_b() == placedStack.func_77973_b() ? Hand.MAIN_HAND : Hand.OFF_HAND;
                NetworkHandler.sendTo(player, new SyncHandStackSizePacket(placedStack, hand == Hand.MAIN_HAND ? 1 : 0));
            }
        }
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structure, int chunkPosX, int chunkPosZ, MutableBoundingBox box, int references, long seed) {
            super(structure, chunkPosX, chunkPosZ, box, references, seed);
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        public void func_230364_a_(@Nonnull DynamicRegistries registries, @Nonnull ChunkGenerator generator, @Nonnull TemplateManager manager, int chunkX, int chunkZ, @Nonnull Biome biome, @Nonnull NoFeatureConfig config) {
            Rotation rotation = Rotation.func_222466_a((Random)this.field_214631_d);
            int y = StructureHelper.getYPosForStructure(chunkX, chunkZ, generator, rotation);
            if (y > 55) {
                int yChance = MathHelper.func_76136_a((Random)this.field_214631_d, (int)7, (int)14);
                BlockPos pos = new BlockPos(chunkX * 16 + 8, y - yChance, chunkZ * 16 + 8);
                List<StructurePiece> components = PyramidPieces.getComponents(manager, pos, rotation);
                this.field_75075_a.addAll(components);
                this.func_202500_a();
            }
        }

        @SubscribeEvent
        public void onPharaohBeaten(PharaohBeatenEvent event) {
            World world = event.getPharaoh().field_70170_p;
            BlockPos sarcophagusPos = event.getPharaoh().getSarcophagusPos();
            if (sarcophagusPos != null && world instanceof ServerWorld && !world.field_72995_K && this.func_75071_a().func_175898_b((Vector3i)sarcophagusPos)) {
                ServerWorld serverWorld = (ServerWorld)world;
                DimensionHelper.getData(serverWorld).addBeatenPyramid(this.func_75071_a());
                this.changePyramidBlocks(serverWorld);
            }
        }

        public void changePyramidBlocks(ServerWorld world) {
            MutableBoundingBox box = this.func_75071_a();
            for (int z = box.field_78896_c; z <= box.field_78892_f; ++z) {
                for (int y = box.field_78895_b; y <= box.field_78894_e; ++y) {
                    for (int x = box.field_78897_a; x <= box.field_78893_d; ++x) {
                        BlockPos pos = new BlockPos(x, y, z);
                        if (world.func_175623_d(pos)) continue;
                        BlockState state = world.func_180495_p(pos);
                        if (state.func_177230_c() instanceof IUnbreakable && ((Boolean)state.func_177229_b((Property)IUnbreakable.UNBREAKABLE)).booleanValue()) {
                            if (state.func_177230_c() == AtumBlocks.LIMESTONE_BRICK_LARGE && world.field_73012_v.nextDouble() <= 0.08) {
                                if (world.func_175623_d(pos.func_177977_b())) {
                                    world.func_180501_a(pos, (BlockState)AtumBlocks.LIMESTONE_BRICK_CRACKED_BRICK.func_176223_P().func_206870_a((Property)LimestoneBrickBlock.CAN_FALL, (Comparable)Boolean.valueOf(true)), 2);
                                    continue;
                                }
                                world.func_180501_a(pos, AtumBlocks.LIMESTONE_BRICK_CRACKED_BRICK.func_176223_P(), 2);
                                continue;
                            }
                            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)IUnbreakable.UNBREAKABLE, (Comparable)Boolean.valueOf(false)), 2);
                            continue;
                        }
                        if (state.func_177230_c() instanceof TrapBlock) {
                            world.func_180501_a(pos, AtumBlocks.LIMESTONE_BRICK_CARVED.func_176223_P(), 2);
                            continue;
                        }
                        if (!(state.func_177230_c() instanceof SpawnerBlock)) continue;
                        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
            }
        }

        public void func_230366_a_(@Nonnull ISeedReader seedReader, @Nonnull StructureManager manager, @Nonnull ChunkGenerator generator, @Nonnull Random rand, @Nonnull MutableBoundingBox box, @Nonnull ChunkPos chunkPos) {
            Optional optional = seedReader.func_241828_r().func_243612_b(Registry.field_239720_u_).func_230519_c_((Object)seedReader.func_226691_t_(this.func_204294_a()));
            if (optional.isPresent() && optional.get() != AtumBiomes.DRIED_RIVER) {
                super.func_230366_a_(seedReader, manager, generator, rand, box, chunkPos);
                int y = this.field_75074_b.field_78895_b;
                for (int x = box.field_78897_a; x <= box.field_78893_d; ++x) {
                    for (int z = box.field_78896_c; z <= box.field_78892_f; ++z) {
                        BlockPos pyramidPos;
                        BlockPos pos = new BlockPos(x, y, z);
                        if (StructureHelper.doesChunkHaveStructure(seedReader, pos, Structure.field_236381_q_) || seedReader.func_175623_d(pos) || !this.field_75074_b.func_175898_b((Vector3i)pos)) continue;
                        boolean isVecInside = false;
                        for (StructurePiece piece : this.field_75075_a) {
                            if (!piece.func_74874_b().func_175898_b((Vector3i)pos)) continue;
                            isVecInside = true;
                            break;
                        }
                        if (!isVecInside) continue;
                        for (int pyramidY = y - 1; pyramidY > 1 && (seedReader.func_175623_d(pyramidPos = new BlockPos(x, pyramidY, z)) || seedReader.func_180495_p(pyramidPos).func_185904_a().func_76224_d()); --pyramidY) {
                            seedReader.func_180501_a(pyramidPos, AtumBlocks.LIMESTONE_BRICK_LARGE.func_176223_P(), 2);
                        }
                    }
                }
            }
        }
    }
}

