/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.structure.ruins;

import com.teammetallurgy.atum.blocks.base.ChestBaseBlock;
import com.teammetallurgy.atum.blocks.wood.tileentity.crate.CrateTileEntity;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumLootTables;
import com.teammetallurgy.atum.init.AtumStructurePieces;
import com.teammetallurgy.atum.misc.AtumConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class RuinPieces {

    public static class RuinTemplate
    extends TemplateStructurePiece {
        private static final List<EntityType<?>> BANDITS = Arrays.asList(AtumEntities.BARBARIAN, AtumEntities.BRIGAND, AtumEntities.NOMAD);
        public static final List<EntityType<?>> UNDEAD = Arrays.asList(AtumEntities.BONESTORM, AtumEntities.FORSAKEN, AtumEntities.MUMMY, AtumEntities.WRAITH);
        private final int ruinType;
        private final Rotation rotation;

        public RuinTemplate(TemplateManager manager, BlockPos pos, Random random, Rotation rotation) {
            super(AtumStructurePieces.RUIN, 0);
            this.field_186178_c = pos;
            this.rotation = rotation;
            this.ruinType = MathHelper.func_76136_a((Random)random, (int)1, (int)((Integer)AtumConfig.WORLD_GEN.ruinsAmount.get()));
            this.loadTemplate(manager);
        }

        public RuinTemplate(TemplateManager manager, CompoundNBT nbt) {
            super(AtumStructurePieces.RUIN, nbt);
            this.rotation = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
            this.ruinType = nbt.func_74762_e("Type");
            this.loadTemplate(manager);
        }

        private void loadTemplate(TemplateManager manager) {
            Template template = manager.func_200219_b(new ResourceLocation("atum", "ruins/ruin" + this.ruinType));
            PlacementSettings placementsettings = new PlacementSettings().func_186222_a(true).func_186220_a(this.rotation).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_186175_a(@Nonnull String function, @Nonnull BlockPos pos, @Nonnull IServerWorld world, @Nonnull Random rand, @Nonnull MutableBoundingBox box) {
            if (function.equals("Spawner")) {
                if (box.func_175898_b((Vector3i)pos)) {
                    world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
                    TileEntity tileEntity = world.func_175625_s(pos);
                    if (tileEntity instanceof MobSpawnerTileEntity) {
                        EntityType<?> type = rand.nextDouble() < 0.5 ? BANDITS.get(rand.nextInt(BANDITS.size())) : UNDEAD.get(rand.nextInt(UNDEAD.size()));
                        ((MobSpawnerTileEntity)tileEntity).func_145881_a().func_200876_a(type);
                    }
                }
            } else if (function.equals("Crate") && box.func_175898_b((Vector3i)pos)) {
                if (rand.nextDouble() <= 0.15) {
                    world.func_180501_a(pos, ChestBaseBlock.correctFacing((IBlockReader)world, pos, AtumBlocks.DEADWOOD_CRATE.func_176223_P(), AtumBlocks.DEADWOOD_CRATE), 2);
                    TileEntity tileEntity = world.func_175625_s(pos);
                    if (tileEntity instanceof CrateTileEntity) {
                        ((CrateTileEntity)tileEntity).func_189404_a(AtumLootTables.CRATE, rand.nextLong());
                    }
                } else {
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
        }

        protected void func_143011_b(@Nonnull CompoundNBT compound) {
            super.func_143011_b(compound);
            compound.func_74778_a("Rot", this.func_214809_Y_().name());
            compound.func_74768_a("Type", this.ruinType);
        }
    }
}

