/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.structure.ruins;

import com.mojang.serialization.Codec;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.world.gen.structure.StructureHelper;
import com.teammetallurgy.atum.world.gen.structure.ruins.RuinPieces;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class RuinStructure
extends Structure<NoFeatureConfig> {
    public RuinStructure(Codec<NoFeatureConfig> config) {
        super(config);
    }

    protected boolean func_230363_a_(@Nonnull ChunkGenerator generator, @Nonnull BiomeProvider provider, long seed, @Nonnull SharedSeedRandom seedRandom, int chunkX, int chunkZ, @Nonnull Biome biome, @Nonnull ChunkPos chunkPos, @Nonnull NoFeatureConfig config) {
        for (Biome b : provider.func_225530_a_(chunkX * 16 + 9, 63, chunkZ * 16 + 9, 17)) {
            if (b.func_242440_e().func_242493_a((Structure)this)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structure, int chunkPosX, int chunkPosZ, MutableBoundingBox box, int references, long seed) {
            super(structure, chunkPosX, chunkPosZ, box, references, seed);
        }

        public void func_230364_a_(@Nonnull DynamicRegistries registries, @Nonnull ChunkGenerator generator, @Nonnull TemplateManager manager, int chunkX, int chunkZ, @Nonnull Biome biome, @Nonnull NoFeatureConfig config) {
            Rotation rotation = Rotation.func_222466_a((Random)this.field_214631_d);
            int y = StructureHelper.getYPosForStructure(chunkX, chunkZ, generator, rotation);
            if (y > 60 && y < 85) {
                BlockPos pos = new BlockPos(chunkX * 16, y, chunkZ * 16);
                this.field_75075_a.add(new RuinPieces.RuinTemplate(manager, pos, (Random)this.field_214631_d, rotation));
                this.func_202500_a();
            }
        }

        public void func_230366_a_(@Nonnull ISeedReader seedReader, @Nonnull StructureManager manager, @Nonnull ChunkGenerator generator, @Nonnull Random rand, @Nonnull MutableBoundingBox box, @Nonnull ChunkPos chunkPos) {
            super.func_230366_a_(seedReader, manager, generator, rand, box, chunkPos);
            int y = this.field_75074_b.field_78895_b;
            for (int x = box.field_78897_a; x <= box.field_78893_d; ++x) {
                for (int z = box.field_78896_c; z <= box.field_78892_f; ++z) {
                    BlockPos ruinPos;
                    BlockPos pos = new BlockPos(x, y, z);
                    if (StructureHelper.doesChunkHaveStructure(seedReader, pos, Structure.field_236381_q_) || seedReader.func_175623_d(pos) || !this.field_75074_b.func_175898_b((Vector3i)pos)) continue;
                    boolean isVecInside = false;
                    for (StructurePiece piece : this.field_75075_a) {
                        if (!piece.func_74874_b().func_175898_b((Vector3i)pos)) continue;
                        isVecInside = true;
                        break;
                    }
                    if (!isVecInside) continue;
                    for (int ruinY = y - 1; ruinY > 1 && (seedReader.func_175623_d(ruinPos = new BlockPos(x, ruinY, z)) || seedReader.func_180495_p(ruinPos).func_185904_a().func_76224_d()); --ruinY) {
                        Block brick = AtumBlocks.LIMESTONE_BRICK_LARGE;
                        if (rand.nextDouble() <= 0.2) {
                            brick = AtumBlocks.LIMESTONE_BRICK_CRACKED_BRICK;
                        } else if (rand.nextDouble() >= 0.8) {
                            brick = AtumBlocks.LIMESTONE_BRICK_SMALL;
                        }
                        seedReader.func_180501_a(ruinPos, brick.func_176223_P(), 2);
                    }
                }
            }
        }
    }
}

