/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.spawner;

import com.google.common.collect.Lists;
import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.world.spawner.BanditPatrolSpawner;
import com.teammetallurgy.atum.world.spawner.ServalSpawner;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.ISpecialSpawner;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum")
public class AtumSpawnHandling {
    public static List<ISpecialSpawner> specialSpawners = Lists.newArrayList((Object[])new ISpecialSpawner[]{new BanditPatrolSpawner(), new ServalSpawner()});

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        ResourceLocation name = event.getName();
        if (AtumConfig.Mobs.ENTITY_TYPE.containsKey((Object)name)) {
            for (EntityType entityType : AtumConfig.Mobs.ENTITY_TYPE.get((Object)name)) {
                String baseCategory = "mobs";
                EntityClassification classification = AtumConfig.Mobs.ENTITY_CLASSIFICATION.get(entityType);
                if (entityType == null || entityType.getRegistryName() == null) continue;
                String mobName = entityType.getRegistryName().func_110623_a();
                int weight = (Integer)AtumConfig.Helper.get(baseCategory, mobName, "weight");
                int min = (Integer)AtumConfig.Helper.get(baseCategory, mobName, "min");
                int max = (Integer)AtumConfig.Helper.get(baseCategory, mobName, "max");
                event.getSpawns().getSpawner(classification).add(new MobSpawnInfo.Spawners(entityType, weight, min, max));
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        ServerWorld serverWorld;
        boolean doMobSpawning;
        if (event.world.func_234923_W_() == Atum.ATUM && event.world instanceof ServerWorld && (doMobSpawning = (serverWorld = (ServerWorld)event.world).func_82736_K().func_223586_b(GameRules.field_223601_d))) {
            for (ISpecialSpawner specialSpawner : specialSpawners) {
                specialSpawner.func_230253_a_(serverWorld, serverWorld.func_175659_aa() != Difficulty.PEACEFUL, true);
            }
        }
    }
}

