/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.teleporter;

import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumPointsOfInterest;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.common.util.ITeleporter;

public class TeleporterAtum
implements ITeleporter {
    public static final TeleporterAtum INSTANCE = new TeleporterAtum();

    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        Entity movedEntity = repositionEntity.apply(false);
        if (!this.placeInPortal(destWorld, entity, yaw)) {
            this.makePortal(destWorld, movedEntity);
            this.placeInPortal(destWorld, movedEntity, yaw);
            return movedEntity;
        }
        this.placeInPortal(destWorld, movedEntity, yaw);
        return movedEntity;
    }

    public boolean placeInPortal(ServerWorld world, Entity entity, float yaw) {
        PortalInfo portalInfo = this.getPortalInfo(entity, world, null);
        if (portalInfo == null) {
            return false;
        }
        Vector3d vec3d1 = portalInfo.field_222505_a;
        Vector3d vec3d2 = portalInfo.field_222506_b;
        entity.func_213317_d(vec3d2);
        entity.field_70177_z = yaw + portalInfo.field_242960_c;
        entity.func_225653_b_(vec3d1.field_72450_a, vec3d1.field_72448_b + 1.0, vec3d1.field_72449_c);
        return true;
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerWorld destWorld, Function<ServerWorld, PortalInfo> defaultPortalInfo) {
        Optional<TeleportationRepositioner.Result> result = this.teleporterResult(destWorld, entity.func_233580_cy_());
        if (result.isPresent()) {
            BlockPos startPos = result.get().field_243679_a;
            return new PortalInfo(new Vector3d((double)startPos.func_177958_n(), (double)startPos.func_177956_o(), (double)startPos.func_177952_p()), entity.func_213322_ci(), entity.field_70177_z, entity.field_70125_A);
        }
        return new PortalInfo(entity.func_213303_ch(), Vector3d.field_186680_a, entity.field_70177_z, entity.field_70125_A);
    }

    protected Optional<TeleportationRepositioner.Result> teleporterResult(ServerWorld serverWorld, BlockPos pos) {
        Optional<TeleportationRepositioner.Result> optional = this.getExistingPortal(serverWorld, pos);
        if (optional.isPresent()) {
            return optional;
        }
        Optional<TeleportationRepositioner.Result> optional1 = this.createPortal((World)serverWorld, pos);
        if (!optional1.isPresent()) {
            Atum.LOG.error("Unable to create a portal, likely target out of worldborder");
        }
        return optional1;
    }

    public Optional<TeleportationRepositioner.Result> getExistingPortal(ServerWorld serverWorld, BlockPos pos) {
        PointOfInterestManager posManager = serverWorld.func_217443_B();
        int i = 128;
        posManager.func_226347_a_((IWorldReader)serverWorld, pos, i);
        Optional<PointOfInterest> optional = posManager.func_226353_b_(poiType -> poiType == AtumPointsOfInterest.PORTAL, pos, i, PointOfInterestManager.Status.ANY).sorted(Comparator.comparingDouble(poi -> poi.func_218261_f().func_177951_i((Vector3i)pos)).thenComparingInt(poi -> poi.func_218261_f().func_177956_o())).findFirst();
        return optional.map(poi -> {
            BlockPos posPos = poi.func_218261_f();
            serverWorld.func_72863_F().func_217228_a(TicketType.field_219493_f, new ChunkPos(posPos), 3, (Object)posPos);
            BlockState blockstate = serverWorld.func_180495_p(posPos);
            return TeleportationRepositioner.func_243676_a((BlockPos)posPos, (Direction.Axis)Direction.Axis.X, (int)9, (Direction.Axis)Direction.Axis.Z, (int)9, posIn -> serverWorld.func_180495_p(posIn) == blockstate);
        });
    }

    public Optional<TeleportationRepositioner.Result> makePortal(ServerWorld world, @Nonnull Entity entity) {
        return this.createPortal((World)world, new BlockPos(MathHelper.func_76128_c((double)entity.func_226277_ct_()), MathHelper.func_76128_c((double)entity.func_226278_cu_()), MathHelper.func_76128_c((double)entity.func_226281_cx_())));
    }

    public Optional<TeleportationRepositioner.Result> createPortal(World world, BlockPos pos) {
        BlockState portalState = AtumBlocks.PORTAL.func_176223_P();
        while (pos.func_177956_o() > 1 && world.func_175623_d(pos)) {
            pos = pos.func_177977_b();
        }
        while (!(world.func_175623_d(pos.func_177984_a()) || world.func_180495_p(pos).func_177230_c() == AtumBlocks.SAND && world.func_180495_p(pos).func_177230_c() == Blocks.field_150349_c)) {
            pos = pos.func_177984_a();
        }
        BlockState sandState = world.func_234923_W_() == World.field_234918_g_ ? Blocks.field_150322_A.func_176223_P() : AtumBlocks.LIMESTONE_BRICK_LARGE.func_176223_P();
        for (BlockPos basePos : BlockPos.Mutable.func_218278_a((BlockPos)pos.func_177982_a(-2, 0, -2), (BlockPos)pos.func_177982_a(2, 1, 2))) {
            world.func_180501_a(basePos, sandState, 2);
        }
        for (int y = 2; y < 4; ++y) {
            world.func_180501_a(pos.func_177982_a(-2, y, -2), sandState, 2);
            world.func_180501_a(pos.func_177982_a(2, y, -2), sandState, 2);
            world.func_180501_a(pos.func_177982_a(-2, y, 2), sandState, 2);
            world.func_180501_a(pos.func_177982_a(2, y, 2), sandState, 2);
        }
        for (BlockPos portalPos : BlockPos.Mutable.func_218278_a((BlockPos)pos.func_177982_a(-1, 1, -1), (BlockPos)pos.func_177982_a(1, 1, 1))) {
            world.func_180501_a(portalPos, portalState, 2);
        }
        for (BlockPos airPos : BlockPos.Mutable.func_218278_a((BlockPos)pos.func_177982_a(-2, 2, -1), (BlockPos)pos.func_177982_a(2, 3, 1))) {
            world.func_180501_a(airPos, Blocks.field_150350_a.func_176223_P(), 2);
        }
        return Optional.of(new TeleportationRepositioner.Result(pos.func_185334_h(), 3, 3));
    }
}

