/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.teleporter;

import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.init.AtumFeatures;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.world.DimensionHelper;
import com.teammetallurgy.atum.world.teleporter.TeleporterAtum;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class TeleporterAtumStart
implements ITeleporter {
    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        BlockPos spawnPos = DimensionHelper.getSurfacePos((World)destWorld, destWorld.func_241135_u_());
        if (!DimensionHelper.getData(destWorld).hasStartStructureSpawned()) {
            this.onInitialAtumJoining(destWorld, spawnPos);
            DimensionHelper.getData(destWorld).setHasStartStructureSpawned(true);
        }
        return this.onAtumJoining(destWorld, repositionEntity.apply(false), spawnPos, yaw);
    }

    private Entity onAtumJoining(ServerWorld world, Entity entity, BlockPos spawnPos, float yaw) {
        if (world.func_234923_W_() == Atum.ATUM) {
            if (((Boolean)AtumConfig.ATUM_START.startInAtumPortal.get()).booleanValue()) {
                TeleporterAtum teleporterAtum = TeleporterAtum.INSTANCE;
                teleporterAtum.makePortal(world, entity);
                teleporterAtum.placeInPortal(world, entity, yaw);
            } else {
                entity.field_70177_z = yaw;
                entity.func_225653_b_((double)spawnPos.func_177958_n(), (double)(spawnPos.func_177956_o() + 1), (double)spawnPos.func_177952_p());
            }
        }
        return entity;
    }

    private void onInitialAtumJoining(ServerWorld world, BlockPos spawnPos) {
        if (world.func_234923_W_() == Atum.ATUM) {
            if (((Boolean)AtumConfig.ATUM_START.startInAtumPortal.get()).booleanValue()) {
                spawnPos = spawnPos.func_177982_a(4, 0, 4);
            }
            if (!((String)AtumConfig.ATUM_START.atumStartStructure.get()).isEmpty()) {
                ConfiguredFeature startStructure = AtumFeatures.START_STRUCTURE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
                startStructure.func_242765_a((ISeedReader)world, world.func_72863_F().func_201711_g(), world.field_73012_v, spawnPos);
            }
            if (world.func_73046_m().func_240793_aU_().func_230418_z_().func_236223_d_()) {
                ConfiguredFeature bonusCrate = AtumFeatures.BONUS_CRATE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);
                bonusCrate.func_242765_a((ISeedReader)world, world.func_72863_F().func_201711_g(), world.field_73012_v, spawnPos);
            }
        }
    }
}

