/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.core.ModContainers;
import com.mrcrayfish.backpacked.core.ModItems;
import com.mrcrayfish.backpacked.integration.Curios;
import com.mrcrayfish.backpacked.inventory.ExtendedPlayerInventory;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.network.PacketHandler;
import com.mrcrayfish.backpacked.network.message.MessageUpdateBackpack;
import com.mrcrayfish.backpacked.proxy.ClientProxy;
import com.mrcrayfish.backpacked.proxy.CommonProxy;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="backpacked")
public class Backpacked {
    public static final ResourceLocation EMPTY_BACKPACK_SLOT = new ResourceLocation("backpacked", "item/empty_backpack_slot");
    public static final CommonProxy PROXY = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    private static boolean controllableLoaded = false;
    private static boolean curiosLoaded = false;
    private static List<ResourceLocation> bannedItemsList;

    public Backpacked() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onTextureStitch));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCommonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onEnqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigLoad);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.serverSpec);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModContainers.REGISTER.register(bus);
        ModItems.REGISTER.register(bus);
        controllableLoaded = ModList.get().isLoaded("controllable");
        curiosLoaded = ModList.get().isLoaded("curios");
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        PacketHandler.init();
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        PROXY.setupClient();
    }

    private void onEnqueueIMC(InterModEnqueueEvent event) {
        if (!curiosLoaded) {
            return;
        }
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerRenderScreen(GuiContainerEvent.DrawBackground event) {
        CreativeScreen creativeScreen;
        if (curiosLoaded) {
            return;
        }
        ContainerScreen screen = event.getGuiContainer();
        if (screen instanceof InventoryScreen) {
            InventoryScreen inventoryScreen = (InventoryScreen)screen;
            int left = inventoryScreen.getGuiLeft();
            int top = inventoryScreen.getGuiTop();
            inventoryScreen.getMinecraft().func_110434_K().func_110577_a(ContainerScreen.field_147001_a);
            Screen.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)(left + 76), (int)(top + 43), (float)7.0f, (float)7.0f, (int)18, (int)18, (int)256, (int)256);
        } else if (screen instanceof CreativeScreen && (creativeScreen = (CreativeScreen)screen).func_147056_g() == ItemGroup.field_78036_m.func_78021_a()) {
            int left = creativeScreen.getGuiLeft();
            int top = creativeScreen.getGuiTop();
            creativeScreen.getMinecraft().func_110434_K().func_110577_a(ContainerScreen.field_147001_a);
            Screen.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)(left + 126), (int)(top + 19), (float)7.0f, (float)7.0f, (int)18, (int)18, (int)256, (int)256);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
            event.addSprite(EMPTY_BACKPACK_SLOT);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (curiosLoaded) {
            return;
        }
        PlayerEntity oldPlayer = event.getOriginal();
        if (oldPlayer.field_71071_by instanceof ExtendedPlayerInventory && event.getPlayer().field_71071_by instanceof ExtendedPlayerInventory) {
            ((ExtendedPlayerInventory)event.getPlayer().field_71071_by).copyBackpack((ExtendedPlayerInventory)oldPlayer.field_71071_by);
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        ItemStack backpack;
        if (curiosLoaded) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (player.field_71071_by instanceof ExtendedPlayerInventory && !(backpack = (ItemStack)((ExtendedPlayerInventory)player.field_71071_by).getBackpackItems().get(0)).func_190926_b() && backpack.func_77973_b() instanceof BackpackItem) {
            PacketHandler.instance.send(PacketDistributor.TRACKING_ENTITY.with(() -> player), (Object)new MessageUpdateBackpack(player.func_145782_y(), backpack));
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (curiosLoaded) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        PlayerEntity player = event.player;
        if (!player.field_70170_p.field_72995_K && player.field_71071_by instanceof ExtendedPlayerInventory) {
            ExtendedPlayerInventory inventory = (ExtendedPlayerInventory)player.field_71071_by;
            if (!((ItemStack)inventory.backpackArray.get(0)).equals(inventory.backpackInventory.get(0))) {
                PacketHandler.instance.send(PacketDistributor.TRACKING_ENTITY.with(() -> player), (Object)new MessageUpdateBackpack(player.func_145782_y(), (ItemStack)inventory.backpackInventory.get(0)));
                inventory.backpackArray.set(0, inventory.backpackInventory.get(0));
            }
        }
    }

    public static boolean isControllableLoaded() {
        return controllableLoaded;
    }

    public static boolean isCuriosLoaded() {
        return curiosLoaded;
    }

    public static ItemStack getBackpackStack(PlayerEntity player) {
        ExtendedPlayerInventory inventory;
        ItemStack stack;
        AtomicReference<ItemStack> backpack = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
        if (Backpacked.isCuriosLoaded()) {
            backpack.set(Curios.getBackpackStack(player));
        }
        if (player.field_71071_by instanceof ExtendedPlayerInventory && (stack = (ItemStack)(inventory = (ExtendedPlayerInventory)player.field_71071_by).getBackpackItems().get(0)).func_77973_b() instanceof BackpackItem) {
            backpack.set(stack);
        }
        return backpack.get();
    }

    private void onConfigLoad(ModConfig.Loading event) {
        if (event.getConfig().getModId().equals("backpacked")) {
            this.updateBannedItemsList();
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerLogin(ClientPlayerNetworkEvent.LoggedInEvent event) {
        this.updateBannedItemsList();
    }

    private void updateBannedItemsList() {
        bannedItemsList = ImmutableList.copyOf((Collection)((List)Config.SERVER.bannedItems.get()).stream().map(ResourceLocation::new).collect(Collectors.toList()));
    }

    public static List<ResourceLocation> getBannedItemsList() {
        return bannedItemsList;
    }
}

