/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked;

import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    static {
        Pair commonPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)commonPair.getRight();
        COMMON = (Common)commonPair.getLeft();
        Pair serverPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)serverPair.getRight();
        SERVER = (Server)serverPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> bannedItems;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Common configuration settings").push("common");
            this.bannedItems = builder.comment("A list of items that are not allowed inside a backpack. Note: It is recommended to ban items that have an inventory as this will create large NBT data and potentially crash the server!").defineList("bannedItems", Collections.emptyList(), o -> {
                try {
                    ResourceLocation.func_208304_a((String)o.toString());
                    return true;
                }
                catch (ResourceLocationException e) {
                    return false;
                }
            });
            builder.pop();
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue keepBackpackOnDeath;
        public final ForgeConfigSpec.IntValue backpackInventorySize;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common configuration settings").push("common");
            this.keepBackpackOnDeath = builder.comment("Determines whether or not the backpack should be dropped on death").translation("backpacked.configgui.keepBackpackOnDeath").define("keepBackpackOnDeath", false);
            this.backpackInventorySize = builder.comment("The amount of rows the backpack has. Each row is nine slots of storage.").translation("backpacked.configgui.backpackInventorySize").defineInRange("backpackInventorySize", 1, 1, 6);
            builder.pop();
        }
    }
}

