/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.item;

import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.integration.Curios;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.inventory.ExtendedPlayerInventory;
import com.mrcrayfish.backpacked.inventory.container.BackpackContainer;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkHooks;

public class BackpackItem
extends Item {
    private static final TranslationTextComponent BACKPACK_TRANSLATION = new TranslationTextComponent("container.backpack");
    private static final ResourceLocation TEXTURE = new ResourceLocation("backpacked", "textures/entity/backpack.png");

    public BackpackItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ExtendedPlayerInventory inventory;
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        if (playerIn.field_71071_by instanceof ExtendedPlayerInventory && ((ItemStack)(inventory = (ExtendedPlayerInventory)playerIn.field_71071_by).getBackpackItems().get(0)).func_190926_b()) {
            playerIn.field_71071_by.func_70299_a(41, heldItem.func_77946_l());
            heldItem.func_190920_e(0);
            playerIn.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
            return new ActionResult(ActionResultType.SUCCESS, (Object)heldItem);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)heldItem);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (!Backpacked.isCuriosLoaded()) {
            return null;
        }
        return Curios.createBackpackProvider();
    }

    public void showInventory(ServerPlayerEntity player) {
        ItemStack backpack = Backpacked.getBackpackStack((PlayerEntity)player);
        if (!backpack.func_190926_b()) {
            TranslationTextComponent title = backpack.func_82837_s() ? backpack.func_200301_q() : BACKPACK_TRANSLATION;
            int rows = this.getRowCount();
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInventory, entity) -> new BackpackContainer(id, player.field_71071_by, (IInventory)new BackpackInventory(rows), rows), (ITextComponent)title), buffer -> buffer.func_150787_b(rows));
        }
    }

    public int getRowCount() {
        return (Integer)Config.COMMON.backpackInventorySize.get();
    }

    public ResourceLocation getModelTexture() {
        return TEXTURE;
    }
}

