/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.network.message;

import com.mrcrayfish.backpacked.network.message.IMessage;
import com.mrcrayfish.backpacked.proxy.ClientProxy;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageUpdateBackpack
implements IMessage<MessageUpdateBackpack> {
    private int entityId;
    private ItemStack backpack;

    public MessageUpdateBackpack() {
    }

    public MessageUpdateBackpack(int entityId, ItemStack backpack) {
        this.entityId = entityId;
        this.backpack = backpack;
    }

    @Override
    public void encode(MessageUpdateBackpack message, PacketBuffer buffer) {
        buffer.writeInt(message.entityId);
        this.writeItemStackNoTag(buffer, message.backpack);
    }

    @Override
    public MessageUpdateBackpack decode(PacketBuffer buffer) {
        return new MessageUpdateBackpack(buffer.readInt(), buffer.func_150791_c());
    }

    @Override
    public void handle(MessageUpdateBackpack message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> ClientProxy.setPlayerBackpack(message.entityId, message.backpack));
        supplier.get().setPacketHandled(true);
    }

    private void writeItemStackNoTag(PacketBuffer buffer, ItemStack stack) {
        boolean empty = stack.func_190926_b();
        buffer.writeBoolean(!empty);
        if (!empty) {
            Item item = stack.func_77973_b();
            buffer.func_150787_b(Item.func_150891_b((Item)item));
            buffer.writeByte(stack.func_190916_E());
            buffer.func_150786_a(null);
        }
    }
}

