/*
 * Decompiled with CFR 0.152.
 */
package commoble.bagofyurting;

import com.mojang.authlib.GameProfile;
import commoble.bagofyurting.BlockRemovalSorter;
import commoble.bagofyurting.BlockUnloadSorter;
import commoble.bagofyurting.CompressedBagOfYurtingData;
import commoble.bagofyurting.OptionalSpawnParticlePacket;
import commoble.bagofyurting.ServerConfig;
import commoble.bagofyurting.TagWrappers;
import commoble.bagofyurting.TransientPlayerData;
import commoble.bagofyurting.api.BagOfYurtingAPI;
import commoble.bagofyurting.api.BlockDataDeserializer;
import commoble.bagofyurting.api.BlockDataSerializer;
import commoble.bagofyurting.api.RotationUtil;
import commoble.bagofyurting.api.internal.DataTransformers;
import commoble.bagofyurting.util.NBTMapHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;

public class BagOfYurtingData {
    public static final String NBT_KEY = "yurtdata";
    public static final Direction BASE_DIRECTION = Direction.SOUTH;
    private static final NBTMapHelper<BlockPos, CompoundNBT, StateData, CompoundNBT> mapper = new NBTMapHelper<BlockPos, CompoundNBT, StateData, CompoundNBT>("yurtdata", NBTUtil::func_186859_a, NBTUtil::func_186861_c, StateData::write, StateData::read);
    private final Map<BlockPos, StateData> map;
    public static final AxisAlignedBB EMPTY_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public BagOfYurtingData(Map<BlockPos, StateData> map) {
        this.map = map;
    }

    public static BagOfYurtingData yurtBlocksAndConvertToData(ItemUseContext context, int radius) {
        PlayerEntity player = context.func_195999_j();
        boolean canPlayerOverrideSafetyLists = BagOfYurtingData.canPlayerOverrideSafetyLists(player);
        BlockPos origin = context.func_195995_a();
        Direction orientation = context.func_195992_f();
        World world = context.func_195991_k();
        Rotation rotation = RotationUtil.getTransformRotation(orientation);
        BlockPos minYurt = origin.func_177982_a(-radius, 0, -radius);
        BlockPos maxYurt = origin.func_177982_a(radius, 2 * radius, radius);
        List<Pair> transformPairs = BlockPos.func_218281_b((BlockPos)minYurt, (BlockPos)maxYurt).filter(pos -> BagOfYurtingData.canBlockBeStored(canPlayerOverrideSafetyLists, context, pos)).map(BlockPos::func_185334_h).sorted(new BlockRemovalSorter(world)).map(pos -> BagOfYurtingData.getTransformedPosAndStateData((IWorld)world, pos, rotation, minYurt, maxYurt, origin)).collect(Collectors.toList());
        BlockState air = Blocks.field_150350_a.func_176223_P();
        transformPairs.forEach(pair -> {
            BlockPos pos = (BlockPos)pair.getLeft();
            world.func_175713_t(pos);
            world.func_180501_a(pos, air, 0);
        });
        List<BlockPos> removedPositions = transformPairs.stream().map(Pair::getLeft).collect(Collectors.toList());
        Map<BlockPos, StateData> transformedData = transformPairs.stream().map(Pair::getRight).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        if (transformPairs.size() > 0 && world instanceof ServerWorld) {
            BagOfYurtingData.doPoofEffects((ServerWorld)world, removedPositions);
            for (Pair entry : transformPairs) {
                BlockPos pos2 = (BlockPos)entry.getKey();
                BlockState oldState = ((StateData)((Pair)entry.getValue()).getRight()).state;
                BagOfYurtingData.sendBlockUpdateAfterRemoval(world, pos2, oldState);
            }
        }
        return new BagOfYurtingData(transformedData);
    }

    private static void sendBlockUpdateAfterRemoval(World world, BlockPos pos, BlockState oldState) {
        world.func_184138_a(pos, oldState, Blocks.field_150350_a.func_176223_P(), 3);
        world.func_195593_d(pos, oldState.func_177230_c());
    }

    public boolean attemptUnloadIntoWorld(ItemUseContext context, int radius) {
        boolean success;
        BlockPos hitPos;
        World world = context.func_195991_k();
        boolean hitBlockReplaceable = world.func_180495_p(hitPos = context.func_195995_a()).func_185904_a().func_76222_j();
        BlockPos origin = hitBlockReplaceable ? hitPos : hitPos.func_177972_a(context.func_196000_l());
        Direction orientation = context.func_195992_f();
        Rotation unrotation = RotationUtil.getUntransformRotation(orientation);
        PlayerEntity player = context.func_195999_j();
        boolean canPlayerOverrideSafetyLists = BagOfYurtingData.canPlayerOverrideSafetyLists(player);
        Map<BlockPos, StateData> worldPositions = this.map.entrySet().stream().collect(Collectors.toMap(entry -> RotationUtil.untransformBlockPos(unrotation, (BlockPos)entry.getKey(), origin), entry -> (StateData)entry.getValue()));
        boolean bl = success = worldPositions.entrySet().stream().allMatch(entry -> BagOfYurtingData.canBlockBeUnloadedAt(canPlayerOverrideSafetyLists, (BlockPos)entry.getKey(), world)) && BagOfYurtingData.doesPlaceEventSucceed(context, world, player, worldPositions);
        if (success) {
            BlockPos minYurt = origin.func_177982_a(-radius, 0, -radius);
            BlockPos maxYurt = origin.func_177982_a(radius, 2 * radius, radius);
            List<Map.Entry> worldPositionList = worldPositions.entrySet().stream().sorted(BlockUnloadSorter.INSTANCE).collect(Collectors.toList());
            worldPositionList.forEach(entry -> ((StateData)entry.getValue()).setBlockIntoWorld(world, (BlockPos)entry.getKey(), unrotation));
            worldPositionList.forEach(entry -> ((StateData)entry.getValue()).setBlockEntityData(world, (BlockPos)entry.getKey(), unrotation, minYurt, maxYurt, origin));
            if (world instanceof ServerWorld) {
                BagOfYurtingData.doPoofEffects((ServerWorld)world, worldPositions.keySet());
            }
        }
        return success;
    }

    private static void doPoofEffects(ServerWorld world, Collection<BlockPos> changedPositions) {
        AxisAlignedBB aabb = changedPositions.stream().map(AxisAlignedBB::new).reduce(AxisAlignedBB::func_111270_a).orElse(EMPTY_AABB);
        if (aabb.func_72320_b() > 0.5) {
            Vector3d center = aabb.func_189972_c();
            double xRadius = aabb.func_216364_b() * 0.5;
            double yRadius = aabb.func_216360_c() * 0.5;
            double zRadius = aabb.func_216362_d() * 0.5;
            double volume = xRadius * yRadius * zRadius * 8.0;
            int particles = Math.max(5000, (int)volume * 5);
            world.func_184133_a(null, new BlockPos(center), SoundEvents.field_191244_bn, SoundCategory.PLAYERS, 1.0f, 1.0f);
            OptionalSpawnParticlePacket.spawnParticlesFromServer(world, ParticleTypes.field_197627_t, center.func_82615_a(), center.func_82617_b(), center.func_82616_c(), particles, xRadius, yRadius, zRadius, 0.0);
        }
    }

    private static boolean canPlayerOverrideSafetyLists(@Nullable PlayerEntity player) {
        if (player != null && (player.func_184812_l_() || player.func_211513_k(ServerConfig.INSTANCE.minPermissionToYurtUnyurtableBlocks.get().intValue()))) {
            return TransientPlayerData.isPlayerOverridingSafetyList(PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()));
        }
        return false;
    }

    private static boolean canBlockBeStored(boolean canPlayerOverrideSafetyLists, ItemUseContext context, BlockPos pos) {
        World world = context.func_195991_k();
        BlockState state = world.func_180495_p(pos);
        PlayerEntity player = context.func_195999_j();
        return !state.isAir((IBlockReader)context.func_195991_k(), pos) && !World.func_189509_E((BlockPos)pos) && BagOfYurtingData.isBlockYurtingAllowedByTags(canPlayerOverrideSafetyLists, state, pos) && BagOfYurtingData.doesBreakEventSucceed(world, pos, state, player);
    }

    private static boolean isBlockYurtingAllowedByTags(boolean canPlayerOverrideSafetyLists, BlockState state, BlockPos pos) {
        if (canPlayerOverrideSafetyLists) {
            return true;
        }
        Block block = state.func_177230_c();
        return !TagWrappers.blacklist.func_230235_a_((Object)block) && (TagWrappers.whitelist.func_230236_b_().isEmpty() || TagWrappers.whitelist.func_230235_a_((Object)block));
    }

    private static boolean doesBreakEventSucceed(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!(world instanceof ServerWorld)) {
            return false;
        }
        PlayerEntity eventPlayer = player != null ? player : FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, eventPlayer);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    private static boolean doesPlaceEventSucceed(ItemUseContext context, World world, PlayerEntity player, Map<BlockPos, StateData> worldPositions) {
        if (!(world instanceof ServerWorld)) {
            return false;
        }
        PlayerEntity eventPlayer = player != null ? player : FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
        List snapshots = worldPositions.keySet().stream().map(pos -> BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)pos)).collect(Collectors.toList());
        BlockState statePlacedAgainst = world.func_180495_p(context.func_195995_a());
        BlockEvent.EntityMultiPlaceEvent event = new BlockEvent.EntityMultiPlaceEvent(snapshots, statePlacedAgainst, (Entity)eventPlayer);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    private static Pair<BlockPos, Pair<BlockPos, StateData>> getTransformedPosAndStateData(IWorld world, BlockPos absolutePos, Rotation rotation, BlockPos minYurt, BlockPos maxYurt, BlockPos origin) {
        BlockPos transformedPos = RotationUtil.transformBlockPos(rotation, absolutePos, origin);
        StateData stateData = BagOfYurtingData.getYurtedStateData(world, absolutePos, rotation, minYurt, maxYurt, origin, transformedPos);
        return Pair.of((Object)absolutePos, (Object)Pair.of((Object)transformedPos, (Object)stateData));
    }

    private static StateData getYurtedStateData(IWorld world, BlockPos pos, Rotation rotation, BlockPos minYurt, BlockPos maxYurt, BlockPos origin, BlockPos transformedPos) {
        CompoundNBT nbt = new CompoundNBT();
        BlockState state = world.func_180495_p(pos);
        BlockState rotatedState = state.rotate(world, pos, rotation);
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            BlockDataSerializer<?> serializer = DataTransformers.transformers.getOrDefault(te.func_200662_C(), BagOfYurtingAPI.DEFAULT_TRANSFORMER).getSerializer();
            serializer.writeWithYurtContext(te, nbt, rotation, minYurt, maxYurt, origin, transformedPos);
        }
        return new StateData(rotatedState, nbt);
    }

    private static boolean canBlockBeUnloadedAt(boolean canPlayerOverrideSafetyLists, BlockPos pos, World world) {
        if (canPlayerOverrideSafetyLists) {
            return true;
        }
        BlockState oldState = world.func_180495_p(pos);
        return oldState.isAir((IBlockReader)world, pos) || TagWrappers.replaceable.func_230235_a_((Object)oldState.func_177230_c()) || oldState.func_185904_a().func_76222_j();
    }

    public static boolean doesNBTContainYurtData(CompoundNBT nbt) {
        return !nbt.func_150295_c(NBT_KEY, 10).isEmpty();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public CompoundNBT writeIntoNBT(CompoundNBT nbt) {
        mapper.write(this.map, nbt);
        return nbt;
    }

    public static BagOfYurtingData read(CompoundNBT nbt) {
        return new BagOfYurtingData(mapper.read(nbt));
    }

    public CompressedBagOfYurtingData compress() {
        Object2IntOpenHashMap indexMap = new Object2IntOpenHashMap();
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        ArrayList<CompressedBagOfYurtingData.CompressedStateData> data = new ArrayList<CompressedBagOfYurtingData.CompressedStateData>();
        this.map.forEach((arg_0, arg_1) -> BagOfYurtingData.lambda$compress$10((Object2IntMap)indexMap, states, data, arg_0, arg_1));
        return new CompressedBagOfYurtingData(states, data);
    }

    private static /* synthetic */ void lambda$compress$10(Object2IntMap indexMap, List states, List data, BlockPos pos, StateData stateData) {
        BlockState state = stateData.state;
        CompoundNBT nbt = stateData.tileEntityData;
        Optional<CompoundNBT> optionalNBT = nbt == null || nbt.isEmpty() ? Optional.empty() : Optional.of(nbt);
        int index = (Integer)indexMap.computeIfAbsent((Object)state, newState -> {
            int newIndex = states.size();
            states.add(state);
            return newIndex;
        });
        CompressedBagOfYurtingData.CompressedStateData compressedData = new CompressedBagOfYurtingData.CompressedStateData(pos, index, optionalNBT);
        data.add(compressedData);
    }

    public static class StateData {
        public static final String BLOCKSTATE = "state";
        public static final String TILE = "te";
        @Nonnull
        private final BlockState state;
        @Nonnull
        private final CompoundNBT tileEntityData;

        public StateData(@Nonnull BlockState state, @Nonnull CompoundNBT tileEntityData) {
            this.state = state;
            this.tileEntityData = tileEntityData;
        }

        public BlockState getState() {
            return this.state;
        }

        public void setBlockIntoWorld(World world, BlockPos pos, Rotation unrotation) {
            world.func_175656_a(pos, this.state.func_185907_a(unrotation));
        }

        public void setBlockEntityData(World world, BlockPos pos, Rotation unrotation, BlockPos minYurt, BlockPos maxYurt, BlockPos origin) {
            TileEntity te;
            if (!this.tileEntityData.isEmpty() && (te = world.func_175625_s(pos)) != null) {
                BlockDataDeserializer<?> x = DataTransformers.transformers.getOrDefault(te.func_200662_C(), BagOfYurtingAPI.DEFAULT_TRANSFORMER).getDeserializer();
                x.readWithYurtContext(te, this.tileEntityData, world, pos, this.state, unrotation, minYurt, maxYurt, origin);
                te.func_226984_a_(world, pos);
            }
        }

        public CompoundNBT write() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_218657_a(BLOCKSTATE, (INBT)NBTUtil.func_190009_a((BlockState)this.state));
            nbt.func_218657_a(TILE, (INBT)this.tileEntityData);
            return nbt;
        }

        public static StateData read(CompoundNBT nbt) {
            BlockState state = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l(BLOCKSTATE));
            CompoundNBT te = nbt.func_74775_l(TILE);
            return new StateData(state, te);
        }
    }
}

