/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.berry_good.core.registry.util;

import com.minecraftabnormals.berry_good.core.registry.BGBlocks;
import com.minecraftabnormals.berry_good.core.registry.BGItems;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Rarity;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.TallBlockItem;
import net.minecraft.item.WallOrFloorItem;
import net.minecraftforge.fml.RegistryObject;

public class RegistryUtils {
    public static BlockItem createWallOrFloorItem(Block floorBlock, Block wallBlock, ItemGroup itemGroup) {
        return (BlockItem)new WallOrFloorItem(floorBlock, wallBlock, new Item.Properties().func_200916_a(itemGroup)).setRegistryName(floorBlock.getRegistryName());
    }

    public static BlockItem createTallItemBlock(Block block, ItemGroup itemGroup) {
        return (BlockItem)new TallBlockItem(block, new Item.Properties().func_200916_a(itemGroup)).setRegistryName(block.getRegistryName());
    }

    public static Item createSimpleItem(String name, ItemGroup itemGroup) {
        return (Item)new Item(new Item.Properties().func_200916_a(itemGroup)).setRegistryName("berry_good", name);
    }

    public static Item createSpawnEggForEntity(EntityType entityType, int eggColor1, int eggColor2, ItemGroup itemGroup) {
        return (Item)new SpawnEggItem(entityType, eggColor1, eggColor2, new Item.Properties().func_200916_a(itemGroup)).setRegistryName(entityType.getRegistryName() + "_spawn_egg");
    }

    public static BlockItem createSimpleItemBlock(Block block, ItemGroup itemGroup) {
        return (BlockItem)new BlockItem(block, new Item.Properties().func_200916_a(itemGroup)).setRegistryName(block.getRegistryName());
    }

    public static Item createItemBlockWithRarity(Block blockForInput, ItemGroup itemGroup, Rarity rarity) {
        return (BlockItem)new BlockItem(blockForInput, new Item.Properties().func_200916_a(itemGroup).func_208103_a(rarity)).setRegistryName(blockForInput.getRegistryName());
    }

    public static <I extends Item> RegistryObject<I> createItem(String name, Supplier<? extends I> supplier) {
        RegistryObject item = BGItems.ITEMS.register(name, supplier);
        return item;
    }

    public static <B extends Block> RegistryObject<B> createBlock(String name, Supplier<? extends B> supplier, ItemGroup itemGroup) {
        RegistryObject block = BGBlocks.BLOCKS.register(name, supplier);
        BGItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(itemGroup)));
        return block;
    }

    public static <B extends Block> RegistryObject<B> createBlockNoItem(String name, Supplier<? extends B> supplier) {
        RegistryObject block = BGBlocks.BLOCKS.register(name, supplier);
        return block;
    }
}

