/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimals.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mushroom.midnight.common.entity.creature.NightStagEntity;
import dev.itsmeow.betteranimals.client.BetterAnimalsConfig;
import dev.itsmeow.betteranimals.client.model.ModelNewBear;
import dev.itsmeow.betteranimals.client.model.ModelNewCat;
import dev.itsmeow.betteranimals.client.model.ModelNewChicken;
import dev.itsmeow.betteranimals.client.model.ModelNewCow;
import dev.itsmeow.betteranimals.client.model.ModelNewDolphin;
import dev.itsmeow.betteranimals.client.model.ModelNewFox;
import dev.itsmeow.betteranimals.client.model.ModelNewPig;
import dev.itsmeow.betteranimals.client.model.ModelNewSheep;
import dev.itsmeow.betteranimals.client.model.ModelNewSilverfish;
import dev.itsmeow.betteranimals.client.model.ModelNewSpider;
import dev.itsmeow.betteranimals.client.model.ModelNewSquid;
import dev.itsmeow.betteranimals.client.model.ModelNewWolf;
import dev.itsmeow.betteranimals.client.render.entity.compat.RenderNewNightstag;
import dev.itsmeow.betteranimals.client.render.entity.layer.LayerNewCatCollar;
import dev.itsmeow.betteranimals.client.render.entity.layer.LayerNewDolphinItem;
import dev.itsmeow.betteranimals.client.render.entity.layer.LayerNewFoxItem;
import dev.itsmeow.betteranimals.client.render.entity.layer.LayerNewMooshroomMushroom;
import dev.itsmeow.betteranimals.client.render.entity.layer.LayerNewPigSaddle;
import dev.itsmeow.betteranimals.client.render.entity.layer.LayerNewSheepWool;
import dev.itsmeow.betteranimals.client.render.entity.layer.LayerNewSpiderEyes;
import dev.itsmeow.betteranimals.client.render.entity.layer.LayerNewWolfCollar;
import dev.itsmeow.betteranimals.compat.QuarkUtil;
import dev.itsmeow.betteranimals.imdlib.client.IMDLibClient;
import dev.itsmeow.betteranimals.imdlib.client.render.ImplRenderer;
import dev.itsmeow.betteranimals.imdlib.client.util.ModelReplacementHandler;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.ModList;

public class Replacements {
    public static final ModelReplacementHandler H = IMDLibClient.getReplacementHandler("betteranimals");

    public static void addReplaces() {
        ImplRenderer.RenderDef cow = r -> r.childScale(0.5f).tSingle("cow").mSingle(new ModelNewCow());
        ImplRenderer.RenderDef pig = r -> r.childScale(0.5f).layer(LayerNewPigSaddle::new).tSingle("pig").mSingle(new ModelNewPig());
        ImplRenderer.RenderDef chicken = r -> r.childScale(0.45f).handleRotation((e, p) -> {
            float f = e.field_70888_h + (e.field_70886_e - e.field_70888_h) * p;
            float f1 = e.field_70884_g + (e.field_70883_f - e.field_70884_g) * p;
            return (MathHelper.func_76126_a((float)f) + 1.0f) * f1;
        }).tSingle("chicken").mSingle(new ModelNewChicken());
        H.addAction(ModelReplacementHandler.RegistrationTime.CLIENTSETUP, "minecraft", () -> () -> {
            boolean quarkLoaded = ModList.get().isLoaded("quark");
            if (!quarkLoaded || !((Boolean)BetterAnimalsConfig.enableQuarkOverrideCow.get()).booleanValue()) {
                H.addReplace(ModelReplacementHandler.RegistrationTime.CLIENTSETUP, "minecraft", "cow", () -> () -> H.lambdaReplace(CowEntity.class, 0.7f, cow));
            }
            if (!quarkLoaded || !((Boolean)BetterAnimalsConfig.enableQuarkOverridePig.get()).booleanValue()) {
                H.addReplace(ModelReplacementHandler.RegistrationTime.CLIENTSETUP, "minecraft", "pig", () -> () -> H.lambdaReplace(PigEntity.class, 0.7f, pig));
            }
            if (!quarkLoaded || !((Boolean)BetterAnimalsConfig.enableQuarkOverrideChicken.get()).booleanValue()) {
                H.addReplace(ModelReplacementHandler.RegistrationTime.CLIENTSETUP, "minecraft", "chicken", () -> () -> H.lambdaReplace(ChickenEntity.class, 0.4f, chicken));
            }
        });
        H.addAction(ModelReplacementHandler.RegistrationTime.CLIENTSETUP, "quark", () -> () -> {
            if (((Boolean)BetterAnimalsConfig.enableQuarkOverrideCow.get()).booleanValue()) {
                H.addReplace(ModelReplacementHandler.RegistrationTime.CLIENTSETUP, "minecraft", "cow", () -> () -> H.lambdaReplace(CowEntity.class, 0.7f, r -> cow.apply(r).tMappedRaw(e -> QuarkUtil.getTextureOrShiny((Entity)e, QuarkUtil.VariantTextureType.COW))));
            }
            if (((Boolean)BetterAnimalsConfig.enableQuarkOverridePig.get()).booleanValue()) {
                H.addReplace(ModelReplacementHandler.RegistrationTime.CLIENTSETUP, "minecraft", "pig", () -> () -> H.lambdaReplace(PigEntity.class, 0.7f, r -> pig.apply(r).tMappedRaw(e -> QuarkUtil.getTextureOrShiny((Entity)e, QuarkUtil.VariantTextureType.PIG))));
            }
            if (((Boolean)BetterAnimalsConfig.enableQuarkOverrideChicken.get()).booleanValue()) {
                H.addReplace(ModelReplacementHandler.RegistrationTime.CLIENTSETUP, "minecraft", "chicken", () -> () -> H.lambdaReplace(ChickenEntity.class, 0.4f, r -> chicken.apply(r).tMappedRaw(e -> QuarkUtil.getTextureOrShiny((Entity)e, QuarkUtil.VariantTextureType.CHICKEN))));
            }
        });
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "sheep", () -> () -> H.lambdaReplace(SheepEntity.class, 0.4f, r -> r.childScale(0.5f).layer(LayerNewSheepWool::new).tMapped(e -> e.func_70631_g_() ? "lamb" : "sheep").mSingle(new ModelNewSheep())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "wolf", () -> () -> H.lambdaReplace(WolfEntity.class, 0.25f, r -> r.preRender((e, p) -> {
            GlStateManager.scaled((double)0.8, (double)0.8, (double)0.8);
            if (e.func_70631_g_()) {
                GlStateManager.scaled((double)0.5, (double)0.5, (double)0.5);
            }
            if (e.func_70921_u()) {
                float f = e.func_70013_c() * e.func_70915_j(p);
                GlStateManager.color3f((float)f, (float)f, (float)f);
            }
        }).handleRotation((e, p) -> e.func_70920_v()).layer(LayerNewWolfCollar::new).tMapped(e -> e.func_70909_n() ? "wolf/wolf_tame" : (e.func_70919_bu() ? "wolf/wolf_angry" : "wolf/wolf")).mSingle(new ModelNewWolf())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "mooshroom", () -> () -> H.lambdaReplace(MooshroomEntity.class, 0.7f, r -> r.preRender((e, p) -> {
            if (e.func_70631_g_()) {
                GlStateManager.scalef((float)0.36f, (float)0.36f, (float)0.36f);
            } else {
                GlStateManager.translatef((float)0.0f, (float)0.15f, (float)0.0f);
            }
        }).layer(LayerNewMooshroomMushroom::new).tCondition(e -> e.func_213444_dV() == MooshroomEntity.Type.RED, "mooshroom", "mooshroom_brown").mSingle(new ModelNewCow())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "squid", () -> () -> H.lambdaReplace(SquidEntity.class, 0.7f, r -> r.applyRotations((e, a, rot, p) -> {
            float f = e.field_70862_e + (e.field_70861_d - e.field_70862_e) * p;
            float f1 = e.field_70860_g + (e.field_70859_f - e.field_70860_g) * p;
            GlStateManager.translatef((float)0.0f, (float)0.5f, (float)0.0f);
            GlStateManager.rotatef((float)(180.0f - rot), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)f1, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translatef((float)0.0f, (float)-1.2f, (float)0.0f);
        }).handleRotation((e, p) -> -(e.field_70865_by + (e.field_70866_j - e.field_70865_by) * p)).tSingle("squid").mSingle(new ModelNewSquid())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "spider", () -> () -> H.lambdaReplace(SpiderEntity.class, 1.0f, r -> r.preRender((e, p) -> {
            if (e.func_70841_p()) {
                GlStateManager.rotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.translatef((float)0.0f, (float)0.75f, (float)-0.5f);
            }
        }).layer(LayerNewSpiderEyes::new).tSingle("spider").mSingle(new ModelNewSpider())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "cavespider", () -> () -> H.lambdaReplace(CaveSpiderEntity.class, 0.4f, r -> r.preRender((e, p) -> {
            if (e.func_70841_p()) {
                GlStateManager.rotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.translatef((float)0.0f, (float)0.75f, (float)-0.5f);
            }
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        }).layer(LayerNewSpiderEyes::new).tSingle("cave_spider").mSingle(new ModelNewSpider())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "silverfish", () -> () -> H.lambdaReplace(SilverfishEntity.class, 0.25f, r -> r.preRender((e, p) -> GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f)).tSingle("silverfish").mSingle(new ModelNewSilverfish())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "polarbear", () -> () -> H.lambdaReplace(PolarBearEntity.class, 0.7f, r -> r.childScale(0.7f).tSingle("polarbear").mSingle(new ModelNewBear())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "ocelot", () -> () -> H.lambdaReplace(OcelotEntity.class, 0.5f, r -> r.preRender((e, p) -> {
            GlStateManager.scaled((double)0.8, (double)0.8, (double)0.8);
            if (e.func_70631_g_()) {
                GlStateManager.scaled((double)0.5, (double)0.5, (double)0.5);
            }
        }).tSingle("cat/ocelot").mSingle(new ModelNewCat())));
        Map catTextures = (Map)Util.func_200696_a((Object)Maps.newHashMap(), map -> {
            map.put(0, "cat/tabby");
            map.put(1, "cat/black");
            map.put(2, "cat/red");
            map.put(3, "cat/siamese");
            map.put(4, "cat/british_shorthair");
            map.put(5, "cat/calico");
            map.put(6, "cat/persian");
            map.put(7, "cat/ragdoll");
            map.put(8, "cat/white");
            map.put(9, "cat/jellie");
            map.put(10, "cat/all_black");
        });
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "cat", () -> () -> H.lambdaReplace(CatEntity.class, 0.5f, r -> r.preRender((e, p) -> {
            GlStateManager.scaled((double)0.8, (double)0.8, (double)0.8);
            if (e.func_70909_n()) {
                GlStateManager.scaled((double)0.9, (double)0.9, (double)0.9);
            }
            if (e.func_70631_g_()) {
                GlStateManager.scaled((double)0.5, (double)0.5, (double)0.5);
            }
        }).layer(LayerNewCatCollar::new).tMapped(e -> (String)catTextures.get(e.func_213413_ef())).mSingle(new ModelNewCat())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "fox", () -> () -> H.lambdaReplace(FoxEntity.class, 0.4f, r -> r.preRender((e, p) -> {
            if (e.func_70631_g_()) {
                GlStateManager.scaled((double)0.5, (double)0.5, (double)0.5);
            }
            if (e.func_70608_bn()) {
                GlStateManager.translatef((float)0.0f, (float)0.5f, (float)0.0f);
            }
            if (e.func_213455_dW()) {
                GlStateManager.translatef((float)0.0f, (float)0.2f, (float)0.0f);
            }
        }).applyRotations((e, a, rot, p) -> {
            if (e.func_213480_dY() || e.func_213472_dX()) {
                GlStateManager.rotatef((float)(-MathHelper.func_219799_g((float)p, (float)e.field_70127_C, (float)e.field_70125_A)), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }, ImplRenderer.SuperCallApplyRotations.PRE).layer(LayerNewFoxItem::new).tMapped(e -> e.func_213471_dV() == FoxEntity.Type.RED ? (e.func_70608_bn() ? "fox/fox_sleep" : "fox/fox") : (e.func_70608_bn() ? "fox/snow_fox_sleep" : "fox/snow_fox")).mSingle(new ModelNewFox())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "dolphin", () -> () -> H.lambdaReplace(DolphinEntity.class, 0.7f, r -> r.layer(LayerNewDolphinItem::new).tSingle("dolphin").mSingle(new ModelNewDolphin())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "midnight", "nightstag", () -> () -> MidnightReplaces.NIGHTSTAG);
    }

    public static class MidnightReplaces {
        public static final ModelReplacementHandler.ReplaceDefinition<NightStagEntity> NIGHTSTAG = new ModelReplacementHandler.ReplaceDefinition<NightStagEntity>(NightStagEntity.class, RenderNewNightstag::new);
    }
}

