/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimals.compat;

import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import vazkii.quark.client.module.VariantAnimalTexturesModule;

public class QuarkUtil {
    private static ListMultimap<VariantTextureType, ResourceLocation> textures = Multimaps.newListMultimap(new EnumMap(VariantTextureType.class), ArrayList::new);
    private static Map<VariantTextureType, ResourceLocation> shinyTextures = new HashMap<VariantTextureType, ResourceLocation>();
    private static final int COW_COUNT = 10;
    private static final int PIG_COUNT = 3;
    private static final int CHICKEN_COUNT = 6;

    public static ResourceLocation getTextureOrShiny(Entity e, VariantTextureType type) {
        return QuarkUtil.getTextureOrShiny(e, type, (Supplier<ResourceLocation>)((Supplier)() -> QuarkUtil.getRandomTexture(e, type)));
    }

    public static ResourceLocation getTextureOrShiny(Entity e, VariantTextureType type, Supplier<ResourceLocation> nonShiny) {
        UUID id = e.func_110124_au();
        long most = id.getMostSignificantBits();
        if (VariantAnimalTexturesModule.shinyAnimalChance > 0 && most % (long)VariantAnimalTexturesModule.shinyAnimalChance == 0L) {
            return shinyTextures.get((Object)type);
        }
        return (ResourceLocation)nonShiny.get();
    }

    private static ResourceLocation getRandomTexture(Entity e, VariantTextureType type) {
        List styles = textures.get((Object)type);
        UUID id = e.func_110124_au();
        long most = id.getMostSignificantBits();
        int choice = Math.abs((int)(most % (long)styles.size()));
        return (ResourceLocation)styles.get(choice);
    }

    private static void registerTextures(VariantTextureType type, int count, String vanilla) {
        String name = type.name().toLowerCase();
        for (int i = 1; i < count + 1; ++i) {
            textures.put((Object)type, (Object)QuarkUtil.tex(String.format("quark/%s%d", name, i)));
        }
        if (vanilla != null) {
            textures.put((Object)type, (Object)QuarkUtil.tex(vanilla));
        }
        shinyTextures.put(type, QuarkUtil.tex(String.format("quark/%s_shiny", name)));
    }

    private static ResourceLocation tex(String name) {
        return new ResourceLocation("betteranimals", "textures/entity/" + name + ".png");
    }

    static {
        QuarkUtil.registerTextures(VariantTextureType.COW, 10, "cow");
        QuarkUtil.registerTextures(VariantTextureType.PIG, 3, "pig");
        QuarkUtil.registerTextures(VariantTextureType.CHICKEN, 6, "quark/chicken");
    }

    public static enum VariantTextureType {
        COW,
        PIG,
        CHICKEN;

    }
}

