/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimals.imdlib.entity.util;

import com.google.common.collect.ImmutableList;
import dev.itsmeow.betteranimals.imdlib.entity.util.EntityVariantList;
import dev.itsmeow.betteranimals.imdlib.entity.util.ISelectiveVariantTypes;
import dev.itsmeow.betteranimals.imdlib.entity.util.IVariant;
import dev.itsmeow.betteranimals.imdlib.entity.util.builder.AbstractEntityBuilder;
import dev.itsmeow.betteranimals.imdlib.entity.util.builder.EntityTypeDefinition;
import dev.itsmeow.betteranimals.imdlib.entity.util.builder.IEntityTypeDefinition;
import dev.itsmeow.betteranimals.imdlib.item.ModSpawnEggItem;
import dev.itsmeow.betteranimals.imdlib.util.HeadType;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.ForgeConfigSpec;

public class EntityTypeContainer<T extends MobEntity> {
    public EntityType<T> entityType;
    public ModSpawnEggItem egg;
    public final Class<T> entityClass;
    public final String entityName;
    public final EntityClassification spawnType;
    public final Function<World, T> factory;
    public final boolean hasEgg;
    public final int eggColorSolid;
    public final int eggColorSpot;
    public int spawnWeight;
    public int spawnMinGroup;
    public int spawnMaxGroup;
    public boolean biomeVariants = true;
    public boolean doSpawning = true;
    public final float width;
    public final float height;
    public boolean despawn;
    public final EntitySpawnPlacementRegistry.PlacementType placementType;
    public final Heightmap.Type heightMapType;
    public final EntitySpawnPlacementRegistry.IPlacementPredicate<T> placementPredicate;
    protected boolean placementRegistered = false;
    protected Biome[] spawnBiomes;
    protected EntityConfiguration config;
    protected final CustomConfigurationHolder customConfig;
    protected final CustomConfigurationHolder customClientConfig;
    protected Supplier<Set<Biome>> defaultBiomeSupplier;
    protected EntityVariantList variantList;
    protected int variantMax;
    protected DataParameter<String> variantDataKey;
    public HeadType headType;
    protected final String modid;

    protected EntityTypeContainer(IEntityTypeDefinition<T> def) {
        this.modid = def.getModId();
        this.entityClass = def.getEntityClass();
        this.factory = def.getEntityFactory();
        this.entityName = def.getEntityName();
        this.hasEgg = def.hasEgg();
        this.eggColorSolid = def.getEggSolidColor();
        this.eggColorSpot = def.getEggSpotColor();
        this.spawnWeight = def.getSpawnWeight();
        this.spawnMinGroup = def.getSpawnMinGroup();
        this.spawnMaxGroup = def.getSpawnMaxGroup();
        this.spawnType = def.getSpawnClassification();
        this.width = def.getWidth();
        this.height = def.getHeight();
        this.despawn = def.despawns();
        this.customConfig = def.getCustomConfig();
        this.customClientConfig = def.getCustomClientConfig();
        this.defaultBiomeSupplier = def.getSpawnBiomes();
        this.placementType = def.getPlacementType();
        this.heightMapType = def.getPlacementHeightMapType();
        this.placementPredicate = def.getPlacementPredicate();
        this.variantMax = def.getVariantAmount();
        if (this.hasVariants()) {
            this.variantList = new EntityVariantList(this.variantMax);
            this.variantList.add(def.getVariants());
        }
    }

    public void onCreateEntityType() {
        if (this.hasEgg) {
            this.egg = new ModSpawnEggItem(this);
        }
    }

    public void initConfiguration(ForgeConfigSpec.Builder builder) {
        this.config = new EntityConfiguration(builder);
    }

    public EntityConfiguration getConfiguration() {
        return this.config;
    }

    public void setBiomes(Biome ... biomes) {
        this.spawnBiomes = biomes;
    }

    public Biome[] getBiomes() {
        return this.spawnBiomes;
    }

    public String[] getBiomeIDs() {
        try {
            this.spawnBiomes = this.defaultBiomeSupplier.get().toArray(new Biome[0]);
        }
        catch (NullPointerException e) {
            this.spawnBiomes = new Biome[0];
        }
        String[] biomeStrings = new String[this.spawnBiomes.length];
        for (int i = 0; i < this.spawnBiomes.length; ++i) {
            biomeStrings[i] = this.spawnBiomes[i].getRegistryName().toString();
        }
        return biomeStrings;
    }

    public void configurationLoad() {
        EntityConfiguration section = this.getConfiguration();
        this.spawnMaxGroup = (Integer)section.spawnMaxGroup.get();
        this.spawnMinGroup = (Integer)section.spawnMinGroup.get();
        this.spawnWeight = (Integer)section.spawnWeight.get();
        this.doSpawning = (Boolean)section.doSpawning.get();
        this.despawn = (Boolean)section.doDespawn.get();
        if (section.biomeVariants != null) {
            this.biomeVariants = (Boolean)section.biomeVariants.get();
        }
        if (this.customConfig != null) {
            this.customConfig.customConfigurationLoad();
        }
    }

    public void clientConfigurationLoad() {
        if (this.customClientConfig != null) {
            this.customClientConfig.customConfigurationLoad();
        }
    }

    public void customConfigurationInit(ForgeConfigSpec.Builder builder) {
        if (this.customConfig != null) {
            this.customConfig.customConfigurationInit(builder);
        }
    }

    public void clientCustomConfigurationInit(ForgeConfigSpec.Builder builder) {
        if (this.customClientConfig != null) {
            builder.push(this.entityName);
            this.customClientConfig.customConfigurationInit(builder);
            builder.pop();
        }
    }

    public static <T extends MobEntity> boolean waterSpawn(EntityType<T> type, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return pos.func_177956_o() > 45 && pos.func_177956_o() < world.func_181545_F() - 1 && world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j;
    }

    public void registerPlacement() {
        if (this.placementType != null && this.placementPredicate != null && this.heightMapType != null && !this.placementRegistered) {
            EntitySpawnPlacementRegistry.func_209343_a(this.entityType, (EntitySpawnPlacementRegistry.PlacementType)this.placementType, (Heightmap.Type)this.heightMapType, this.placementPredicate);
            this.placementRegistered = true;
        }
    }

    public String getModId() {
        return this.modid;
    }

    public HeadType getHeadType() {
        return this.headType;
    }

    public boolean hasVariants() {
        return this.variantMax > 0;
    }

    public int getVariantMax() {
        return this.variantMax;
    }

    @Nullable
    @CheckForNull
    public IVariant getVariantForName(String name) {
        return this.variantList.getVariantForName(name);
    }

    @Deprecated
    public IVariant getVariantForIndex(int index) {
        return this.variantList.getVariantForIndex(index);
    }

    public ImmutableList<IVariant> getVariants() {
        return this.variantList.getVariantList();
    }

    @Deprecated
    public int getVariantIndex(IVariant variant) {
        return this.variantList.getVariantIndex(variant);
    }

    public DataParameter<String> getVariantDataKey() {
        if (this.variantDataKey == null) {
            this.variantDataKey = EntityDataManager.func_187226_a(this.entityClass, (IDataSerializer)DataSerializers.field_187194_d);
        }
        return this.variantDataKey;
    }

    public static interface CustomConfigurationHolder {
        public void customConfigurationInit(ForgeConfigSpec.Builder var1);

        public void customConfigurationLoad();
    }

    public class EntityConfiguration {
        public ForgeConfigSpec.BooleanValue doSpawning;
        public ForgeConfigSpec.BooleanValue biomeVariants;
        public ForgeConfigSpec.IntValue spawnMinGroup;
        public ForgeConfigSpec.IntValue spawnMaxGroup;
        public ForgeConfigSpec.IntValue spawnWeight;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> biomesList;
        public List<String> biomeStrings;
        public ForgeConfigSpec.BooleanValue doDespawn;

        protected EntityConfiguration(ForgeConfigSpec.Builder builder) {
            EntityTypeContainer container = EntityTypeContainer.this;
            builder.push(container.entityName);
            this.biomeStrings = Arrays.asList(container.getBiomeIDs());
            this.loadSpawning(builder);
            this.loadSpawnValues(builder, container);
            this.doDespawn = builder.comment("True if this entity can despawn freely when no players are nearby.").worldRestart().define("doDespawn", container.despawn);
            if (ISelectiveVariantTypes.class.isAssignableFrom(EntityTypeContainer.this.entityClass)) {
                this.biomeVariants = builder.comment("Setting to true enables biome based variant spawning. This will make this entity choose variants based on the biome they spawn in. (No longer affects spawn eggs as it did in the past, only natural spawns)").worldRestart().define("biomeBasedVariants", container.biomeVariants);
            }
            EntityTypeContainer.this.customConfigurationInit(builder);
            builder.pop();
        }

        public void loadSpawning(ForgeConfigSpec.Builder builder) {
            this.doSpawning = builder.comment("Disables natural spawning").worldRestart().define("doSpawning", true);
        }

        public void loadSpawnValues(ForgeConfigSpec.Builder builder, EntityTypeContainer<T> container) {
            this.spawnWeight = builder.comment("The spawn chance compared to other entities (typically between 6-20)").worldRestart().defineInRange("weight", container.spawnWeight, 1, 9999);
            this.spawnMinGroup = builder.comment("Must be greater than 0").worldRestart().defineInRange("minGroup", container.spawnMinGroup, 1, 9999);
            this.spawnMaxGroup = builder.comment("Must be greater or equal to min value!").worldRestart().defineInRange("maxGroup", container.spawnMaxGroup, 1, 9999);
            this.biomesList = builder.comment("Enter biome Resource Locations. Supports modded biomes.").worldRestart().defineList("spawnBiomes", this.biomeStrings, input -> input instanceof String);
        }
    }

    public static class Builder<T extends MobEntity>
    extends AbstractEntityBuilder<T, EntityTypeContainer<T>, Builder<T>> {
        private Builder(Class<T> EntityClass, Function<World, T> func, String entityNameIn, String modid) {
            super(EntityClass, func, entityNameIn, modid);
        }

        @Override
        public EntityTypeContainer<T> rawBuild() {
            return new EntityTypeContainer(new EntityTypeDefinition(this));
        }

        @Override
        public Builder<T> getImplementation() {
            return this;
        }

        public static <T extends MobEntity> Builder<T> create(Class<T> EntityClass, Function<World, T> func, String entityNameIn, String modid) {
            return new Builder<T>(EntityClass, func, entityNameIn, modid);
        }
    }
}

