/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimals.imdlib.entity.util;

import dev.itsmeow.betteranimals.imdlib.entity.util.IContainerEntity;
import dev.itsmeow.betteranimals.imdlib.entity.util.IVariant;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;

public interface IVariantTypes<T extends MobEntity>
extends IContainerEntity<T> {
    default public void registerTypeKey() {
        this.getImplementation().func_184212_Q().func_187214_a(this.getContainer().getVariantDataKey(), (Object)"");
    }

    default public String getVariantString() {
        return (String)this.getImplementation().func_184212_Q().func_187225_a(this.getContainer().getVariantDataKey());
    }

    default public IVariantTypes<T> setType(String variantKey) {
        if (this.getContainer().getVariantForName(variantKey) == null) {
            variantKey = this.getRandomType().getName();
        }
        this.getImplementation().func_184212_Q().func_187227_b(this.getContainer().getVariantDataKey(), (Object)variantKey);
        return this;
    }

    default public IVariantTypes<T> setType(IVariant variant) {
        this.getImplementation().func_184212_Q().func_187227_b(this.getContainer().getVariantDataKey(), (Object)variant.getName());
        return this;
    }

    default public void writeType(CompoundNBT compound) {
        compound.func_74778_a("VariantId", this.getVariantNameOrEmpty());
    }

    default public void readType(CompoundNBT compound) {
        this.setType(compound.func_74779_i("VariantId"));
    }

    default public IVariant getOffspringType(IVariantTypes<?> parent1, IVariantTypes<?> parent2) {
        if (parent1 == null || parent2 == null) {
            if (parent1 == null && parent2 != null) {
                return parent2.getVariant().orElseGet(this::getRandomType);
            }
            if (parent2 == null && parent1 != null) {
                return parent1.getVariant().orElseGet(this::getRandomType);
            }
            return this.getRandomType();
        }
        return this.getImplementation().func_70681_au().nextBoolean() ? parent1.getVariant().orElseGet(() -> parent2.getVariant().orElseGet(this::getRandomType)) : parent2.getVariant().orElseGet(() -> parent1.getVariant().orElseGet(this::getRandomType));
    }

    default public IVariant getRandomType() {
        return (IVariant)this.getContainer().getVariants().get(this.getImplementation().func_70681_au().nextInt(this.getContainer().getVariantMax()));
    }

    @Nullable
    default public ILivingEntityData initData(IWorld world, SpawnReason reason, ILivingEntityData livingdata) {
        IVariant variant = this.getRandomType();
        if (livingdata instanceof TypeData) {
            variant = ((TypeData)livingdata).typeData;
        } else {
            livingdata = new TypeData(variant);
        }
        this.setType(variant);
        return livingdata;
    }

    default public Optional<IVariant> getVariant() {
        return Optional.ofNullable(this.getContainer().getVariantForName(this.getVariantString()));
    }

    @Nullable
    default public ResourceLocation getVariantTextureOrNull() {
        Optional<IVariant> variant = this.getVariant();
        return variant.isPresent() ? variant.get().getTexture((Entity)this.getImplementation()) : null;
    }

    default public String getVariantNameOrEmpty() {
        Optional<IVariant> variant = this.getVariant();
        return variant.isPresent() ? variant.get().getName() : "";
    }

    public static class TypeData
    implements ILivingEntityData {
        public IVariant typeData;

        public TypeData(IVariant type) {
            this.typeData = type;
        }
    }
}

