/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimals.client.render.entity.compat;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mushroom.midnight.client.ClientEventHandler;
import com.mushroom.midnight.client.render.entity.EmissiveLayerRenderer;
import com.mushroom.midnight.common.entity.creature.NightStagEntity;
import dev.itsmeow.betteranimals.client.model.compat.ModelNewNightstag;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class RenderNewNightstag
extends MobRenderer<NightStagEntity, ModelNewNightstag> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("betteranimals", "textures/entity/midnight/nightstag.png");
    private static final ResourceLocation EMISSIVE_TEXTURE = new ResourceLocation("betteranimals", "textures/entity/midnight/nightstag_glow.png");
    private static final int FLICK_BRIGHT_LOW = 50;
    private static final int FLICK_BRIGHT_UP = 200;
    private static final int PULSE_BRIGHT_LOW = 200;
    private static final int PULSE_BRIGHT_UP = 240;

    public RenderNewNightstag(EntityRendererManager manager) {
        super(manager, (EntityModel)new ModelNewNightstag(), 0.0f);
        this.func_177094_a((LayerRenderer)new EmissiveLayerRenderer((IEntityRenderer)this, EMISSIVE_TEXTURE, RenderNewNightstag::computeBrightness, RenderNewNightstag::computeColor));
    }

    private static int computeColor(NightStagEntity entity, float partialTicks) {
        switch (entity.getAntlerType()) {
            case 1: {
                return 0xFF6666;
            }
            case 2: {
                return 0xBBFF99;
            }
            case 3: {
                return 0x99FFFF;
            }
            case 4: {
                return 16755328;
            }
            case 5: {
                return 14916828;
            }
            case 6: {
                return 14122192;
            }
            case 7: {
                return 0xF2F2F2;
            }
            case 8: {
                return 0x6699FF;
            }
        }
        return 8409526;
    }

    private static int computeBrightness(NightStagEntity entity, float partialTicks) {
        double totalTicks = (float)entity.field_70173_aa + partialTicks;
        float flicker = RenderNewNightstag.computeFlicker(totalTicks, partialTicks);
        float pulse = (float)((Math.sin(totalTicks * 0.125) + 1.0) * 0.5);
        float health = entity.func_110143_aJ() / entity.func_110138_aP();
        float flickerBrightness = 50.0f + 150.0f * flicker;
        float healthyBrightness = 200.0f + 40.0f * pulse;
        return MathHelper.func_76141_d((float)(flickerBrightness * (1.0f - health) + healthyBrightness * health));
    }

    private static float computeFlicker(double totalTicks, float partialTicks) {
        float lerpedFlicker = ClientEventHandler.prevFlicker + (ClientEventHandler.flicker - ClientEventHandler.prevFlicker) * partialTicks;
        float pulse = (float)(Math.sin(totalTicks * 0.2) + 1.0) * 0.4f;
        return MathHelper.func_76131_a((float)(lerpedFlicker + pulse), (float)0.0f, (float)1.0f);
    }

    @Nullable
    public ResourceLocation getEntityTexture(NightStagEntity entity) {
        return TEXTURE;
    }

    protected void preRenderCallback(NightStagEntity entity, MatrixStack stack, float partialTicks) {
        if (entity.func_70631_g_()) {
            stack.func_227862_a_(0.5f, 0.5f, 0.5f);
        }
    }
}

