/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimals.imdlib.entity.util;

import dev.itsmeow.betteranimals.imdlib.entity.util.IContainerEntity;
import dev.itsmeow.betteranimals.imdlib.entity.util.IVariant;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;

public interface IVariantTypes<T extends MobEntity>
extends IContainerEntity<T> {
    default public void registerTypeKey() {
        this.getImplementation().func_184212_Q().func_187214_a(this.getContainer().getVariantDataKey(), (Object)"");
    }

    default public String getVariantString() {
        return (String)this.getImplementation().func_184212_Q().func_187225_a(this.getContainer().getVariantDataKey());
    }

    default public IVariantTypes<T> setType(String variantKey) {
        if (this.getContainer().getVariantForName(variantKey) == null) {
            variantKey = this.getRandomType().getName();
        }
        this.getImplementation().func_184212_Q().func_187227_b(this.getContainer().getVariantDataKey(), (Object)variantKey);
        return this;
    }

    default public IVariantTypes<T> setType(IVariant variant) {
        this.getImplementation().func_184212_Q().func_187227_b(this.getContainer().getVariantDataKey(), (Object)variant.getName());
        return this;
    }

    default public void writeType(CompoundNBT compound) {
        compound.func_74778_a("VariantId", this.getVariantNameOrEmpty());
    }

    default public void readType(CompoundNBT compound) {
        this.setType(compound.func_74779_i("VariantId"));
    }

    default public IVariant getOffspringType(IVariantTypes<?> parent1, IVariantTypes<?> parent2) {
        if (parent1 == null || parent2 == null) {
            if (parent1 == null && parent2 != null) {
                return parent2.getVariant().orElseGet(this::getRandomType);
            }
            if (parent2 == null && parent1 != null) {
                return parent1.getVariant().orElseGet(this::getRandomType);
            }
            return this.getRandomType();
        }
        return this.getImplementation().func_70681_au().nextBoolean() ? parent1.getVariant().orElseGet(() -> parent2.getVariant().orElseGet(this::getRandomType)) : parent2.getVariant().orElseGet(() -> parent1.getVariant().orElseGet(this::getRandomType));
    }

    default public IVariant getRandomType() {
        return (IVariant)this.getContainer().getVariants().get(this.getImplementation().func_70681_au().nextInt(this.getContainer().getVariantMax()));
    }

    @Nullable
    default public ILivingEntityData initData(IWorld world, SpawnReason reason, ILivingEntityData livingdata) {
        IVariant variant = this.getRandomType();
        if (livingdata instanceof TypeData) {
            variant = ((TypeData)livingdata).typeData;
        } else {
            livingdata = new TypeData(variant);
        }
        this.setType(variant);
        return livingdata;
    }

    @Nullable
    default public ILivingEntityData initAgeableData(IWorld world, SpawnReason reason, ILivingEntityData livingdata) {
        IVariant variant = this.getRandomType();
        if (livingdata instanceof AgeableTypeData) {
            variant = ((AgeableTypeData)((Object)livingdata)).typeData;
        } else {
            livingdata = livingdata instanceof AgeableEntity.AgeableData ? new AgeableTypeData((AgeableEntity.AgeableData)livingdata, variant) : new AgeableTypeData(variant);
        }
        this.setType(variant);
        return livingdata;
    }

    default public Optional<IVariant> getVariant() {
        return Optional.ofNullable(this.getContainer().getVariantForName(this.getVariantString()));
    }

    @Nullable
    default public ResourceLocation getVariantTextureOrNull() {
        Optional<IVariant> variant = this.getVariant();
        return variant.isPresent() ? variant.get().getTexture((Entity)this.getImplementation()) : null;
    }

    default public String getVariantNameOrEmpty() {
        Optional<IVariant> variant = this.getVariant();
        return variant.isPresent() ? variant.get().getName() : "";
    }

    public static class AgeableTypeData
    extends AgeableEntity.AgeableData {
        public IVariant typeData;
        private int numInGroup;
        private boolean canSpawnBaby = true;
        private float probabilityOfBaby = 0.05f;

        public AgeableTypeData(IVariant type) {
            this.typeData = type;
        }

        public AgeableTypeData(AgeableEntity.AgeableData data, IVariant type) {
            this.typeData = type;
            this.numInGroup = data.func_226257_a_();
            this.canSpawnBaby = data.func_226261_c_();
            this.probabilityOfBaby = data.func_226262_d_();
        }

        public boolean func_226261_c_() {
            return this.canSpawnBaby;
        }

        public float func_226262_d_() {
            return this.probabilityOfBaby;
        }

        public int func_226257_a_() {
            return this.numInGroup;
        }

        public void func_226260_b_() {
            ++this.numInGroup;
        }

        public void func_226258_a_(float probability) {
            this.probabilityOfBaby = probability;
        }

        public void func_226259_a_(boolean canSpawn) {
            this.canSpawnBaby = canSpawn;
        }
    }

    public static class TypeData
    implements ILivingEntityData {
        public IVariant typeData;

        public TypeData(IVariant type) {
            this.typeData = type;
        }
    }
}

