/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimals.imdlib.item;

import dev.itsmeow.betteranimals.imdlib.block.BlockAnimalSkull;
import dev.itsmeow.betteranimals.imdlib.entity.util.IVariant;
import dev.itsmeow.betteranimals.imdlib.util.HeadType;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ItemBlockSkull
extends WallOrFloorItem {
    public final HeadType.PlacementType placement;
    public final String id;
    public final IVariant variant;

    public ItemBlockSkull(Block block, HeadType.PlacementType placement, String id, IVariant variant, ItemGroup group) {
        super(block, block, new Item.Properties().func_200916_a(group));
        if (block.getRegistryName() != null) {
            this.setRegistryName(block.getRegistryName());
        }
        this.placement = placement;
        this.id = id;
        this.variant = variant;
    }

    public ItemBlockSkull(Block block, HeadType.PlacementType placement, String id, IVariant variant, Item.Properties prop) {
        super(block, block, prop);
        if (block.getRegistryName() != null) {
            this.setRegistryName(block.getRegistryName());
        }
        this.placement = placement;
        this.id = id;
        this.variant = variant;
    }

    @Nullable
    protected BlockState func_195945_b(BlockItemUseContext ctx) {
        BlockState returnedState = null;
        World world = ctx.func_195991_k();
        BlockPos clickPos = ctx.func_195995_a();
        for (Direction side : ctx.func_196009_e()) {
            if (side == Direction.DOWN && this.placement != HeadType.PlacementType.FLOOR_AND_WALL) {
                return null;
            }
            BlockState newState = this.func_179223_d().func_196258_a(ctx);
            if (newState == null || !newState.func_196955_c((IWorldReader)world, clickPos) || newState.func_177229_b((IProperty)BlockAnimalSkull.FACING_EXCEPT_DOWN) == Direction.UP && this.placement != HeadType.PlacementType.FLOOR_AND_WALL) continue;
            returnedState = newState;
            break;
        }
        return returnedState;
    }

    public ActionResultType func_195942_a(BlockItemUseContext ctx) {
        if (!ctx.func_196011_b()) {
            return ActionResultType.FAIL;
        }
        if (ctx.func_196000_l() == Direction.DOWN) {
            return ActionResultType.FAIL;
        }
        BlockState placementState = this.func_195945_b(ctx);
        if (placementState == null) {
            return ActionResultType.FAIL;
        }
        if (!this.func_195941_b(ctx, placementState)) {
            return ActionResultType.FAIL;
        }
        if (ctx.func_196000_l() == Direction.UP && this.placement != HeadType.PlacementType.FLOOR_AND_WALL) {
            return ActionResultType.FAIL;
        }
        BlockPos blockpos = ctx.func_195995_a();
        World world = ctx.func_195991_k();
        PlayerEntity player = ctx.func_195999_j();
        ItemStack stack = ctx.func_195996_i();
        BlockState newState = world.func_180495_p(blockpos);
        Block block = newState.func_177230_c();
        if (block == placementState.func_177230_c()) {
            this.func_195943_a(blockpos, world, player, stack, newState);
            block.func_180633_a(world, blockpos, newState, (LivingEntity)player, stack);
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, blockpos, stack);
            }
        }
        SoundType soundtype = newState.getSoundType((IWorldReader)world, blockpos, (Entity)ctx.func_195999_j());
        world.func_184133_a(player, blockpos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        stack.func_190918_g(1);
        return ActionResultType.SUCCESS;
    }
}

