/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimals.imdlib.item;

import dev.itsmeow.betteranimals.imdlib.entity.EntityRegistrarHandler;
import dev.itsmeow.betteranimals.imdlib.entity.util.EntityTypeContainer;
import net.minecraft.block.DispenserBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ItemModelProvider;

public class ModSpawnEggItem
extends SpawnEggItem {
    private final EntityType<?> type;
    private final String modid;
    private final String name;
    protected static final DefaultDispenseItemBehavior EGG_DISPENSE_ACTION = new DefaultDispenseItemBehavior(){

        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            Direction direction = (Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
            EntityType entitytype = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
            entitytype.func_220331_a(source.func_197524_h(), stack, (PlayerEntity)null, source.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
            stack.func_190918_g(1);
            return stack;
        }
    };

    public ModSpawnEggItem(EntityTypeContainer<?> container) {
        super(container.entityType, container.eggColorSolid, container.eggColorSpot, new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
        this.type = container.entityType;
        this.modid = container.getModId();
        this.name = container.entityName.toLowerCase();
        this.setRegistryName(container.getModId(), this.name + "_spawn_egg");
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)EGG_DISPENSE_ACTION);
    }

    public String func_77667_c(ItemStack stack) {
        if (this.type != null) {
            return "entity." + this.modid + "." + this.type.getRegistryName().func_110623_a();
        }
        return "item." + this.modid + ".emptyegg";
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new TranslationTextComponent("misc." + this.modid + ".eggorder", new Object[]{new TranslationTextComponent(this.func_77667_c(stack), new Object[0])});
    }

    public EntityType<?> func_208076_b(CompoundNBT tag) {
        return this.type;
    }

    public boolean func_208077_a(CompoundNBT tag, EntityType<?> type) {
        return type == this.type;
    }

    public static class DataProvider
    extends ItemModelProvider {
        private EntityRegistrarHandler handler;

        public DataProvider(EntityRegistrarHandler r, DataGenerator generator, ExistingFileHelper existingFileHelper) {
            super(generator, r.modid, existingFileHelper);
            this.handler = r;
        }

        public String func_200397_b() {
            return this.modid + "_spawn_eggs";
        }

        protected void registerModels() {
            for (String name : this.handler.ENTITIES.keySet()) {
                this.withExistingParent(name + "_spawn_egg", new ResourceLocation("minecraft", "item/template_spawn_egg"));
            }
        }
    }
}

