/*
 * Decompiled with CFR 0.152.
 */
package dev.bodner.jack.betterslabs.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.swordglowsblue.artifice.api.Artifice;
import com.swordglowsblue.artifice.api.ArtificeResourcePack;
import com.swordglowsblue.artifice.api.resource.ArtificeResource;
import com.swordglowsblue.artifice.api.resource.StringResource;
import dev.bodner.jack.betterslabs.Betterslabs;
import dev.bodner.jack.betterslabs.component.Components;
import dev.bodner.jack.betterslabs.component.PlaceModeComponentImpl;
import dev.bodner.jack.betterslabs.json.BlockstateMap;
import dev.bodner.jack.betterslabs.json.ModelMap;
import io.netty.buffer.Unpooled;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3675;

public class BetterslabsClient
implements ClientModInitializer {
    public static List<class_2960> slabList = new ArrayList<class_2960>();

    public static void createPack() {
        ArtificeResourcePack overwrite = Artifice.registerAssets((String)"betterslabs:overwrite", pack -> {
            pack.setDisplayName("Betterslabs Overwriter");
            pack.setDescription("overwrites all slab blockstates and supplies models");
            pack.shouldOverwrite();
            for (int i = 0; i <= slabList.size() - 1; ++i) {
                Gson gson = new Gson();
                JsonParser jsonParser = new JsonParser();
                class_2960 sideSlabParent = new class_2960("betterslabs", "block/side_slab");
                class_2960 sideSlabDoubleParent = new class_2960("minecraft", "block/cube_column_horizontal");
                InputStream stream = BetterslabsClient.class.getClassLoader().getResourceAsStream("assets/" + slabList.get(i).method_12836() + "/blockstates/" + slabList.get(i).method_12832() + ".json");
                JsonObject blockstateObject = (JsonObject)jsonParser.parse((Reader)new InputStreamReader(stream));
                BlockstateMap mappedBlockstate = (BlockstateMap)gson.fromJson((JsonElement)blockstateObject, BlockstateMap.class);
                ArrayList<String> topSlabList = new ArrayList<String>(mappedBlockstate.getTop());
                ArrayList<String> bottomSlabList = new ArrayList<String>(mappedBlockstate.getBottom());
                ArrayList<String> doubleSlabList = new ArrayList<String>(mappedBlockstate.getDouble());
                ArrayList<String> sideSlabList = new ArrayList<String>();
                ArrayList<String> sideSlabDoubleList = new ArrayList<String>();
                for (int j = 0; j <= mappedBlockstate.getTop().size() - 1; ++j) {
                    String[] modelArray = mappedBlockstate.getTop().get(j).split(":").length == 1 ? new String[]{"minecraft", mappedBlockstate.getTop().get(j)} : mappedBlockstate.getTop().get(j).split(":");
                    InputStream stream1 = BetterslabsClient.class.getClassLoader().getResourceAsStream("assets/" + modelArray[0] + "/models/" + modelArray[1] + ".json");
                    JsonObject modelObject = (JsonObject)jsonParser.parse((Reader)new InputStreamReader(stream1));
                    ModelMap modelMap = (ModelMap)gson.fromJson((JsonElement)modelObject, ModelMap.class);
                    String[] textureArrayTop = modelMap.getTexture("top").split(":").length == 1 ? new String[]{"minecraft", modelMap.getTexture("top")} : modelMap.getTexture("top").split(":");
                    String[] textureArrayBottom = modelMap.getTexture("bottom").split(":").length == 1 ? new String[]{"minecraft", modelMap.getTexture("bottom")} : modelMap.getTexture("bottom").split(":");
                    String[] textureArraySide = modelMap.getTexture("side").split(":").length == 1 ? new String[]{"minecraft", modelMap.getTexture("side")} : modelMap.getTexture("side").split(":");
                    class_2960 sideLocation = new class_2960(slabList.get(i).method_12836(), slabList.get(i).method_12832() + "_side_" + j);
                    class_2960 doubleSideLocation = new class_2960(slabList.get(i).method_12836(), slabList.get(i).method_12832() + "_double_horizontal_" + j);
                    sideSlabList.add(sideLocation.method_12836() + ":block/" + sideLocation.method_12832());
                    sideSlabDoubleList.add(doubleSideLocation.method_12836() + ":block/" + doubleSideLocation.method_12832());
                    pack.addBlockModel(sideLocation, modelBuilder -> modelBuilder.parent(sideSlabParent).texture("top", new class_2960(textureArrayTop[0], textureArrayTop[1])).texture("bottom", new class_2960(textureArrayBottom[0], textureArrayBottom[1])).texture("side", new class_2960(textureArraySide[0], textureArraySide[1])));
                    pack.addBlockModel(doubleSideLocation, modelBuilder -> modelBuilder.parent(sideSlabDoubleParent).texture("end", new class_2960(textureArrayTop[0], textureArrayTop[1])).texture("side", new class_2960(textureArraySide[0], textureArraySide[1])));
                }
                class_2960 blockstateLocation = new class_2960(slabList.get(i).method_12836(), "blockstates/" + slabList.get(i).method_12832() + ".json");
                pack.add(blockstateLocation, (ArtificeResource)new StringResource(new String[]{"{\n  \"variants\": {\n    \"axis=x,type=bottom\": [" + BetterslabsClient.createModel(sideSlabList, 0, 270, 0) + "],\n    \"axis=x,type=top\": [" + BetterslabsClient.createModel(sideSlabList, 0, 90, 0) + "],\n    \"axis=x,type=double\": [" + BetterslabsClient.createModel(sideSlabDoubleList, 90, 90, 0) + "],\n    \"axis=y,type=bottom\": [" + BetterslabsClient.createModel(bottomSlabList, 0, 0, 0) + "],\n    \"axis=y,type=top\": [" + BetterslabsClient.createModel(topSlabList, 0, 0, 0) + "],\n    \"axis=y,type=double\": [" + BetterslabsClient.createModel(doubleSlabList, 0, 0, 0) + "],\n    \"axis=z,type=bottom\": [" + BetterslabsClient.createModel(sideSlabList, 0, 0, 0) + "],\n    \"axis=z,type=top\": [" + BetterslabsClient.createModel(sideSlabList, 0, 180, 0) + "],\n    \"axis=z,type=double\": [" + BetterslabsClient.createModel(sideSlabDoubleList, 90, 0, 0) + "]\n  }\n}"}));
            }
        });
    }

    private static String createModel(List<String> models, int xRotation, int yRotation, int zRotation) {
        String result = "";
        for (int k = 0; k <= models.size() - 1; ++k) {
            result = result + "{\"model\": \"" + models.get(k) + "\",\"x\": " + xRotation + ",\"y\": " + yRotation + ",\"z\": " + zRotation + "}";
            if (k >= models.size() - 1) continue;
            result = result + ",";
        }
        return result;
    }

    public void onInitializeClient() {
        class_304 placemodeKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.betterslabs.placemode", class_3675.class_307.field_1668, 86, "key.categories.misc"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (placemodeKey.method_1436()) {
                class_2540 passedData = new class_2540(Unpooled.buffer());
                passedData.writeBoolean(true);
                ClientSidePacketRegistry.INSTANCE.sendToServer(Betterslabs.PLACE_MODE_PACKET_ID, passedData);
                switch (((PlaceModeComponentImpl)Components.MODE_KEY.get((Object)client.field_1724)).getPlaceMode().next()) {
                    case VERTICAL: {
                        client.field_1724.method_7353(class_2561.method_30163((String)"Slab placement mode set to: vertical only"), true);
                        break;
                    }
                    case HORIZONTAL: {
                        client.field_1724.method_7353(class_2561.method_30163((String)"Slab placement mode set to: horizontal only"), true);
                        break;
                    }
                    default: {
                        client.field_1724.method_7353(class_2561.method_30163((String)"Slab placement mode set to: all"), true);
                    }
                }
            }
        });
    }
}

