/*
 * Decompiled with CFR 0.152.
 */
package dev.bodner.jack.betterslabs.enums;

public enum SlabPlaceMode {
    ALL,
    HORIZONTAL,
    VERTICAL;

    private static final SlabPlaceMode[] SLAB_PLACE_MODES;

    public SlabPlaceMode next() {
        return SLAB_PLACE_MODES[(this.ordinal() + 1) % SLAB_PLACE_MODES.length];
    }

    public static String toString(SlabPlaceMode mode) {
        switch (mode) {
            case HORIZONTAL: {
                return "horizontal";
            }
            case VERTICAL: {
                return "vertical";
            }
        }
        return "all";
    }

    public static SlabPlaceMode fromString(String string) throws Exception {
        switch (string) {
            case "all": {
                return ALL;
            }
            case "horizontal": {
                return HORIZONTAL;
            }
            case "vertical": {
                return VERTICAL;
            }
        }
        throw new Exception("Expected: all|horizontal|vertical, got: " + string);
    }

    static {
        SLAB_PLACE_MODES = SlabPlaceMode.values();
    }
}

