/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.registry;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import org.apache.logging.log4j.Logger;

public class TradeRegistry {
    private final Logger logger;
    private final Map<VillagerProfession, Int2ObjectMap<List<VillagerTrades.ITrade>>> trades;
    private final List<VillagerTrades.ITrade> basicTrades;
    private final List<VillagerTrades.ITrade> rareTrades;

    public TradeRegistry(Logger logger) {
        this.logger = logger;
        this.trades = new HashMap<VillagerProfession, Int2ObjectMap<List<VillagerTrades.ITrade>>>();
        this.basicTrades = NonNullList.func_191196_a();
        this.rareTrades = NonNullList.func_191196_a();
    }

    public void initialize(IEventBus modBus) {
        if (!this.trades.isEmpty()) {
            MinecraftForge.EVENT_BUS.addListener(this::registerVillagerTrades);
        }
        if (!this.basicTrades.isEmpty() || !this.rareTrades.isEmpty()) {
            MinecraftForge.EVENT_BUS.addListener(this::registerWanderingTrades);
        }
    }

    public VillagerTrades.ITrade registerVillagerTrade(VillagerProfession profession, int level, VillagerTrades.ITrade trade) {
        Int2ObjectMap<List<VillagerTrades.ITrade>> tradesByLevel = this.trades.getOrDefault(profession, (Int2ObjectMap<List<VillagerTrades.ITrade>>)new Int2ObjectOpenHashMap());
        List tradesForLevel = (List)tradesByLevel.getOrDefault(level, new ArrayList());
        tradesForLevel.add(trade);
        tradesByLevel.put(level, (Object)tradesForLevel);
        this.trades.put(profession, tradesByLevel);
        return trade;
    }

    private void registerVillagerTrades(VillagerTradesEvent event) {
        Int2ObjectMap<List<VillagerTrades.ITrade>> tradesByLevel;
        if (event.getType() != null && (tradesByLevel = this.trades.get(event.getType())) != null && !tradesByLevel.isEmpty()) {
            IntIterator intIterator = tradesByLevel.keySet().iterator();
            while (intIterator.hasNext()) {
                int level = (Integer)intIterator.next();
                List tradeRegistry = (List)event.getTrades().get(level);
                if (tradeRegistry != null) {
                    tradeRegistry.addAll((Collection)tradesByLevel.get(level));
                    continue;
                }
                throw new IllegalArgumentException("Tried to register a trade to a profession level that does not exist!");
            }
        }
    }

    public VillagerTrades.ITrade addBasicWanderingTrade(VillagerTrades.ITrade trade) {
        this.basicTrades.add(trade);
        return trade;
    }

    public VillagerTrades.ITrade addRareWanderingTrade(VillagerTrades.ITrade trade) {
        this.rareTrades.add(trade);
        return trade;
    }

    private void registerWanderingTrades(WandererTradesEvent event) {
        event.getGenericTrades().addAll(this.basicTrades);
        event.getRareTrades().addAll(this.rareTrades);
    }
}

