/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.UUID;
import net.darkhax.bookshelf.serialization.ISerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;

public final class SerializerUUID
implements ISerializer<UUID> {
    public static final ISerializer<UUID> SERIALIZER = new SerializerUUID();

    private SerializerUUID() {
    }

    @Override
    public UUID read(JsonElement json) {
        return UUID.fromString(json.getAsString());
    }

    @Override
    public JsonElement write(UUID toWrite) {
        return new JsonPrimitive(toWrite.toString());
    }

    @Override
    public UUID read(PacketBuffer buffer) {
        return UUID.fromString(buffer.func_218666_n());
    }

    @Override
    public void write(PacketBuffer buffer, UUID toWrite) {
        buffer.func_180714_a(toWrite.toString());
    }

    @Override
    public INBT writeNBT(UUID toWrite) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_186854_a("id", toWrite);
        return tag;
    }

    @Override
    public UUID read(INBT nbt) {
        if (nbt instanceof CompoundNBT) {
            return ((CompoundNBT)nbt).func_186857_a("id");
        }
        throw new IllegalArgumentException("Expected NBT to be a compund tag. Class was " + nbt.getClass() + " with ID " + nbt.func_74732_a() + " instead.");
    }
}

