/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.data.bytebuf;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.data.bytebuf.BookshelfByteBufs;
import net.darkhax.bookshelf.mixin.accessors.util.random.AccessorWeightedRandomList;
import net.minecraft.class_2540;
import net.minecraft.class_6005;
import net.minecraft.class_6008;

public class ByteBufHelper<T> {
    private final Function<class_2540, T> fromBytes;
    private final BiConsumer<class_2540, T> toBytes;
    private final IntFunction<T[]> arrayBuilder;

    public ByteBufHelper(Function<class_2540, T> reader, BiConsumer<class_2540, T> writer, T ... vargs) {
        this.fromBytes = reader;
        this.toBytes = writer;
        this.arrayBuilder = size -> (Object[])Array.newInstance(vargs.getClass().getComponentType(), size);
    }

    public T read(class_2540 buffer) {
        return this.fromBytes.apply(buffer);
    }

    public void write(class_2540 buffer, T toWrite) {
        this.toBytes.accept(buffer, (class_2540)toWrite);
    }

    public T[] readArray(class_2540 buffer) {
        int size = buffer.readInt();
        T[] array = this.arrayBuilder.apply(size);
        for (int i = 0; i < size; ++i) {
            array[i] = this.read(buffer);
        }
        return array;
    }

    public void writeArray(class_2540 buffer, T[] array) {
        buffer.method_53002(array.length);
        for (T value : array) {
            this.write(buffer, value);
        }
    }

    public <C extends Collection<T>> C readCollection(class_2540 buffer, Supplier<C> collectionSupplier) {
        int size = buffer.readInt();
        Collection elements = (Collection)collectionSupplier.get();
        for (int i = 0; i < size; ++i) {
            elements.add(this.read(buffer));
        }
        return (C)elements;
    }

    public void writeCollection(class_2540 buffer, Collection<T> collection) {
        buffer.method_53002(collection.size());
        collection.forEach(entry -> this.write(buffer, entry));
    }

    public List<T> readList(class_2540 buffer) {
        return this.readCollection(buffer, ArrayList::new);
    }

    public void writeList(class_2540 buffer, List<T> toWrite) {
        this.writeCollection(buffer, toWrite);
    }

    public Set<T> readSet(class_2540 buffer) {
        return this.readCollection(buffer, LinkedHashSet::new);
    }

    public void writeSet(class_2540 buffer, Set<T> toWrite) {
        this.writeCollection(buffer, toWrite);
    }

    public Optional<T> readOptional(class_2540 buffer) {
        return buffer.readBoolean() ? Optional.of(this.read(buffer)) : Optional.empty();
    }

    public void writeOptional(class_2540 buffer, Optional<T> optional) {
        boolean isPresent = optional.isPresent();
        buffer.method_52964(isPresent);
        if (isPresent) {
            this.write(buffer, optional.get());
        }
    }

    @Nullable
    public T readNullable(class_2540 buffer) {
        return buffer.readBoolean() ? (T)this.read(buffer) : null;
    }

    public void writeNullable(class_2540 buffer, @Nullable T value) {
        buffer.method_52964(value != null);
        if (value != null) {
            this.write(buffer, value);
        }
    }

    public class_6008.class_6010<T> readWeighted(class_2540 buffer) {
        T value = this.read(buffer);
        int weight = BookshelfByteBufs.INT.read(buffer);
        return class_6008.method_34980(value, (int)weight);
    }

    public void writeWeighted(class_2540 buffer, class_6008.class_6010<T> toWrite) {
        this.write(buffer, toWrite.method_34983());
        BookshelfByteBufs.INT.write(buffer, toWrite.method_34979().method_34976());
    }

    public class_6005<T> readWeightedList(class_2540 buffer) {
        class_6005.class_6006 list = class_6005.method_34971();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            class_6008.class_6010<T> wrapped = this.readWeighted(buffer);
            list.method_34975(wrapped.method_34983(), wrapped.method_34979().method_34976());
        }
        return list.method_34974();
    }

    public void writeWeightedList(class_2540 buffer, class_6005<T> list) {
        AccessorWeightedRandomList accessor = (AccessorWeightedRandomList)list;
        buffer.method_53002(accessor.bookshelf$getEntries().size());
        for (class_6008.class_6010 entry : accessor.bookshelf$getEntries()) {
            this.writeWeighted(buffer, entry);
        }
    }
}

