/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.util;

import com.google.common.math.DoubleMath;
import java.util.Arrays;
import java.util.Objects;
import net.darkhax.bookshelf.api.util.AttributeHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3532;

public final class ItemStackHelper {
    public static double getAttackDamage(class_1799 stack) {
        return ItemStackHelper.getAttackDamage(stack, class_1310.field_6290);
    }

    public static double getAttackDamage(class_1799 stack, class_1297 target) {
        class_1310 class_13102;
        if (target instanceof class_1309) {
            class_1309 living = (class_1309)target;
            class_13102 = living.method_6046();
        } else {
            class_13102 = class_1310.field_6290;
        }
        return ItemStackHelper.getAttackDamage(stack, class_13102);
    }

    public static double getAttackDamage(class_1799 stack, class_1310 targetType) {
        double damage = AttributeHelper.getAttackDamage(stack);
        double bonusEnchantmentDamage = class_1890.method_8218((class_1799)stack, (class_1310)targetType);
        return damage + bonusEnchantmentDamage;
    }

    public static class_1799[] getTabItems(class_1761 tab) {
        return (class_1799[])tab.method_47313().toArray(class_1799[]::new);
    }

    public static boolean areStacksEquivalent(class_1799 first, class_1799 second) {
        return ItemStackHelper.areStacksEquivalent(first, second, false);
    }

    public static boolean areStacksContentsEquivalent(class_1799 first, class_1799 second) {
        return ItemStackHelper.areStacksEquivalent(first, second, true);
    }

    public static boolean areStacksEquivalent(class_1799 first, class_1799 second, boolean ignoreTags) {
        return first == null && second == null || first.method_7960() == second.method_7960() || first.method_7947() == second.method_7947() && first.method_7909() == second.method_7909() && (ignoreTags || ItemStackHelper.areTagsEquivalent((class_2520)first.method_7969(), (class_2520)second.method_7969()));
    }

    public static boolean areTagsEquivalent(class_2520 a, class_2520 b) {
        if (!Objects.equals(a, b)) {
            if (a instanceof class_2514) {
                class_2514 numericA = (class_2514)a;
                if (b instanceof class_2514) {
                    class_2514 numericB = (class_2514)b;
                    return ItemStackHelper.areNumericTagsEquivalent(numericA, numericB);
                }
            }
            if (a instanceof class_2483) {
                class_2483 collectionA = (class_2483)a;
                if (b instanceof class_2483) {
                    class_2483 collectionB = (class_2483)b;
                    return ItemStackHelper.areCollectionTagsEquivalent(collectionA, collectionB);
                }
            }
            if (a instanceof class_2487) {
                class_2487 compoundA = (class_2487)a;
                if (b instanceof class_2487) {
                    class_2487 compoundB = (class_2487)b;
                    return ItemStackHelper.areCompoundTagsEquivalent(compoundA, compoundB);
                }
            }
        }
        return true;
    }

    public static boolean areCompoundTagsEquivalent(class_2487 a, class_2487 b) {
        if (a.method_10546() != b.method_10546()) {
            return false;
        }
        for (String key : a.method_10541()) {
            if (ItemStackHelper.areTagsEquivalent((class_2520)a.method_10562(key), (class_2520)b.method_10562(key))) continue;
            return false;
        }
        return true;
    }

    public static boolean areCollectionTagsEquivalent(class_2483<?> a, class_2483<?> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int index = 0; index < a.size(); ++index) {
            if (ItemStackHelper.areTagsEquivalent((class_2520)a.get(index), (class_2520)b.get(index))) continue;
            return false;
        }
        return true;
    }

    public static boolean areNumericTagsEquivalent(class_2514 a, class_2514 b) {
        boolean decimalB;
        boolean decimalA = ItemStackHelper.isDecimal(a);
        if (decimalA == (decimalB = ItemStackHelper.isDecimal(b))) {
            if (decimalA) {
                return class_3532.method_20390((double)a.method_10697(), (double)b.method_10697());
            }
            return a.method_10699() == b.method_10699();
        }
        if (decimalA) {
            return DoubleMath.isMathematicalInteger((double)a.method_10697()) && (int)a.method_10697() == b.method_10701();
        }
        return DoubleMath.isMathematicalInteger((double)b.method_10697()) && (int)b.method_10697() == a.method_10701();
    }

    public static boolean isDecimal(class_2514 tag) {
        return tag instanceof class_2494 || tag instanceof class_2489;
    }

    public static void setLore(class_1799 stack, class_2561 ... lines) {
        class_2487 displayTag = stack.method_7911("display");
        class_2499 loreList = new class_2499();
        Arrays.stream(lines).forEach(line -> loreList.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)line))));
        displayTag.method_10566("Lore", (class_2520)loreList);
    }

    public static void appendLore(class_1799 stack, class_2561 ... lines) {
        class_2487 displayTag = stack.method_7911("display");
        class_2499 loreList = displayTag.method_10545("Lore") ? displayTag.method_10554("Lore", 8) : new class_2499();
        Arrays.stream(lines).forEach(line -> loreList.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)line))));
        displayTag.method_10566("Lore", (class_2520)loreList);
    }
}

