/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_5819;

public final class MathsHelper {
    public static final DecimalFormat DECIMAL_2 = new DecimalFormat("##.##");

    public static boolean isInRange(double min, double max, double value) {
        return value <= max && value >= min;
    }

    public static double getDistanceBetweenPoints(class_243 firstPos, class_243 secondPos) {
        double distanceX = firstPos.field_1352 - secondPos.field_1352;
        double distanceY = firstPos.field_1351 - secondPos.field_1351;
        double distanceZ = firstPos.field_1350 - secondPos.field_1350;
        return Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
    }

    public static double round(double value, int places) {
        return value >= 0.0 && places > 0 ? BigDecimal.valueOf(value).setScale(places, RoundingMode.HALF_UP).doubleValue() : value;
    }

    public static int nextIntInclusive(Random rand, int min, int max) {
        return rand.nextInt(max - min + 1) + min;
    }

    public static boolean tryPercentage(double percent) {
        return Math.random() < percent;
    }

    public static int getAverage(int first, int second) {
        return Math.round((float)(first + second) / 2.0f);
    }

    public static int getPercentage(int value, int total) {
        return (int)((float)value / (float)total * 100.0f);
    }

    public static double getPixelDistance(int pixels) {
        return (double)pixels / 16.0;
    }

    public static class_238 getBoundsForPixels(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return new class_238(MathsHelper.getPixelDistance(minX), MathsHelper.getPixelDistance(minY), MathsHelper.getPixelDistance(minZ), MathsHelper.getPixelDistance(maxX), MathsHelper.getPixelDistance(maxY), MathsHelper.getPixelDistance(maxZ));
    }

    public static int adjustToRange(int initial, int min, int max) {
        return initial < min ? min : (initial > max ? max : initial);
    }

    public static int multiplyColor(int color, float factor) {
        int a = color >> 24 & 0xFF;
        int r = (int)((float)(color >> 16 & 0xFF) * factor);
        int g = (int)((float)(color >> 8 & 0xFF) * factor);
        int b = (int)((float)(color & 0xFF) * factor);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static Map<class_2350, class_265> createHorizontalShapes(double x1, double y1, double z1, double x2, double y2, double z2) {
        EnumMap<class_2350, class_265> shapes = new EnumMap<class_2350, class_265>(class_2350.class);
        class_2350.class_2353.field_11062.forEach(dir -> shapes.put((class_2350)dir, MathsHelper.rotateShape(dir, x1, y1, z1, x2, y2, z2)));
        return shapes;
    }

    public static class_265 rotateShape(class_2350 facing, double x1, double y1, double z1, double x2, double y2, double z2) {
        switch (facing) {
            case field_11043: {
                return class_2248.method_9541((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
            }
            case field_11034: {
                return class_2248.method_9541((double)(16.0 - z2), (double)y1, (double)x1, (double)(16.0 - z1), (double)y2, (double)x2);
            }
            case field_11035: {
                return class_2248.method_9541((double)(16.0 - x2), (double)y1, (double)(16.0 - z2), (double)(16.0 - x1), (double)y2, (double)(16.0 - z1));
            }
            case field_11039: {
                return class_2248.method_9541((double)z1, (double)y1, (double)(16.0 - x2), (double)z2, (double)y2, (double)(16.0 - x1));
            }
        }
        throw new IllegalArgumentException("Can not rotate face in direction " + facing.name());
    }

    public static String profileNanoTime(long start, long stop) {
        double duration = stop - start;
        return duration < 10000.0 ? "ns (<0.01ms)" : DECIMAL_2.format(duration / 1000000.0) + "ms";
    }

    public static class_2338 randomOffsetHorizontal(class_2338 startPos, class_5819 rng, int range) {
        return MathsHelper.randomOffset(startPos, rng, range, 0, range);
    }

    public static class_2338 randomOffset(class_2338 startPos, class_5819 rng, int rangeX, int rangeY, int rangeZ) {
        if (rangeX < 0 || rangeY < 0 || rangeZ < 0) {
            throw new IllegalArgumentException("Cannot offset position by '" + rangeX + ", " + rangeY + ", " + rangeZ + "'. Range must be positive!");
        }
        int offsetX = rangeX != 0 ? rng.method_39332(-rangeX, rangeX) : 0;
        int offsetY = rangeY != 0 ? rng.method_39332(-rangeY, rangeY) : 0;
        int offsetZ = rangeZ != 0 ? rng.method_39332(-rangeZ, rangeZ) : 0;
        return startPos.method_10069(offsetX, offsetY, offsetZ);
    }
}

