/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.data.recipes.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.api.Services;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_5699;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import net.minecraft.class_8785;

public class ShapelessDurabilityRecipe
extends class_1867 {
    public static final Serializer SERIALIZER = new Serializer();
    private final class_1799 output;
    private final int damageAmount;

    public ShapelessDurabilityRecipe(String group, class_7710 category, class_1799 result, class_2371<class_1856> ingredients, int damageAmount) {
        super(group, category, result, ingredients);
        this.damageAmount = damageAmount;
        this.output = result;
    }

    public class_2371<class_1799> getRemainingItems(class_8566 inv) {
        class_2371 keptItems = super.method_8111((class_1263)inv);
        return Services.INVENTORY_HELPER.keepDamageableItems(inv, (class_2371<class_1799>)keptItems, this.damageAmount);
    }

    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    public class_1799 getOutput() {
        return this.output;
    }

    public int getDamageAmount() {
        return this.damageAmount;
    }

    public static class Serializer
    implements class_1865<ShapelessDurabilityRecipe> {
        private static final Codec<ShapelessDurabilityRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.method_53049((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(class_1867::method_8112), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(class_1867::method_45441), (App)class_8785.field_46092.fieldOf("result").forGetter(ShapelessDurabilityRecipe::getOutput), (App)class_1856.field_46096.listOf().fieldOf("ingredients").flatXmap(raw -> {
            Object[] ingredients = (class_1856[])raw.stream().filter(entry -> !entry.method_8103()).toArray(class_1856[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return ingredients.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success((Object)class_2371.method_10212((Object)class_1856.field_9017, (Object[])ingredients));
        }, DataResult::success).forGetter(class_1867::method_8117), (App)Codec.INT.fieldOf("damageAmount").orElse((Object)1).forGetter(ShapelessDurabilityRecipe::getDamageAmount)).apply((Applicative)instance, ShapelessDurabilityRecipe::new));

        public Codec<ShapelessDurabilityRecipe> method_53736() {
            return CODEC;
        }

        public ShapelessDurabilityRecipe fromNetwork(class_2540 buffer) {
            String group = buffer.method_10800(Short.MAX_VALUE);
            int inputCount = buffer.method_10816();
            class_2371 inputs = class_2371.method_10213((int)inputCount, (Object)class_1856.field_9017);
            for (int i = 0; i < inputCount; ++i) {
                inputs.set(i, (Object)class_1856.method_8086((class_2540)buffer));
            }
            class_7710 category = (class_7710)buffer.method_10818(class_7710.class);
            class_1799 output = buffer.method_10819();
            int damageAmount = buffer.method_10816();
            return new ShapelessDurabilityRecipe(group, category, output, (class_2371<class_1856>)inputs, damageAmount);
        }

        public void toNetwork(class_2540 buffer, ShapelessDurabilityRecipe toWrite) {
            buffer.method_10814(toWrite.method_8112());
            buffer.method_10804(toWrite.method_8117().size());
            for (class_1856 ingredient : toWrite.method_8117()) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10817((Enum)toWrite.method_45441());
            buffer.method_10793(toWrite.output);
            buffer.method_10804(toWrite.damageAmount);
        }

        private static class_2371<class_1856> readIngredients(JsonArray json) {
            class_2371 ingredients = class_2371.method_10211();
            for (JsonElement element : json) {
                class_1856 ingredient = (class_1856)class_1856.field_46096.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).get().orThrow();
                if (ingredient.method_8103()) continue;
                ingredients.add((Object)ingredient);
            }
            return ingredients;
        }
    }
}

