/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.gametest.tests;

import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.api.data.bytebuf.ByteBufHelper;
import net.darkhax.bookshelf.impl.gametest.ITestable;
import net.darkhax.bookshelf.impl.gametest.TestHelper;
import net.minecraft.class_2540;
import net.minecraft.class_4516;
import net.minecraft.class_6005;
import net.minecraft.class_6008;
import net.minecraft.class_6302;

public class ByteBufTests<T>
implements ITestable {
    protected final String type;
    protected final ByteBufHelper<T> bufHelper;
    protected final T singleton;
    protected final T[] collection;
    protected final BiPredicate<T, T> equality;

    public ByteBufTests(String type, ByteBufHelper<T> serializer, T ... collection) {
        this(type, (ByteBufHelper<Object>)serializer, Objects::equals, (Object)collection[0], collection);
    }

    public ByteBufTests(String type, ByteBufHelper<T> codecHelper, BiPredicate<T, T> equality, T ... collection) {
        this(type, codecHelper, equality, collection[0], collection);
    }

    public ByteBufTests(String type, ByteBufHelper<T> codecHelper, BiPredicate<T, T> equality, T singleton, T ... collection) {
        this.type = type;
        this.bufHelper = codecHelper;
        this.equality = equality;
        this.singleton = singleton;
        this.collection = collection;
    }

    @class_6302
    public void test_singleton(class_4516 helper) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        this.bufHelper.write(buffer, this.singleton);
        T fromBuffer = this.bufHelper.read(buffer);
        if (!this.equality.test(this.singleton, fromBuffer)) {
            helper.method_35995("Deserialized singleton does not match input! a=" + this.singleton + " b=" + fromBuffer);
            return;
        }
        helper.method_36036();
    }

    @class_6302
    public void test_array(class_4516 helper) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        this.bufHelper.writeArray(buffer, this.collection);
        T[] fromBuffer = this.bufHelper.readArray(buffer);
        TestHelper.assertEqual(helper, this.collection, fromBuffer, this.equality);
    }

    @class_6302
    public void test_list(class_4516 helper) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        List<T> inputList = Arrays.asList(this.collection);
        this.bufHelper.writeList(buffer, inputList);
        List<T> fromBuffer = this.bufHelper.readList(buffer);
        TestHelper.assertEqual(helper, inputList, fromBuffer, this.equality);
    }

    @class_6302
    public void test_set(class_4516 helper) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        Set inputSet = Arrays.stream(this.collection).collect(Collectors.toSet());
        this.bufHelper.writeSet(buffer, inputSet);
        Set<T> fromBuffer = this.bufHelper.readSet(buffer);
        TestHelper.assertEqual(helper, inputSet, fromBuffer, this.equality);
    }

    @class_6302
    public void test_optional(class_4516 helper) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        Optional<T> input = Optional.of(this.singleton);
        this.bufHelper.writeOptional(buffer, input);
        Optional<T> fromBuffer = this.bufHelper.readOptional(buffer);
        TestHelper.assertEqual(helper, input, fromBuffer, this.equality);
    }

    @class_6302
    public void test_optional_empty(class_4516 helper) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        Optional input = Optional.empty();
        this.bufHelper.writeOptional(buffer, input);
        Optional<T> fromBuffer = this.bufHelper.readOptional(buffer);
        TestHelper.assertEqual(helper, input, fromBuffer, this.equality);
    }

    @class_6302
    public void test_nullable(class_4516 helper) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        this.bufHelper.writeNullable(buffer, this.singleton);
        T fromBuffer = this.bufHelper.readNullable(buffer);
        if (!this.equality.test(this.singleton, fromBuffer)) {
            helper.method_35995("Deserialized singleton does not match input! a=" + this.singleton + " b=" + fromBuffer);
            return;
        }
        helper.method_36036();
    }

    @class_6302
    public void test_nullable_null(class_4516 helper) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        this.bufHelper.writeNullable(buffer, null);
        T fromBuffer = this.bufHelper.readNullable(buffer);
        if (!this.equality.test(null, fromBuffer)) {
            helper.method_35995("Deserialized singleton does not match input! a=null b=" + fromBuffer);
            return;
        }
        helper.method_36036();
    }

    @class_6302
    public void test_weighted(class_4516 helper) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        class_6008.class_6010 input = class_6008.method_34980(this.singleton, (int)22);
        this.bufHelper.writeWeighted(buffer, input);
        class_6008.class_6010<T> fromBuffer = this.bufHelper.readWeighted(buffer);
        TestHelper.assertEqual(helper, input, fromBuffer, this.equality);
    }

    @class_6302
    public void test_weighted_list(class_4516 helper) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        class_6005.class_6006 builder = new class_6005.class_6006();
        for (int i = 0; i < this.collection.length; ++i) {
            builder.method_34975(this.collection[i], i * 4);
        }
        class_6005 input = builder.method_34974();
        this.bufHelper.writeWeightedList(buffer, input);
        class_6005<T> fromBuffer = this.bufHelper.readWeightedList(buffer);
        TestHelper.assertEqual(helper, input, fromBuffer, this.equality);
    }

    @Override
    public String getDefaultBatch() {
        return "bookshelf.bytebuf." + this.type;
    }
}

