/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.gametest.tests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.darkhax.bookshelf.api.data.codecs.BookshelfCodecs;
import net.darkhax.bookshelf.impl.gametest.ITestable;
import net.darkhax.bookshelf.impl.gametest.tests.CodecTests;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_4516;
import net.minecraft.class_6302;

public class ItemStackTests
implements ITestable {
    @Override
    public String getDefaultBatch() {
        return "bookshelf.itemstack_tests";
    }

    @class_6302
    public void test_stack(class_4516 helper) {
        JsonObject object = new JsonObject();
        object.addProperty("item", "minecraft:stone");
        ItemStackTests.assertStackIsBasic(helper, CodecTests.fromJson(helper, BookshelfCodecs.ITEM_STACK_RECIPE.get(), (JsonElement)object));
        ItemStackTests.assertStackIsBasic(helper, CodecTests.fromJson(helper, BookshelfCodecs.ITEM_STACK_NBT.get(), (JsonElement)object));
        ItemStackTests.assertStackIsBasic(helper, CodecTests.fromJson(helper, BookshelfCodecs.ITEM_STACK_FLEXIBLE.get(), (JsonElement)object));
        ItemStackTests.assertStackIsBasic(helper, CodecTests.fromJson(helper, BookshelfCodecs.ITEM_STACK_FLEXIBLE.get(), (JsonElement)new JsonPrimitive("minecraft:stone")));
    }

    @class_6302
    public void test_stack_tag(class_4516 helper) {
        JsonObject object = new JsonObject();
        object.addProperty("item", "minecraft:stone");
        JsonObject nbt = new JsonObject();
        nbt.addProperty("test", "hello_world");
        object.add("nbt", (JsonElement)nbt);
        class_1799 readStack = CodecTests.fromJson(helper, BookshelfCodecs.ITEM_STACK_NBT.get(), (JsonElement)object);
        if (readStack == null || readStack.method_7960() || !readStack.method_31574(class_1802.field_20391) || readStack.method_7947() != 1 || !readStack.method_7985() || !readStack.method_7969().method_10573("test", 8)) {
            helper.method_35995("Unexpected ItemStack read! " + readStack);
        } else {
            helper.method_36036();
        }
    }

    private static void assertStackIsBasic(class_4516 helper, class_1799 stack) {
        if (stack == null || stack.method_7960() || !stack.method_31574(class_1802.field_20391) || stack.method_7985() || stack.method_7947() != 1) {
            helper.method_35995("Unexpected ItemStack read! " + stack);
        } else {
            helper.method_36036();
        }
    }
}

