/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.data.sound;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Function;
import net.darkhax.bookshelf.api.data.bytebuf.BookshelfByteBufs;
import net.darkhax.bookshelf.api.data.codecs.BookshelfCodecs;
import net.darkhax.bookshelf.api.data.sound.ISound;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class Sound
implements ISound {
    public static Codec<Sound> CODEC_SIMPLE = BuiltInRegistries.f_256894_.m_194605_().xmap(Sound::new, Sound::getSound);
    public static Codec<Sound> CODEC_OBJECT = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256894_.m_194605_().fieldOf("sound").forGetter(Sound::getSound), BookshelfCodecs.SOUND_SOURCE.get("category", Sound::getCategory, SoundSource.MASTER), (App)Codec.FLOAT.optionalFieldOf("pitch", (Object)Float.valueOf(1.0f)).forGetter(Sound::getPitch), (App)Codec.FLOAT.optionalFieldOf("volume", (Object)Float.valueOf(1.0f)).forGetter(Sound::getVolume)).apply((Applicative)instance, Sound::new));
    public static Codec<Sound> CODEC = ExtraCodecs.m_294448_(CODEC_SIMPLE, CODEC_OBJECT).xmap(either -> (Sound)either.map(Function.identity(), Function.identity()), value -> value.isSimple() ? Either.left((Object)value) : Either.right((Object)value));
    private final SoundEvent sound;
    private final SoundSource category;
    private final float pitch;
    private final float volume;

    public Sound(SoundEvent sound) {
        this(sound, SoundSource.MASTER, 1.0f, 1.0f);
    }

    public Sound(SoundEvent sound, SoundSource category, float pitch, float volume) {
        this.sound = sound;
        this.category = category;
        this.pitch = pitch;
        this.volume = volume;
    }

    private boolean isSimple() {
        return this.category == SoundSource.MASTER && this.pitch == 1.0f && this.volume == 1.0f;
    }

    @Override
    public void playSoundAt(Level level, @Nullable Player originator, double posX, double posY, double posZ) {
        level.m_6263_(originator, posX, posY, posZ, this.sound, this.category, this.volume, this.pitch);
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    public SoundSource getCategory() {
        return this.category;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getVolume() {
        return this.volume;
    }

    public String toString() {
        return "Sound{sound=" + this.sound.m_11660_() + ", category=" + this.category + ", pitch=" + this.pitch + ", volume=" + this.volume + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sound)) {
            return false;
        }
        Sound sound1 = (Sound)o;
        return Float.compare(this.getPitch(), sound1.getPitch()) == 0 && Float.compare(this.getVolume(), sound1.getVolume()) == 0 && Objects.equals(this.getSound(), sound1.getSound()) && this.getCategory() == sound1.getCategory();
    }

    public int hashCode() {
        return Objects.hash(this.getSound(), this.getCategory(), Float.valueOf(this.getPitch()), Float.valueOf(this.getVolume()));
    }

    public static Sound fromByteBuf(FriendlyByteBuf buffer) {
        SoundEvent sound = (SoundEvent)BookshelfByteBufs.SOUND_EVENT.read(buffer);
        SoundSource category = BookshelfByteBufs.SOUND_SOURCE.read(buffer);
        float pitch = BookshelfByteBufs.FLOAT.read(buffer).floatValue();
        float volume = BookshelfByteBufs.FLOAT.read(buffer).floatValue();
        return new Sound(sound, category, pitch, volume);
    }

    public static void toByteBuf(FriendlyByteBuf buffer, Sound toWrite) {
        BookshelfByteBufs.SOUND_EVENT.write(buffer, toWrite.sound);
        BookshelfByteBufs.SOUND_SOURCE.write(buffer, toWrite.category);
        BookshelfByteBufs.FLOAT.write(buffer, Float.valueOf(toWrite.pitch));
        BookshelfByteBufs.FLOAT.write(buffer, Float.valueOf(toWrite.volume));
    }
}

