/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.util;

import com.google.common.math.DoubleMath;
import java.util.Arrays;
import java.util.Objects;
import net.darkhax.bookshelf.api.util.AttributeHelper;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public final class ItemStackHelper {
    public static double getAttackDamage(ItemStack stack) {
        return ItemStackHelper.getAttackDamage(stack, MobType.f_21640_);
    }

    public static double getAttackDamage(ItemStack stack, Entity target) {
        MobType mobType;
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            mobType = living.m_6336_();
        } else {
            mobType = MobType.f_21640_;
        }
        return ItemStackHelper.getAttackDamage(stack, mobType);
    }

    public static double getAttackDamage(ItemStack stack, MobType targetType) {
        double damage = AttributeHelper.getAttackDamage(stack);
        double bonusEnchantmentDamage = EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)targetType);
        return damage + bonusEnchantmentDamage;
    }

    public static ItemStack[] getTabItems(CreativeModeTab tab) {
        return (ItemStack[])tab.m_260957_().toArray(ItemStack[]::new);
    }

    public static boolean areStacksEquivalent(ItemStack first, ItemStack second) {
        return ItemStackHelper.areStacksEquivalent(first, second, false);
    }

    public static boolean areStacksContentsEquivalent(ItemStack first, ItemStack second) {
        return ItemStackHelper.areStacksEquivalent(first, second, true);
    }

    public static boolean areStacksEquivalent(ItemStack first, ItemStack second, boolean ignoreTags) {
        return first == null && second == null || first.m_41619_() == second.m_41619_() || first.m_41613_() == second.m_41613_() && first.m_41720_() == second.m_41720_() && (ignoreTags || ItemStackHelper.areTagsEquivalent((Tag)first.m_41783_(), (Tag)second.m_41783_()));
    }

    public static boolean areTagsEquivalent(Tag a, Tag b) {
        if (!Objects.equals(a, b)) {
            if (a instanceof NumericTag) {
                NumericTag numericA = (NumericTag)a;
                if (b instanceof NumericTag) {
                    NumericTag numericB = (NumericTag)b;
                    return ItemStackHelper.areNumericTagsEquivalent(numericA, numericB);
                }
            }
            if (a instanceof CollectionTag) {
                CollectionTag collectionA = (CollectionTag)a;
                if (b instanceof CollectionTag) {
                    CollectionTag collectionB = (CollectionTag)b;
                    return ItemStackHelper.areCollectionTagsEquivalent(collectionA, collectionB);
                }
            }
            if (a instanceof CompoundTag) {
                CompoundTag compoundA = (CompoundTag)a;
                if (b instanceof CompoundTag) {
                    CompoundTag compoundB = (CompoundTag)b;
                    return ItemStackHelper.areCompoundTagsEquivalent(compoundA, compoundB);
                }
            }
        }
        return true;
    }

    public static boolean areCompoundTagsEquivalent(CompoundTag a, CompoundTag b) {
        if (a.m_128440_() != b.m_128440_()) {
            return false;
        }
        for (String key : a.m_128431_()) {
            if (ItemStackHelper.areTagsEquivalent((Tag)a.m_128469_(key), (Tag)b.m_128469_(key))) continue;
            return false;
        }
        return true;
    }

    public static boolean areCollectionTagsEquivalent(CollectionTag<?> a, CollectionTag<?> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int index = 0; index < a.size(); ++index) {
            if (ItemStackHelper.areTagsEquivalent((Tag)a.get(index), (Tag)b.get(index))) continue;
            return false;
        }
        return true;
    }

    public static boolean areNumericTagsEquivalent(NumericTag a, NumericTag b) {
        boolean decimalB;
        boolean decimalA = ItemStackHelper.isDecimal(a);
        if (decimalA == (decimalB = ItemStackHelper.isDecimal(b))) {
            if (decimalA) {
                return Mth.m_14082_((double)a.m_7061_(), (double)b.m_7061_());
            }
            return a.m_7046_() == b.m_7046_();
        }
        if (decimalA) {
            return DoubleMath.isMathematicalInteger((double)a.m_7061_()) && (int)a.m_7061_() == b.m_7047_();
        }
        return DoubleMath.isMathematicalInteger((double)b.m_7061_()) && (int)b.m_7061_() == a.m_7047_();
    }

    public static boolean isDecimal(NumericTag tag) {
        return tag instanceof FloatTag || tag instanceof DoubleTag;
    }

    public static void setLore(ItemStack stack, Component ... lines) {
        CompoundTag displayTag = stack.m_41698_("display");
        ListTag loreList = new ListTag();
        Arrays.stream(lines).forEach(line -> loreList.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)line))));
        displayTag.m_128365_("Lore", (Tag)loreList);
    }

    public static void appendLore(ItemStack stack, Component ... lines) {
        CompoundTag displayTag = stack.m_41698_("display");
        ListTag loreList = displayTag.m_128441_("Lore") ? displayTag.m_128437_("Lore", 8) : new ListTag();
        Arrays.stream(lines).forEach(line -> loreList.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)line))));
        displayTag.m_128365_("Lore", (Tag)loreList);
    }
}

