/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.bridge_maker.elements.blocks.bridge_maker;

import de.geheimagentnr1.bridge_maker.elements.blocks.BlockItemInterface;
import de.geheimagentnr1.bridge_maker.elements.blocks.ModBlocks;
import de.geheimagentnr1.bridge_maker.elements.blocks.bridge_maker.BridgeMakerInventory;
import de.geheimagentnr1.bridge_maker.elements.blocks.bridge_maker.BridgeMakerTile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BridgeMaker
extends Block
implements BlockItemInterface {
    public static final String registry_name = "bridge_maker";

    public BridgeMaker() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e));
        this.setRegistryName(registry_name);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BridgeMakerTile();
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, World worldIn, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand handIn, @Nonnull BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof BridgeMakerTile) {
                BridgeMakerTile bridgeMakerTile = (BridgeMakerTile)tileentity;
                player.func_213829_a((INamedContainerProvider)bridgeMakerTile);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)context.func_196010_d().func_176734_d());
    }

    public void func_220069_a(@Nonnull BlockState state, World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            boolean isPowered;
            boolean bl = isPowered = worldIn.func_175687_A(pos) > 0;
            if (isPowered != (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208194_u)) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(isPowered)), 3);
                TileEntity tileentity = worldIn.func_175625_s(pos);
                if (tileentity instanceof BridgeMakerTile) {
                    BridgeMakerTile bridgeMakerTile = (BridgeMakerTile)tileentity;
                    BridgeMakerInventory bridgeMakerInventory = bridgeMakerTile.getInventory();
                    bridgeMakerTile.setSetBocksArray(isPowered ? this.power(bridgeMakerInventory, state, pos, worldIn) : this.unpower(bridgeMakerInventory, bridgeMakerTile.getSetBlocks(), state, pos, worldIn));
                }
            }
        }
    }

    private boolean[] power(BridgeMakerInventory bridgeMakerInventory, BlockState state, BlockPos pos, World worldIn) {
        boolean[] setBlocks = new boolean[bridgeMakerInventory.func_70302_i_()];
        ArrayList<Block> replacableBlocks = new ArrayList<Block>(Arrays.asList(Blocks.field_150350_a, Blocks.field_150353_l, Blocks.field_150355_j));
        BlockPos nextPos = pos;
        for (int i = 0; i < bridgeMakerInventory.func_70302_i_(); ++i) {
            setBlocks[i] = false;
            if (!replacableBlocks.contains(worldIn.func_180495_p(nextPos = nextPos.func_177972_a((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H))).func_177230_c()) || bridgeMakerInventory.func_70301_a(i).func_190926_b()) continue;
            worldIn.func_180501_a(nextPos, bridgeMakerInventory.getBlockStateForSlot(i), 3);
            BlockItem.func_179224_a((World)worldIn, null, (BlockPos)nextPos, (ItemStack)bridgeMakerInventory.func_70301_a(i));
            bridgeMakerInventory.setInventorySlotContents(i, ItemStack.field_190927_a, null);
            setBlocks[i] = true;
        }
        return setBlocks;
    }

    private boolean[] unpower(BridgeMakerInventory bridgeMakerInventory, boolean[] setBlocks, BlockState state, BlockPos pos, World worldIn) {
        int i;
        Direction facingDirection = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        int inventorySize = bridgeMakerInventory.func_70302_i_();
        BlockState[] blockStates = new BlockState[inventorySize];
        BlockPos nextPos = pos;
        BlockPos collectPos = pos;
        for (i = 0; i < inventorySize; ++i) {
            nextPos = nextPos.func_177972_a(facingDirection);
            if (!setBlocks[i] || !bridgeMakerInventory.func_70301_a(i).func_190926_b()) continue;
            blockStates[i] = worldIn.func_180495_p(nextPos);
        }
        for (i = 0; i < inventorySize; ++i) {
            if (worldIn.func_180495_p(collectPos = collectPos.func_177972_a(facingDirection)) == Blocks.field_150350_a.func_176223_P()) {
                blockStates[i] = null;
                continue;
            }
            if (!setBlocks[i] || !bridgeMakerInventory.func_70301_a(i).func_190926_b()) continue;
            ItemStack blockItemStack = null;
            List drops = BridgeMaker.func_220070_a((BlockState)blockStates[i], (ServerWorld)((ServerWorld)worldIn), (BlockPos)collectPos, (TileEntity)worldIn.func_175625_s(collectPos));
            for (ItemStack drop : drops) {
                if (!(drop.func_77973_b() instanceof BlockItem) || ((BlockItem)drop.func_77973_b()).func_179223_d() != blockStates[i].func_177230_c()) continue;
                blockItemStack = drop;
                break;
            }
            if (blockItemStack == null) {
                blockItemStack = new ItemStack((IItemProvider)blockStates[i].func_177230_c().func_199767_j());
            }
            if (blockItemStack.func_77973_b() instanceof BlockItem) {
                bridgeMakerInventory.setInventorySlotContents(i, blockItemStack, blockStates[i]);
                worldIn.func_180501_a(collectPos, Blocks.field_150350_a.func_176223_P(), 3);
            }
            setBlocks[i] = false;
        }
        return setBlocks;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208155_H, BlockStateProperties.field_208194_u});
    }

    @Override
    public Item getBlockItem(Item.Properties properties) {
        return (Item)new BlockItem((Block)ModBlocks.BRIDGE_MAKER, properties).setRegistryName(registry_name);
    }
}

