/*
 * Decompiled with CFR 0.152.
 */
package com.bespectacled.classicbeaches.surfacebuilder;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_3523;
import net.minecraft.class_3527;
import net.minecraft.class_3537;

public class BeachSurfaceBuilder
extends class_3523<class_3527> {
    private static final class_2680 STONE = class_2246.field_10340.method_9564();
    private static final class_2680 AIR = class_2246.field_10124.method_9564();
    private static final class_2680 GRAVEL = class_2246.field_10255.method_9564();
    private static final class_2680 SAND = class_2246.field_10102.method_9564();
    private static final class_2680 SANDSTONE = class_2246.field_9979.method_9564();
    protected long seed;
    protected class_3537 noise;

    public BeachSurfaceBuilder(Codec<class_3527> codec) {
        super(codec);
    }

    public void generate(Random random, class_2791 chunk, class_1959 biome, int x, int z, int worldHeight, double stoneNoise, class_2680 defaultBlock, class_2680 defaultFluid, int fluidLevel, long seed, class_3527 ternarySurfaceConfig) {
        int seaLevel = fluidLevel;
        int relX = x & 0xF;
        int relZ = z & 0xF;
        double eighth = 0.03125;
        double sandThreshold = 5.0;
        if (biome.method_8688() == class_1959.class_1961.field_9363) {
            // empty if block
        }
        double sandNoise = this.noise.method_15416((double)x * 0.03125, (double)z * 0.03125, 0.0) * 75.0 + random.nextDouble();
        double gravelNoise = this.noise.method_15416((double)x * 0.03125, 109.0, (double)z * 0.03125) * 75.0 + random.nextDouble();
        boolean genSand = sandNoise > sandThreshold;
        boolean genGravel = gravelNoise > 20.0;
        int genStone = (int)(stoneNoise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        class_2338.class_2339 pos = new class_2338.class_2339();
        int flag = -1;
        class_2680 topBlock = ternarySurfaceConfig.method_15337();
        class_2680 fillerBlock = ternarySurfaceConfig.method_15336();
        for (int y = worldHeight; y >= 0; --y) {
            pos.method_10103(relX, y, relZ);
            class_2680 thisBlock = chunk.method_8320((class_2338)pos);
            if (thisBlock.method_26215()) {
                flag = -1;
                continue;
            }
            if (!thisBlock.method_27852(defaultBlock.method_26204())) continue;
            if (flag == -1) {
                if (genStone <= 0) {
                    topBlock = AIR;
                    fillerBlock = STONE;
                } else if (y >= seaLevel - 4 && y <= seaLevel + 1) {
                    topBlock = ternarySurfaceConfig.method_15337();
                    fillerBlock = ternarySurfaceConfig.method_15336();
                    if (genGravel) {
                        topBlock = AIR;
                        fillerBlock = GRAVEL;
                    }
                    if (genSand) {
                        topBlock = SAND;
                        fillerBlock = SAND;
                    }
                }
                if (y < seaLevel && topBlock.method_26215()) {
                    topBlock = defaultFluid;
                }
                flag = genStone;
                if (y >= seaLevel - 1) {
                    chunk.method_12010((class_2338)pos, topBlock, false);
                    continue;
                }
                chunk.method_12010((class_2338)pos, fillerBlock, false);
                continue;
            }
            if (flag <= 0) continue;
            chunk.method_12010((class_2338)pos, fillerBlock, false);
            if (--flag != 0 || !fillerBlock.equals(SAND)) continue;
            flag = random.nextInt(4);
            fillerBlock = SANDSTONE;
        }
    }

    public void method_15306(long long2) {
        if (this.seed != long2 || this.noise == null) {
            this.noise = new class_3537(new class_2919(long2), IntStream.rangeClosed(-3, 0));
        }
        this.seed = long2;
    }
}

