/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.impl.overlays.mod;

import com.elenai.feathers.api.FeathersHelper;
import com.elenai.feathers.client.gui.FeathersHudOverlay;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import tfar.classicbar.config.ClassicBarsConfig;
import tfar.classicbar.impl.BarOverlayImpl;
import tfar.classicbar.util.Color;
import tfar.classicbar.util.ColorUtils;
import tfar.classicbar.util.ModUtils;

public class Feathers
extends BarOverlayImpl {
    private static final ResourceLocation DODGE_ICONS = new ResourceLocation("elenaidodge2", "textures/gui/icons.png");

    public Feathers() {
        super("feathers");
    }

    @Override
    public boolean shouldRender(Player player) {
        return true;
    }

    @Override
    public void renderBar(ForgeGui gui, PoseStack stack, Player player, int screenWidth, int screenHeight, int vOffset) {
        double feathers = FeathersHelper.getFeathers();
        int maxFeathers = FeathersHelper.getMaxFeathers();
        int xStart = screenWidth / 2 + 10;
        int yStart = screenHeight - vOffset;
        GlStateManager.m_84525_();
        Color.reset();
        ModUtils.drawTexturedModalRect(stack, xStart, yStart, 0, 0, 81.0, 9);
        double f = (double)(xStart + 79) - ModUtils.getWidth(feathers, maxFeathers);
        ColorUtils.hex2Color("#22a5f0").color2Gl();
        ModUtils.drawTexturedModalRect(stack, f, yStart + 1, 1, 10, ModUtils.getWidth(feathers, maxFeathers), 7);
    }

    @Override
    public boolean shouldRenderText() {
        return (Boolean)ClassicBarsConfig.showHungerNumbers.get();
    }

    @Override
    public void renderText(PoseStack stack, Player player, int width, int height, int vOffset) {
        double feathers = 0.0;
        int c = Integer.decode("#22a5f0");
        int xStart = width / 2 + this.getIconOffset();
        int yStart = height - vOffset;
        this.textHelper(stack, xStart, yStart, feathers, c);
    }

    @Override
    public void renderIcon(PoseStack stack, Player player, int width, int height, int vOffset) {
        int xStart = width / 2 + 10;
        int yStart = height - vOffset;
        ModUtils.drawTexturedModalRect(stack, xStart + 82, yStart, 34, 0, 9.0, 9);
    }

    @Override
    public double getBarWidth(Player player) {
        double feathers = FeathersHelper.getFeathers();
        int maxFeathers = FeathersHelper.getMaxFeathers();
        return 77.0 * feathers / (double)maxFeathers;
    }

    @Override
    public ResourceLocation getIconRL() {
        return FeathersHudOverlay.ICONS;
    }
}

