/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.impl.overlays.mod;

import com.alrex.parcool.client.hud.impl.HUDType;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.config.ParCoolConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import tfar.classicbar.config.ClassicBarsConfig;
import tfar.classicbar.impl.BarOverlayImpl;
import tfar.classicbar.util.Color;

public class StaminaB
extends BarOverlayImpl {
    public static final String name = "parcool:stamina";
    private static final ResourceLocation ICONS = new ResourceLocation("parcool:textures/gui/stamina_bar.png");

    public StaminaB() {
        super(name);
    }

    @Override
    public boolean shouldRender(Player player) {
        int currentStamina;
        if (!StaminaB.checkConfigs()) {
            return false;
        }
        IStamina stamina = IStamina.get((Player)player);
        int maxStamina = stamina.getMaxStamina();
        return maxStamina > (currentStamina = stamina.get());
    }

    public static boolean checkConfigs() {
        return ParCoolConfig.Client.StaminaHUDType.get() == HUDType.Light;
    }

    @Override
    public void renderBar(ForgeGui gui, PoseStack stack, Player player, int screenWidth, int screenHeight, int vOffset) {
        int xStart = screenWidth / 2 + this.getHOffset();
        int yStart = screenHeight - vOffset;
        double barWidth = this.getBarWidth(player);
        Color.reset();
        this.renderFullBarBackground(stack, xStart, yStart);
        double f = (double)xStart + (this.rightHandSide() ? 77.0 - barWidth : 0.0);
        Color color = this.getPrimaryBarColor(0, player);
        color.color2Gl();
        this.renderPartialBar(stack, f + 2.0, yStart + 2, barWidth);
    }

    @Override
    public boolean shouldRenderText() {
        return (Boolean)ClassicBarsConfig.showAirNumbers.get();
    }

    @Override
    public double getBarWidth(Player player) {
        IStamina stamina = IStamina.get((Player)player);
        int cStamina = stamina.get();
        int maxStamina = stamina.getMaxStamina();
        return Math.ceil(77.0 * (double)cStamina / (double)maxStamina);
    }

    @Override
    public Color getPrimaryBarColor(int index, Player player) {
        return Color.YELLOW;
    }

    @Override
    public void renderText(PoseStack stack, Player player, int width, int height, int vOffset) {
        int stamina = IStamina.get((Player)player).get();
        int xStart = width / 2 + this.getIconOffset();
        int yStart = height - vOffset;
        Color color = this.getPrimaryBarColor(0, player);
        this.textHelper(stack, xStart, yStart, stamina / 20, color.colorToText());
    }

    @Override
    public void renderIcon(PoseStack stack, Player player, int width, int height, int vOffset) {
        int xStart = width / 2 + this.getIconOffset();
        int yStart = height - vOffset;
        IStamina stamina = IStamina.get((Player)player);
        int textureX = stamina.isExhausted() ? 16 : 0;
        GuiComponent.m_93133_((PoseStack)stack, (int)xStart, (int)yStart, (float)textureX, (float)119.0f, (int)8, (int)9, (int)128, (int)128);
    }

    @Override
    public ResourceLocation getIconRL() {
        return ICONS;
    }
}

