/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.impl.overlays.vanilla;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import tfar.classicbar.compat.ModCompat;
import tfar.classicbar.compat.VampirismHelper;
import tfar.classicbar.config.ClassicBarsConfig;
import tfar.classicbar.config.ConfigCache;
import tfar.classicbar.impl.BarOverlayImpl;
import tfar.classicbar.network.Message;
import tfar.classicbar.util.Color;
import tfar.classicbar.util.ModUtils;

public class Hunger
extends BarOverlayImpl {
    public Hunger() {
        super("food");
    }

    @Override
    public boolean shouldRender(Player player) {
        return !ModCompat.vampirism.loaded || !VampirismHelper.isVampire(player);
    }

    @Override
    public void renderBar(ForgeGui gui, PoseStack matrices, Player player, int screenWidth, int screenHeight, int vOffset) {
        double hunger = player.m_36324_().m_38702_();
        double maxHunger = 20.0;
        double barWidthH = this.getBarWidth(player);
        double currentSat = player.m_36324_().m_38722_();
        double maxSat = maxHunger;
        double barWidthS = this.getSatBarWidth(player);
        float exhaustion = player.m_36324_().m_150380_();
        int xStart = screenWidth / 2 + this.getHOffset();
        int yStart = screenHeight - vOffset;
        Color.reset();
        this.renderFullBarBackground(matrices, xStart, yStart);
        double f = (double)xStart + (this.rightHandSide() ? 77.0 - barWidthH : 0.0);
        Color hungerColor = this.getSecondaryBarColor(0, player);
        Color satColor = this.getPrimaryBarColor(0, player);
        hungerColor.color2Gl();
        this.renderPartialBar(matrices, f + 2.0, yStart + 2, barWidthH);
        if (currentSat > 0.0 && ((Boolean)ClassicBarsConfig.showSaturationBar.get()).booleanValue()) {
            satColor.color2Gl();
            f = (double)xStart + (this.rightHandSide() ? 77.0 - barWidthS : 0.0);
            this.renderPartialBar(matrices, f + 2.0, yStart + 2, barWidthS);
        }
        if (((Boolean)ClassicBarsConfig.showHeldFoodOverlay.get()).booleanValue() && player.m_21205_().m_41720_().m_41472_()) {
            ItemStack stack = player.m_21205_();
            double time = (double)System.currentTimeMillis() / 1000.0 * (Double)ClassicBarsConfig.transitionSpeed.get();
            double foodAlpha = Math.sin(time) / 2.0 + 0.5;
            FoodProperties food = stack.m_41720_().getFoodProperties(stack, (LivingEntity)player);
            double hungerOverlay = food.m_38744_();
            double saturationMultiplier = food.m_38745_();
            double potentialSat = 2.0 * hungerOverlay * saturationMultiplier;
            double hungerWidth = Math.min(maxHunger - hunger, hungerOverlay);
            if (hunger < maxHunger) {
                double w = ModUtils.getWidth(hungerWidth + hunger, maxHunger);
                f = (double)xStart + (this.rightHandSide() ? 77.0 - w : 0.0);
                hungerColor.color2Gla((float)foodAlpha);
                this.renderPartialBar(matrices, f + 2.0, yStart + 2, w);
            }
            if (((Boolean)ClassicBarsConfig.showSaturationBar.get()).booleanValue()) {
                double saturationWidth = Math.min(potentialSat, maxSat - currentSat);
                saturationWidth = Math.min(saturationWidth, hunger + hungerWidth);
                saturationWidth = Math.min(saturationWidth, hungerOverlay + hunger);
                if (potentialSat + currentSat > hunger + hungerWidth) {
                    double diff = potentialSat + currentSat - (hunger + hungerWidth);
                    saturationWidth = potentialSat - diff;
                }
                double w = ModUtils.getWidth(saturationWidth + currentSat, maxSat);
                f = (double)xStart + (this.rightHandSide() ? 77.0 - w : 0.0);
                satColor.color2Gla((float)foodAlpha);
                this.renderPartialBar(matrices, f + 2.0, yStart + 2, w);
            }
        }
        if (((Boolean)ClassicBarsConfig.showExhaustionOverlay.get()).booleanValue() && Message.presentOnServer) {
            exhaustion = Math.min(exhaustion, 4.0f);
            f = (double)xStart + (this.rightHandSide() ? 77.0 - ModUtils.getWidth(exhaustion, 4.0) : 0.0);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
            ModUtils.drawTexturedModalRect(matrices, f + 2.0, yStart + 1, 1, 28, ModUtils.getWidth(exhaustion, 4.0), 9);
        }
    }

    @Override
    public double getBarWidth(Player player) {
        double hunger = player.m_36324_().m_38702_();
        double maxHunger = 20.0;
        return Math.ceil(77.0 * hunger / maxHunger);
    }

    public int getSatBarWidth(Player player) {
        double saturation = player.m_36324_().m_38722_();
        double maxSat = 20.0;
        return (int)Math.ceil(77.0 * saturation / maxSat);
    }

    @Override
    public Color getPrimaryBarColor(int index, Player player) {
        boolean hunger = player.m_21023_(MobEffects.f_19612_);
        return hunger ? ConfigCache.saturationDebuff : ConfigCache.saturation;
    }

    @Override
    public Color getSecondaryBarColor(int index, Player player) {
        boolean hunger = player.m_21023_(MobEffects.f_19612_);
        return hunger ? ConfigCache.hungerDebuff : ConfigCache.hunger;
    }

    @Override
    public boolean shouldRenderText() {
        return (Boolean)ClassicBarsConfig.showHungerNumbers.get();
    }

    @Override
    public void renderText(PoseStack stack, Player player, int width, int height, int vOffset) {
        int xStart = width / 2 + this.getIconOffset();
        int yStart = height - vOffset;
        double hunger = player.m_36324_().m_38702_();
        int c = this.getSecondaryBarColor(0, player).colorToText();
        this.textHelper(stack, xStart, yStart, hunger, c);
    }

    @Override
    public void renderIcon(PoseStack stack, Player player, int width, int height, int vOffset) {
        int xStart = width / 2 + this.getIconOffset();
        int yStart = height - vOffset;
        boolean hungerActive = player.m_21023_(MobEffects.f_19612_);
        int k5 = 52;
        int k6 = 16;
        if (hungerActive) {
            k6 = (k5 += 36) + 45;
        }
        ModUtils.drawTexturedModalRect(stack, xStart, yStart, k6, 27, 9.0, 9);
        ModUtils.drawTexturedModalRect(stack, xStart, yStart, k5, 27, 9.0, 9);
    }
}

