/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import tfar.classicbar.compat.ModCompat;
import tfar.classicbar.network.NetworkHelper;
import toughasnails.api.thirst.ThirstHelper;

public class MessageThirstExhaustionSync {
    private final float exhaustionLevel;

    public MessageThirstExhaustionSync(float exhaustionLevel) {
        this.exhaustionLevel = exhaustionLevel;
    }

    public MessageThirstExhaustionSync(FriendlyByteBuf buf) {
        this.exhaustionLevel = buf.readFloat();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeFloat(this.exhaustionLevel);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        if (ModCompat.toughasnails.loaded) {
            ctx.get().enqueueWork(() -> {
                Player player = NetworkHelper.getSidedPlayer((NetworkEvent.Context)ctx.get());
                ThirstHelper.getThirst((Player)player).setExhaustion(this.exhaustionLevel);
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

