/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import tfar.classicbar.config.ClassicBarsConfig;
import tfar.classicbar.util.Color;
import tfar.classicbar.util.ColorUtils;

public class ConfigCache {
    public static boolean icons;
    public static List<Color> armor;
    public static List<Color> armor_toughness;
    public static Color hunger;
    public static Color hungerDebuff;
    public static Color saturation;
    public static Color saturationDebuff;
    public static Color thirst;
    public static Color thirstDebuff;
    public static Color hydration;
    public static Color hydrationDebuff;
    public static Color air;
    public static List<Color> normal;
    public static List<Color> poison;
    public static List<Color> wither;
    public static List<Color> absorption;
    public static List<Color> absorptionPoison;
    public static List<Color> absorptionWither;

    private static void clear() {
        armor.clear();
        armor_toughness.clear();
        normal.clear();
        poison.clear();
        wither.clear();
        absorption.clear();
        absorptionPoison.clear();
        absorptionWither.clear();
    }

    public static void bake() {
        ConfigCache.clear();
        icons = (Boolean)ClassicBarsConfig.displayIcons.get();
        ConfigCache.cacheList(ClassicBarsConfig.armorColors, armor);
        ConfigCache.cacheList(ClassicBarsConfig.armorToughnessColors, armor_toughness);
        ConfigCache.cacheList(ClassicBarsConfig.normalColors, normal);
        ConfigCache.cacheList(ClassicBarsConfig.poisonedColors, poison);
        ConfigCache.cacheList(ClassicBarsConfig.witheredColors, wither);
        ConfigCache.cacheList(ClassicBarsConfig.absorptionColors, absorption);
        ConfigCache.cacheList(ClassicBarsConfig.absorptionPoisonColors, absorptionPoison);
        ConfigCache.cacheList(ClassicBarsConfig.absorptionWitherColors, absorptionWither);
        hunger = ColorUtils.hex2Color((String)ClassicBarsConfig.hungerBarColor.get());
        hungerDebuff = ColorUtils.hex2Color((String)ClassicBarsConfig.hungerBarDebuffColor.get());
        saturation = ColorUtils.hex2Color((String)ClassicBarsConfig.saturationBarColor.get());
        saturationDebuff = ColorUtils.hex2Color((String)ClassicBarsConfig.saturationBarDebuffColor.get());
        thirst = ColorUtils.hex2Color((String)ClassicBarsConfig.thirstBarColor.get());
        thirstDebuff = ColorUtils.hex2Color((String)ClassicBarsConfig.thirstBarDebuffColor.get());
        hydration = ColorUtils.hex2Color((String)ClassicBarsConfig.hydrationBarColor.get());
        hydrationDebuff = ColorUtils.hex2Color((String)ClassicBarsConfig.hydrationBarDebuffColor.get());
        air = ColorUtils.hex2Color((String)ClassicBarsConfig.airBarColor.get());
    }

    private static void cacheList(ForgeConfigSpec.ConfigValue<List<? extends String>> config, List<Color> cache) {
        for (String s : (List)config.get()) {
            cache.add(ColorUtils.hex2Color(s));
        }
    }

    static {
        armor = new ArrayList<Color>();
        armor_toughness = new ArrayList<Color>();
        normal = new ArrayList<Color>();
        poison = new ArrayList<Color>();
        wither = new ArrayList<Color>();
        absorption = new ArrayList<Color>();
        absorptionPoison = new ArrayList<Color>();
        absorptionWither = new ArrayList<Color>();
    }
}

