/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.impl.overlays.vanilla;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import tfar.classicbar.config.ClassicBarsConfig;
import tfar.classicbar.config.ConfigCache;
import tfar.classicbar.impl.BarOverlayImpl;
import tfar.classicbar.util.Color;
import tfar.classicbar.util.HealthEffect;
import tfar.classicbar.util.ModUtils;

public class Absorption
extends BarOverlayImpl {
    public Absorption() {
        super("absorption");
    }

    @Override
    public boolean shouldRender(Player player) {
        return player.m_6103_() > 0.0f;
    }

    @Override
    public void renderBar(ForgeGui gui, GuiGraphics graphics, Player player, int screenWidth, int screenHeight, int vOffset) {
        double absorb = player.m_6103_();
        double barWidth = this.getBarWidth(player);
        int xStart = screenWidth / 2 + this.getHOffset();
        int yStart = screenHeight - vOffset;
        double maxHealth = player.m_21233_();
        if (this.rightHandSide()) {
            xStart = (int)((double)xStart + (77.0 - barWidth));
        }
        int index = Math.min((int)Math.ceil(absorb / maxHealth), ConfigCache.absorption.size()) - 1;
        Color primary = this.getPrimaryBarColor(index, player);
        Color.reset();
        this.renderBarBackground(graphics, player, screenWidth, screenHeight, vOffset);
        if (index == 0) {
            primary.color2Gl();
            this.renderPartialBar(graphics, xStart + 2, yStart + 2, barWidth);
        } else {
            Color secondary = this.getSecondaryBarColor(index - 1, player);
            secondary.color2Gl();
            this.renderFullBar(graphics, xStart + 2, yStart + 2);
            if (absorb % maxHealth != 0.0 && index < ConfigCache.absorption.size() - 1) {
                primary.color2Gl();
                this.renderPartialBar(graphics, xStart + 2, yStart + 2, ModUtils.getWidth(absorb % maxHealth, maxHealth));
            }
        }
    }

    @Override
    public double getBarWidth(Player player) {
        double absorb = player.m_6103_();
        double maxHealth = player.m_21233_();
        return (int)Math.ceil(77.0 * Math.min(maxHealth, absorb) / maxHealth);
    }

    @Override
    public Color getPrimaryBarColor(int index, Player player) {
        HealthEffect effect = this.getHealthEffect(player);
        switch (effect) {
            case NONE: {
                return ConfigCache.absorption.get(index);
            }
            case POISON: {
                return ConfigCache.absorptionPoison.get(index);
            }
            case WITHER: {
                return ConfigCache.absorptionWither.get(index);
            }
        }
        return super.getPrimaryBarColor(index, player);
    }

    @Override
    public boolean isFitted() {
        return (Boolean)ClassicBarsConfig.fullAbsorptionBar.get() == false;
    }

    @Override
    public void renderText(GuiGraphics graphics, Player player, int width, int height, int vOffset) {
        double absorb = player.m_6103_();
        double maxHealth = player.m_21233_();
        int xStart = width / 2 + this.getIconOffset();
        int yStart = height - vOffset;
        int index = Math.min((int)Math.ceil(absorb / maxHealth), ConfigCache.absorption.size()) - 1;
        Color c = this.getPrimaryBarColor(index, player);
        this.textHelper(graphics, xStart, yStart, absorb, c.colorToText());
    }

    @Override
    public void renderIcon(GuiGraphics graphics, Player player, int width, int height, int vOffset) {
        int xStart = width / 2 + this.getIconOffset();
        int yStart = height - vOffset;
        int i5 = player.m_9236_().m_6106_().m_5466_() ? 5 : 0;
        ModUtils.drawTexturedModalRect(graphics, xStart, yStart, 16, 9 * i5, 9.0, 9);
        ModUtils.drawTexturedModalRect(graphics, xStart, yStart, 160, 0, 9.0, 9);
    }
}

