/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.impl.overlays.vanilla;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import tfar.classicbar.impl.BarOverlayImpl;
import tfar.classicbar.util.Color;
import tfar.classicbar.util.ColorUtils;
import tfar.classicbar.util.HealthEffect;
import tfar.classicbar.util.ModUtils;

public class Health
extends BarOverlayImpl {
    private double playerHealth = 0.0;
    private long healthUpdateCounter = 0L;
    private double lastPlayerHealth = 0.0;

    public Health() {
        super("health");
    }

    @Override
    public boolean shouldRender(Player player) {
        return true;
    }

    @Override
    public void renderBar(ForgeGui gui, GuiGraphics graphics, Player player, int screenWidth, int screenHeight, int vOffset) {
        boolean highlight;
        int updateCounter = gui.m_93079_();
        double health = player.m_21223_();
        double barWidth = this.getBarWidth(player);
        boolean bl = highlight = this.healthUpdateCounter > (long)updateCounter && (this.healthUpdateCounter - (long)updateCounter) / 3L % 2L == 1L;
        if (health < this.playerHealth && player.f_19802_ > 0) {
            this.healthUpdateCounter = updateCounter + 20;
            this.lastPlayerHealth = this.playerHealth;
        } else if (health > this.playerHealth && player.f_19802_ > 0) {
            this.healthUpdateCounter = updateCounter + 10;
        }
        this.playerHealth = health;
        double d = player.f_19802_;
        Objects.requireNonNull(player);
        double displayHealth = health + (this.lastPlayerHealth - health) * (d / 20.0);
        int xStart = screenWidth / 2 + this.getHOffset();
        int yStart = screenHeight - vOffset;
        double maxHealth = player.m_21233_();
        HealthEffect effect = this.getHealthEffect(player);
        int i4 = highlight ? 18 : 0;
        Color.reset();
        ModUtils.drawTexturedModalRect(graphics, xStart, yStart, 0, i4, 81.0, 9);
        double f = (double)xStart + (this.rightHandSide() ? 77.0 - barWidth : 0.0);
        if (displayHealth != health && displayHealth > health) {
            Color.reset();
            double w = ModUtils.getWidth(displayHealth, maxHealth);
            double off = this.rightHandSide() ? w - barWidth : 0.0;
            this.renderPartialBar(graphics, f + 2.0 - off, yStart + 2, w);
        }
        Color primary = this.getPrimaryBarColor(0, player);
        primary.color2Gl();
        this.renderPartialBar(graphics, f + 2.0, yStart + 2, barWidth);
        if (effect == HealthEffect.POISON) {
            RenderSystem.setShaderColor((float)0.0f, (float)0.5f, (float)0.0f, (float)0.5f);
            ModUtils.drawTexturedModalRect(graphics, f + 1.0, yStart + 1, 1, 36, barWidth, 7);
        }
    }

    @Override
    public Color getPrimaryBarColor(int index, Player player) {
        double health = player.m_21223_();
        double maxHealth = player.m_21233_();
        HealthEffect effect = this.getHealthEffect(player);
        return ColorUtils.calculateScaledColor(health, maxHealth, effect);
    }

    @Override
    public double getBarWidth(Player player) {
        double health = player.m_21223_();
        double maxHealth = player.m_21233_();
        return 77.0 * health / maxHealth;
    }

    @Override
    public void renderText(GuiGraphics graphics, Player player, int width, int height, int vOffset) {
        double health = player.m_21223_();
        int xStart = width / 2 + this.getIconOffset();
        int yStart = height - vOffset;
        this.textHelper(graphics, xStart, yStart, health, this.getPrimaryBarColor(0, player).colorToText());
    }

    @Override
    public void renderIcon(GuiGraphics graphics, Player player, int width, int height, int vOffset) {
        HealthEffect effect = this.getHealthEffect(player);
        int xStart = width / 2 + this.getIconOffset();
        int yStart = height - vOffset;
        int i5 = player.m_9236_().m_6106_().m_5466_() ? 5 : 0;
        Color.reset();
        ModUtils.drawTexturedModalRect(graphics, xStart, yStart, 16, 9 * i5, 9.0, 9);
        ModUtils.drawTexturedModalRect(graphics, xStart, yStart, 36 + effect.i, 9 * i5, 9.0, 9);
    }
}

