/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.util;

import com.mojang.blaze3d.systems.RenderSystem;

public class Color {
    public final int r;
    public final int g;
    public final int b;
    public static final Color BLACK = Color.from(0, 0, 0);
    public static final Color RED = Color.from(255, 0, 0);
    public static final Color YELLOW = Color.from(255, 255, 0);

    protected Color(int red, int green, int blue) {
        this.r = red;
        this.g = green;
        this.b = blue;
    }

    public static Color from(int red, int green, int blue) {
        return new Color(red, green, blue);
    }

    public static Color from(String s) {
        return BLACK;
    }

    public void color2Gl() {
        this.color2Gla(1.0f);
    }

    public Color colorBlend(Color c2, double d) {
        int r = (int)Math.floor((double)this.r * (1.0 - d) + (double)c2.r * d);
        int g = (int)Math.floor((double)this.g * (1.0 - d) + (double)c2.g * d);
        int b = (int)Math.floor((double)this.b * (1.0 - d) + (double)c2.b * d);
        return Color.from(r, g, b);
    }

    public int colorToText() {
        return (this.r << 16) + (this.g << 8) + this.b;
    }

    public void color2Gla(float a) {
        float r = (float)this.r / 255.0f;
        float g = (float)this.g / 255.0f;
        float b = (float)this.b / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public static void reset() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

