/*
 * Decompiled with CFR 0.152.
 */
package tfar.classicbar.util;

import java.util.List;
import tfar.classicbar.config.ClassicBarsConfig;
import tfar.classicbar.config.ConfigCache;
import tfar.classicbar.util.Color;
import tfar.classicbar.util.HealthEffect;

public class ColorUtils {
    public static Color hex2Color(String s) {
        int i1 = Integer.decode(s);
        int r = i1 >> 16 & 0xFF;
        int g = i1 >> 8 & 0xFF;
        int b = i1 & 0xFF;
        return Color.from(r, g, b);
    }

    public static Color calculateScaledColor(double d1, double d2, HealthEffect effect) {
        List colorFractions;
        List<Color> colorCodes;
        double d3 = d1 / d2;
        switch (effect) {
            case NONE: {
                colorCodes = ConfigCache.normal;
                colorFractions = (List)ClassicBarsConfig.normalFractions.get();
                break;
            }
            case POISON: {
                colorCodes = ConfigCache.poison;
                colorFractions = (List)ClassicBarsConfig.poisonedFractions.get();
                break;
            }
            case WITHER: {
                colorCodes = ConfigCache.wither;
                colorFractions = (List)ClassicBarsConfig.witheredFractions.get();
                break;
            }
            default: {
                return Color.BLACK;
            }
        }
        if (colorCodes.size() != colorFractions.size()) {
            return Color.BLACK;
        }
        int i1 = colorFractions.size() - 1;
        int i3 = 0;
        for (int i2 = 0; i2 < i1 && !(d3 < (Double)colorFractions.get(i2)); ++i2) {
            ++i3;
        }
        if (d3 <= (Double)colorFractions.get(0)) {
            return colorCodes.get(0);
        }
        if (d3 >= (Double)colorFractions.get(colorFractions.size() - 1)) {
            return colorCodes.get(colorCodes.size() - 1);
        }
        Color c1 = colorCodes.get(i3 - 1);
        Color c2 = colorCodes.get(i3);
        double d4 = d3 - (Double)colorFractions.get(i3 - 1) / ((Double)colorFractions.get(i3) - (Double)colorFractions.get(i3 - 1));
        return c1.colorBlend(c2, d4);
    }
}

